/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.nio.ByteBuffer;
import jnr.constants.platform.Errno;
import jnr.constants.platform.Fcntl;
import jnr.ffi.Runtime;
import jnr.posix.DefaultNativeTimeval;
import jnr.posix.Timeval;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.rope.BytesVisitor;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeConstants;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.rubinius.PointerPrimitiveNodes;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadManager;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.AllocateObjectNode;
import org.jruby.truffle.language.objects.AllocateObjectNodeGen;
import org.jruby.truffle.platform.UnsafeGroup;
import org.jruby.truffle.platform.posix.FDSet;
import org.jruby.util.ByteList;
import org.jruby.util.Dir;
import org.jruby.util.unsafe.UnsafeHolder;

public abstract class IOPrimitiveNodes {
    private static int STDOUT = 1;

    @RubiniusPrimitive(name="io_select", needsSelf=false, lowerFixnumParameters={3}, unsafe={UnsafeGroup.IO})
    public static abstract class IOSelectPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(readables)", "isNil(writables)", "isNil(errorables)", "isNil(noTimeout)"})
        public Object select(DynamicObject readables, DynamicObject writables, DynamicObject errorables, DynamicObject noTimeout) {
            Object result;
            while ((result = this.select(readables, writables, errorables, Integer.MAX_VALUE)) == this.nil()) {
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyArray(readables)", "isNil(writables)", "isNil(errorables)"})
        public Object select(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeoutMicros) {
            Object[] readableObjects = ArrayOperations.toObjectArray(readables);
            final int[] readableFds = this.getFileDescriptors(readables);
            final int nfds = IOSelectPrimitiveNode.max(readableFds) + 1;
            final FDSet readableSet = new FDSet();
            ThreadManager.ResultOrTimeout<Integer> result = this.getContext().getThreadManager().runUntilTimeout(this, timeoutMicros, new ThreadManager.BlockingTimeoutAction<Integer>(){

                @Override
                public Integer block(Timeval timeoutToUse) throws InterruptedException {
                    for (int fd : readableFds) {
                        readableSet.set(fd);
                    }
                    int result = this.callSelect(nfds, readableSet, timeoutToUse);
                    if (result == 0) {
                        return null;
                    }
                    return result;
                }

                private int callSelect(int nfds2, FDSet readableSet2, Timeval timeoutToUse) {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(nfds2, readableSet2.getPointer(), PointerPrimitiveNodes.NULL_POINTER, PointerPrimitiveNodes.NULL_POINTER, timeoutToUse);
                }
            });
            if (result instanceof ThreadManager.TimedOut) {
                return this.nil();
            }
            int resultCode = this.ensureSuccessful((Integer)((ThreadManager.ResultWithinTime)result).getValue());
            if (resultCode == 0) {
                return this.nil();
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{this.getSetObjects(readableObjects, readableFds, readableSet), Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0), Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0)}, 3);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isNil(readables)", "isRubyArray(writables)", "isNil(errorables)"})
        public Object selectNilReadables(DynamicObject readables, DynamicObject writables, DynamicObject errorables, int timeout) {
            Object[] writableObjects = ArrayOperations.toObjectArray(writables);
            final int[] writableFds = this.getFileDescriptors(writables);
            final int nfds = IOSelectPrimitiveNode.max(writableFds) + 1;
            final FDSet writableSet = new FDSet();
            int result = this.getContext().getThreadManager().runUntilResult(this, new ThreadManager.BlockingAction<Integer>(){

                @Override
                public Integer block() throws InterruptedException {
                    for (int fd : writableFds) {
                        writableSet.set(fd);
                    }
                    return this.callSelect(nfds, writableSet);
                }

                private int callSelect(int nfds2, FDSet writableSet2) {
                    return IOSelectPrimitiveNode.this.nativeSockets().select(nfds2, PointerPrimitiveNodes.NULL_POINTER, writableSet2.getPointer(), PointerPrimitiveNodes.NULL_POINTER, null);
                }
            });
            this.ensureSuccessful(result);
            assert (result != 0);
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), new Object[]{Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0), this.getSetObjects(writableObjects, writableFds, writableSet), Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), null, 0)}, 3);
        }

        private int[] getFileDescriptors(DynamicObject fileDescriptorArray) {
            assert (RubyGuards.isRubyArray(fileDescriptorArray));
            Object[] objects = ArrayOperations.toObjectArray(fileDescriptorArray);
            int[] fileDescriptors = new int[objects.length];
            for (int n = 0; n < objects.length; ++n) {
                if (!(objects[n] instanceof DynamicObject)) {
                    throw new UnsupportedOperationException();
                }
                fileDescriptors[n] = Layouts.IO.getDescriptor((DynamicObject)objects[n]);
            }
            return fileDescriptors;
        }

        private static int max(int[] values) {
            assert (values.length > 0);
            int max = Integer.MIN_VALUE;
            for (int n = 0; n < values.length; ++n) {
                max = Math.max(max, values[n]);
            }
            return max;
        }

        private DynamicObject getSetObjects(Object[] objects, int[] fds, FDSet set) {
            Object[] setObjects = new Object[objects.length];
            int setFdsCount = 0;
            for (int n = 0; n < objects.length; ++n) {
                if (!set.isSet(fds[n])) continue;
                setObjects[setFdsCount] = objects[n];
                ++setFdsCount;
            }
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), setObjects, setFdsCount);
        }
    }

    @RubiniusPrimitive(name="io_sysread", unsafe={UnsafeGroup.IO})
    public static abstract class IOSysReadPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject sysread(VirtualFrame frame, DynamicObject file, int length) {
            int bytesRead;
            int fd = Layouts.IO.getDescriptor(file);
            ByteBuffer buffer = ByteBuffer.allocate(length);
            for (int toRead = length; toRead > 0; toRead -= bytesRead) {
                this.getContext().getSafepointManager().poll(this);
                bytesRead = this.ensureSuccessful(this.posix().read(fd, buffer, toRead));
                if (bytesRead == 0) {
                    if (toRead != length) break;
                    return this.nil();
                }
                buffer.position(bytesRead);
            }
            return this.createString(new ByteList(buffer.array(), buffer.arrayOffset(), buffer.position(), false));
        }
    }

    @RubiniusPrimitive(name="io_accept", unsafe={UnsafeGroup.IO})
    public static abstract class AcceptNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int accept(DynamicObject io) {
            int newFd;
            int fd = Layouts.IO.getDescriptor(io);
            int[] addressLength = new int[]{16};
            long address = UnsafeHolder.U.allocateMemory(addressLength[0]);
            try {
                newFd = this.ensureSuccessful(this.nativeSockets().accept(fd, this.memoryManager().newPointer(address), addressLength));
            }
            finally {
                UnsafeHolder.U.freeMemory(address);
            }
            return newFd;
        }
    }

    @RubiniusPrimitive(name="io_seek", lowerFixnumParameters={0, 1}, unsafe={UnsafeGroup.IO})
    public static abstract class IOSeekPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int seek(VirtualFrame frame, DynamicObject io, int amount, int whence) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.posix().lseek(fd, amount, whence);
        }
    }

    @RubiniusPrimitive(name="io_close", unsafe={UnsafeGroup.IO})
    public static abstract class IOClosePrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode ensureOpenNode;

        public IOClosePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.ensureOpenNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @Specialization
        public int close(VirtualFrame frame, DynamicObject io) {
            this.ensureOpenNode.call(frame, io, "ensure_open", null, new Object[0]);
            int fd = Layouts.IO.getDescriptor(io);
            if (fd == -1) {
                return 0;
            }
            int newDescriptor = -1;
            Layouts.IO.setDescriptor(io, newDescriptor);
            if (fd < 3) {
                return 0;
            }
            this.ensureSuccessful(this.posix().close(fd));
            return 0;
        }
    }

    @RubiniusPrimitive(name="io_write", unsafe={UnsafeGroup.IO})
    public static abstract class IOWritePrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(string)"})
        public int write(DynamicObject file, DynamicObject string) {
            final int fd = Layouts.IO.getDescriptor(file);
            Rope rope = StringOperations.rope(string);
            if (this.getContext().getDebugStandardOut() != null && fd == STDOUT) {
                this.getContext().getDebugStandardOut().write(rope.getBytes(), 0, rope.byteLength());
                return rope.byteLength();
            }
            RopeOperations.visitBytes(rope, new BytesVisitor(){

                @Override
                public void accept(byte[] bytes, int offset, int length) {
                    ByteBuffer buffer = ByteBuffer.wrap(bytes, offset, length);
                    while (buffer.hasRemaining()) {
                        IOWritePrimitiveNode.this.getContext().getSafepointManager().poll(IOWritePrimitiveNode.this);
                        int written = IOWritePrimitiveNode.this.ensureSuccessful(IOWritePrimitiveNode.this.posix().write(fd, buffer, buffer.remaining()));
                        buffer.position(buffer.position() + written);
                    }
                }
            });
            return rope.byteLength();
        }
    }

    @RubiniusPrimitive(name="io_reopen_path", lowerFixnumParameters={1}, unsafe={UnsafeGroup.IO})
    public static abstract class IOReopenPathPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPathPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        /*
         * Enabled aggressive block sorting
         */
        @CompilerDirectives.TruffleBoundary
        public void performReopenPath(DynamicObject file, DynamicObject path, int mode) {
            int fd;
            block4: {
                fd = Layouts.IO.getDescriptor(file);
                String pathString = StringOperations.getString(this.getContext(), path);
                int otherFd = this.ensureSuccessful(this.posix().open(pathString, mode, 666));
                int result = this.posix().dup2(otherFd, fd);
                if (result == -1) {
                    int errno = this.posix().errno();
                    if (errno == Errno.EBADF.intValue()) {
                        Layouts.IO.setDescriptor(file, otherFd);
                        fd = otherFd;
                        break block4;
                    } else {
                        if (otherFd > 0) {
                            this.ensureSuccessful(this.posix().close(otherFd));
                        }
                        CompilerDirectives.transferToInterpreter();
                        throw new RaiseException(this.coreExceptions().errnoError(errno, this));
                    }
                }
                this.ensureSuccessful(this.posix().close(otherFd));
            }
            int newMode = this.ensureSuccessful(this.posix().fcntl(fd, Fcntl.F_GETFL));
            Layouts.IO.setMode(file, newMode);
        }

        @Specialization(guards={"isRubyString(path)"})
        public Object reopenPath(VirtualFrame frame, DynamicObject file, DynamicObject path, int mode) {
            this.performReopenPath(file, path, mode);
            this.resetBufferingNode.call(frame, file, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_reopen", unsafe={UnsafeGroup.IO})
    public static abstract class IOReopenPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode resetBufferingNode;

        public IOReopenPrimitiveNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.resetBufferingNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        @CompilerDirectives.TruffleBoundary
        private void performReopen(DynamicObject self, DynamicObject target) {
            int fdSelf = Layouts.IO.getDescriptor(self);
            int fdTarget = Layouts.IO.getDescriptor(target);
            this.ensureSuccessful(this.posix().dup2(fdTarget, fdSelf));
            int newSelfMode = this.ensureSuccessful(this.posix().fcntl(fdSelf, Fcntl.F_GETFL));
            Layouts.IO.setMode(self, newSelfMode);
        }

        @Specialization
        public Object reopen(VirtualFrame frame, DynamicObject file, DynamicObject io) {
            this.performReopen(file, io);
            this.resetBufferingNode.call(frame, io, "reset_buffering", null, new Object[0]);
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_read_if_available", lowerFixnumParameters={0}, unsafe={UnsafeGroup.IO})
    public static abstract class IOReadIfAvailableNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public Object readIfAvailable(DynamicObject file, int numberOfBytes) {
            if (numberOfBytes == 0) {
                return this.createString(RopeConstants.EMPTY_ASCII_8BIT_ROPE);
            }
            int fd = Layouts.IO.getDescriptor(file);
            FDSet fdSet = new FDSet();
            fdSet.set(fd);
            DefaultNativeTimeval timeoutObject = new DefaultNativeTimeval(Runtime.getSystemRuntime());
            timeoutObject.setTime(new long[]{0L, 0L});
            int res = this.ensureSuccessful(this.nativeSockets().select(fd + 1, fdSet.getPointer(), PointerPrimitiveNodes.NULL_POINTER, PointerPrimitiveNodes.NULL_POINTER, (Timeval)timeoutObject));
            if (res == 0) {
                throw new RaiseException(Layouts.CLASS.getInstanceFactory(this.coreLibrary().getEagainWaitReadable()).newInstance(this.coreStrings().RESOURCE_TEMP_UNAVAIL.createInstance(), Errno.EAGAIN.intValue()));
            }
            byte[] bytes = new byte[numberOfBytes];
            int bytesRead = this.ensureSuccessful(this.posix().read(fd, bytes, numberOfBytes));
            if (bytesRead == 0) {
                return this.nil();
            }
            return this.createString(new ByteList(bytes, 0, bytesRead, false));
        }
    }

    @RubiniusPrimitive(name="io_ensure_open", unsafe={UnsafeGroup.IO})
    public static abstract class IOEnsureOpenPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject ensureOpen(VirtualFrame frame, DynamicObject file) {
            int fd = Layouts.IO.getDescriptor(file);
            if (fd == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().ioError("closed stream", this));
            }
            if (fd == -2) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().ioError("shutdown stream", this));
            }
            return this.nil();
        }
    }

    @RubiniusPrimitive(name="io_fnmatch", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOFNMatchPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(pattern)", "isRubyString(path)"})
        public boolean fnmatch(DynamicObject pattern, DynamicObject path, int flags) {
            Rope patternRope = StringOperations.rope(pattern);
            Rope pathRope = StringOperations.rope(path);
            return Dir.fnmatch((byte[])patternRope.getBytes(), (int)0, (int)patternRope.byteLength(), (byte[])pathRope.getBytes(), (int)0, (int)pathRope.byteLength(), (int)flags) != 1;
        }
    }

    @RubiniusPrimitive(name="io_ftruncate", unsafe={UnsafeGroup.IO})
    public static abstract class IOFTruncatePrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int ftruncate(VirtualFrame frame, DynamicObject io, long length) {
            int fd = Layouts.IO.getDescriptor(io);
            return this.ensureSuccessful(this.posix().ftruncate(fd, length));
        }
    }

    @RubiniusPrimitive(name="io_truncate", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOTruncatePrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(path)"})
        public int truncate(DynamicObject path, long length) {
            return this.ensureSuccessful(this.posix().truncate(StringOperations.getString(this.getContext(), path), length));
        }
    }

    @RubiniusPrimitive(name="io_open", needsSelf=false, lowerFixnumParameters={1, 2}, unsafe={UnsafeGroup.IO})
    public static abstract class IOOpenPrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(path)"})
        public int open(DynamicObject path, int mode, int permission) {
            return this.ensureSuccessful(this.posix().open(StringOperations.getString(this.getContext(), path), mode, permission));
        }
    }

    @RubiniusPrimitive(name="io_connect_pipe", needsSelf=false, unsafe={UnsafeGroup.IO})
    public static abstract class IOConnectPipeNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.CompilationFinal
        private int RDONLY = -1;
        @CompilerDirectives.CompilationFinal
        private int WRONLY = -1;

        @Specialization
        public boolean connectPipe(DynamicObject lhs, DynamicObject rhs) {
            int[] fds = new int[2];
            this.ensureSuccessful(this.posix().pipe(fds));
            this.newOpenFd(fds[0]);
            this.newOpenFd(fds[1]);
            Layouts.IO.setDescriptor(lhs, fds[0]);
            Layouts.IO.setMode(lhs, this.getRDONLY());
            Layouts.IO.setDescriptor(rhs, fds[1]);
            Layouts.IO.setMode(rhs, this.getWRONLY());
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private void newOpenFd(int newFd) {
            boolean FD_CLOEXEC = true;
            if (newFd > 2) {
                int flags = this.ensureSuccessful(this.posix().fcntl(newFd, Fcntl.F_GETFD));
                this.ensureSuccessful(this.posix().fcntlInt(newFd, Fcntl.F_SETFD, flags | 1));
            }
        }

        private int getRDONLY() {
            if (this.RDONLY == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.RDONLY = (Integer)this.getContext().getNativePlatform().getRubiniusConfiguration().get("rbx.platform.file.O_RDONLY");
            }
            return this.RDONLY;
        }

        private int getWRONLY() {
            if (this.WRONLY == -1) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.WRONLY = (Integer)this.getContext().getNativePlatform().getRubiniusConfiguration().get("rbx.platform.file.O_WRONLY");
            }
            return this.WRONLY;
        }
    }

    @RubiniusPrimitive(name="io_allocate", unsafe={UnsafeGroup.IO})
    public static abstract class IOAllocatePrimitiveNode
    extends IORubiniusPrimitiveArrayArgumentsNode {
        @Node.Child
        private CallDispatchHeadNode newBufferNode;
        @Node.Child
        private AllocateObjectNode allocateNode;

        public IOAllocatePrimitiveNode(RubyContext context, SourceSection sourceSection) {
            this.newBufferNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.allocateNode = AllocateObjectNodeGen.create(context, sourceSection, null, null);
        }

        @Specialization
        public DynamicObject allocate(VirtualFrame frame, DynamicObject classToAllocate) {
            DynamicObject buffer = (DynamicObject)this.newBufferNode.call(frame, this.coreLibrary().getInternalBufferClass(), "new", null, new Object[0]);
            return this.allocateNode.allocate(classToAllocate, buffer, 0, 0, 0);
        }
    }

    public static abstract class IORubiniusPrimitiveArrayArgumentsNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        public IORubiniusPrimitiveArrayArgumentsNode() {
        }

        public IORubiniusPrimitiveArrayArgumentsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        protected int ensureSuccessful(int result) {
            assert (result >= -1);
            if (result == -1) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.coreExceptions().errnoError(this.posix().errno(), this));
            }
            return result;
        }
    }
}

