/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.util.Random;
import org.jruby.RubyRandom;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;

public abstract class RandomizerPrimitiveNodes {
    @CompilerDirectives.TruffleBoundary
    private static int randomInt(org.jruby.util.Random random) {
        return random.genrandInt32();
    }

    @RubiniusPrimitive(name="randomizer_gen_seed")
    public static abstract class RandomizerGenSeedPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject randomizerGenSeed(DynamicObject randomizerClass) {
            BigInteger seed = RubyRandom.randomSeedBigInteger((Random)this.getContext().getJRubyRuntime().getRandom());
            return this.createBignum(seed);
        }
    }

    @RubiniusPrimitive(name="randomizer_rand_int")
    public static abstract class RandomizerRandIntPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public int randomizerRandInt(DynamicObject randomizer, int limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return (int)RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @Specialization
        public long randomizerRandInt(DynamicObject randomizer, long limit) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            return RandomizerRandIntPrimitiveNode.randInt(r, limit);
        }

        @CompilerDirectives.TruffleBoundary
        protected static long randInt(org.jruby.util.Random r, long limit) {
            return RubyRandom.randLimitedFixnumInner((org.jruby.util.Random)r, (long)limit);
        }
    }

    @RubiniusPrimitive(name="randomizer_rand_float")
    public static abstract class RandomizerRandFloatPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public double randomizerRandFloat(DynamicObject randomizer) {
            org.jruby.util.Random r = Layouts.RANDOMIZER.getRandom(randomizer);
            int a = RandomizerPrimitiveNodes.randomInt(r) >>> 5;
            int b = RandomizerPrimitiveNodes.randomInt(r) >>> 6;
            return ((double)a * 6.7108864E7 + (double)b) * (double)1.110223E-16f;
        }
    }

    @RubiniusPrimitive(name="randomizer_seed")
    public static abstract class RandomizerSeedPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyBignum(seed)"})
        public DynamicObject randomizerSeed(DynamicObject randomizer, DynamicObject seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromBigInteger(Layouts.BIGNUM.getValue(seed)));
            return randomizer;
        }

        @Specialization
        public DynamicObject randomizerSeed(DynamicObject randomizer, long seed) {
            Layouts.RANDOMIZER.setRandom(randomizer, RandomizerSeedPrimitiveNode.randomFromLong(seed));
            return randomizer;
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromBigInteger(BigInteger seed) {
            return RubyRandom.RandomType.randomFromBigInteger((BigInteger)seed);
        }

        @CompilerDirectives.TruffleBoundary
        protected static org.jruby.util.Random randomFromLong(long seed) {
            return RubyRandom.RandomType.randomFromLong((long)seed);
        }
    }

    @RubiniusPrimitive(name="randomizer_allocate", needsSelf=false)
    public static abstract class RandomizerAllocatePrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject randomizerAllocate() {
            return Layouts.RANDOMIZER.createRandomizer(this.coreLibrary().getRandomizerFactory(), new org.jruby.util.Random());
        }
    }
}

