/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.instrumentation.EventBinding;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;

@CoreClass(name="Truffle::Attachments::Internal")
public abstract class AttachmentsInternalNodes {

    @CoreMethod(names={"detach"}, onSingleton=true, required=1)
    public static abstract class DetachNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isHandle(handle)"})
        public DynamicObject detach(DynamicObject handle) {
            ((EventBinding)Layouts.HANDLE.getObject(handle)).dispose();
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"attach"}, onSingleton=true, required=2, needsBlock=true)
    public static abstract class AttachNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"isRubyString(file)"})
        public DynamicObject attach(DynamicObject file, int line, DynamicObject block) {
            return this.handle(this.getContext().getAttachmentsManager().attach(file.toString(), line, block));
        }
    }
}

