/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNode;
import org.jruby.truffle.language.objects.ReadObjectFieldNodeGen;

@NodeChildren(value={@NodeChild(value="receiver"), @NodeChild(value="name"), @NodeChild(value="stringName"), @NodeChild(value="startsAt")})
abstract class ForeignReadStringCachedHelperNode
extends RubyNode {
    @Node.Child
    private DoesRespondDispatchHeadNode definedNode;
    @Node.Child
    private DoesRespondDispatchHeadNode indexDefinedNode;
    @Node.Child
    private CallDispatchHeadNode callNode;
    protected static final String INDEX_METHOD_NAME = "[]";

    ForeignReadStringCachedHelperNode() {
    }

    public abstract Object executeStringCachedHelper(VirtualFrame var1, DynamicObject var2, Object var3, String var4, boolean var5);

    @Specialization(guards={"startsAt(startsAt)"})
    public Object readInstanceVariable(DynamicObject receiver, Object name, String stringName, boolean startsAt, @Cached(value="createReadObjectFieldNode(stringName)") ReadObjectFieldNode readObjectFieldNode) {
        return readObjectFieldNode.execute(receiver);
    }

    protected boolean startsAt(boolean startsAt) {
        return startsAt;
    }

    protected ReadObjectFieldNode createReadObjectFieldNode(String name) {
        return ReadObjectFieldNodeGen.create(name, this.nil());
    }

    @Specialization(guards={"notStartsAt(startsAt)", "methodDefined(frame, receiver, stringName, getDefinedNode())"})
    public Object callMethod(VirtualFrame frame, DynamicObject receiver, Object name, String stringName, boolean startsAt) {
        return this.getCallNode().call(frame, receiver, stringName, null, new Object[0]);
    }

    @Specialization(guards={"notStartsAt(startsAt)", "!methodDefined(frame, receiver, stringName, getDefinedNode())", "methodDefined(frame, receiver, INDEX_METHOD_NAME, getIndexDefinedNode())"})
    public Object index(VirtualFrame frame, DynamicObject receiver, Object name, String stringName, boolean startsAt) {
        return this.getCallNode().call(frame, receiver, INDEX_METHOD_NAME, null, name);
    }

    protected boolean notStartsAt(boolean startsAt) {
        return !startsAt;
    }

    protected DoesRespondDispatchHeadNode getDefinedNode() {
        if (this.definedNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.definedNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), true));
        }
        return this.definedNode;
    }

    protected DoesRespondDispatchHeadNode getIndexDefinedNode() {
        if (this.indexDefinedNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.indexDefinedNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), true));
        }
        return this.indexDefinedNode;
    }

    protected boolean methodDefined(VirtualFrame frame, DynamicObject receiver, String stringName, DoesRespondDispatchHeadNode definedNode) {
        return definedNode.doesRespondTo(frame, stringName, receiver);
    }

    protected CallDispatchHeadNode getCallNode() {
        if (this.callNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.callNode = this.insert(DispatchHeadNodeFactory.createMethodCall(this.getContext(), true));
        }
        return this.callNode;
    }
}

