/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.interop.InteropNodes;
import org.jruby.truffle.interop.ToJavaStringNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=InteropNodes.class)
public final class InteropNodesFactory {
    public static List<NodeFactory<? extends CoreMethodArrayArgumentsNode>> getFactories() {
        return Arrays.asList(IsExecutableNodeFactory.getInstance(), ExecuteNodeFactory.getInstance(), InvokeNodeFactory.getInstance(), HasSizeNodeFactory.getInstance(), SizeNodeFactory.getInstance(), BoxedNodeFactory.getInstance(), UnboxNodeFactory.getInstance(), NullNodeFactory.getInstance(), ReadNodeFactory.getInstance(), WriteNodeFactory.getInstance(), ExportNodeFactory.getInstance(), ImportNodeFactory.getInstance(), MimeTypeSupportedNodeFactory.getInstance(), EvalNodeFactory.getInstance());
    }

    @GeneratedBy(value=InteropNodes.EvalNode.class)
    public static final class EvalNodeFactory
    extends NodeFactoryBase<InteropNodes.EvalNode> {
        private static EvalNodeFactory evalNodeFactoryInstance;

        private EvalNodeFactory() {
            super(InteropNodes.EvalNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.EvalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EvalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.EvalNode> getInstance() {
            if (evalNodeFactoryInstance == null) {
                evalNodeFactoryInstance = new EvalNodeFactory();
            }
            return evalNodeFactoryInstance;
        }

        public static InteropNodes.EvalNode create(RubyNode[] arguments) {
            return new EvalNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.EvalNode.class)
        public static final class EvalNodeGen
        extends InteropNodes.EvalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeEvalCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private EvalNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="evalUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)", value=InteropNodes.EvalNode.class)
            private static final class EvalUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private IndirectCallNode callNode;

                EvalUncachedNode_(EvalNodeGen root, IndirectCallNode callNode) {
                    super(root, 2);
                    this.callNode = callNode;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.evalUncached(frameValue, arguments0Value_, arguments1Value_, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EvalNodeGen root, IndirectCallNode callNode) {
                    return new EvalUncachedNode_(root, callNode);
                }
            }

            @GeneratedBy(methodName="evalCached(VirtualFrame, DynamicObject, DynamicObject, Rope, Rope, DirectCallNode)", value=InteropNodes.EvalNode.class)
            private static final class EvalCachedNode_
            extends BaseNode_ {
                private final Rope cachedMimeType;
                private final Rope cachedSource;
                @Node.Child
                private DirectCallNode callNode;

                EvalCachedNode_(EvalNodeGen root, Rope cachedMimeType, Rope cachedSource, DirectCallNode callNode) {
                    super(root, 1);
                    this.cachedMimeType = cachedMimeType;
                    this.cachedSource = cachedSource;
                    this.callNode = callNode;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == EvalUncachedNode_.class) {
                        this.removeSame("Contained by evalUncached(VirtualFrame, DynamicObject, DynamicObject, IndirectCallNode)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments0Value_, this.cachedMimeType) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedSource)) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments0Value_, this.cachedMimeType) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedSource)) {
                            return this.root.evalCached(frameValue, arguments0Value_, arguments1Value_, this.cachedMimeType, this.cachedSource, this.callNode);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EvalNodeGen root, Rope cachedMimeType, Rope cachedSource, DirectCallNode callNode) {
                    return new EvalCachedNode_(root, cachedMimeType, cachedSource, callNode);
                }
            }

            @GeneratedBy(value=InteropNodes.EvalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EvalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.EvalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EvalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EvalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.EvalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EvalNodeGen root;

                BaseNode_(EvalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EvalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DirectCallNode callNode1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Rope cachedMimeType1 = StringCachingGuards.privatizeRope(arguments0Value_);
                        Rope cachedSource1 = StringCachingGuards.privatizeRope(arguments1Value_);
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments0Value_, cachedMimeType1) && StringCachingGuards.ropesEqual(arguments1Value_, cachedSource1) && !this.root.excludeEvalCached_ && this.countSame(s = EvalCachedNode_.create(this.root, cachedMimeType1, cachedSource1, callNode1 = DirectCallNode.create(this.root.parse(arguments0Value_, arguments1Value_)))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            IndirectCallNode callNode2 = IndirectCallNode.create();
                            this.root.excludeEvalCached_ = true;
                            return EvalUncachedNode_.create(this.root, callNode2);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.MimeTypeSupportedNode.class)
    public static final class MimeTypeSupportedNodeFactory
    extends NodeFactoryBase<InteropNodes.MimeTypeSupportedNode> {
        private static MimeTypeSupportedNodeFactory mimeTypeSupportedNodeFactoryInstance;

        private MimeTypeSupportedNodeFactory() {
            super(InteropNodes.MimeTypeSupportedNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.MimeTypeSupportedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MimeTypeSupportedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.MimeTypeSupportedNode> getInstance() {
            if (mimeTypeSupportedNodeFactoryInstance == null) {
                mimeTypeSupportedNodeFactoryInstance = new MimeTypeSupportedNodeFactory();
            }
            return mimeTypeSupportedNodeFactoryInstance;
        }

        public static InteropNodes.MimeTypeSupportedNode create(RubyNode[] arguments) {
            return new MimeTypeSupportedNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.MimeTypeSupportedNode.class)
        public static final class MimeTypeSupportedNodeGen
        extends InteropNodes.MimeTypeSupportedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MimeTypeSupportedNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_)) {
                    return this.isMimeTypeSupported(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=InteropNodes.ImportNode.class)
    public static final class ImportNodeFactory
    extends NodeFactoryBase<InteropNodes.ImportNode> {
        private static ImportNodeFactory importNodeFactoryInstance;

        private ImportNodeFactory() {
            super(InteropNodes.ImportNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.ImportNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ImportNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.ImportNode> getInstance() {
            if (importNodeFactoryInstance == null) {
                importNodeFactoryInstance = new ImportNodeFactory();
            }
            return importNodeFactoryInstance;
        }

        public static InteropNodes.ImportNode create(RubyNode[] arguments) {
            return new ImportNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.ImportNode.class)
        public static final class ImportNodeGen
        extends InteropNodes.ImportNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ImportNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_) || RubyGuards.isRubySymbol(arguments0Value_)) {
                    return this.importObject(arguments0Value_);
                }
                throw this.unsupported(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=InteropNodes.ExportNode.class)
    public static final class ExportNodeFactory
    extends NodeFactoryBase<InteropNodes.ExportNode> {
        private static ExportNodeFactory exportNodeFactoryInstance;

        private ExportNodeFactory() {
            super(InteropNodes.ExportNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.ExportNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ExportNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.ExportNode> getInstance() {
            if (exportNodeFactoryInstance == null) {
                exportNodeFactoryInstance = new ExportNodeFactory();
            }
            return exportNodeFactoryInstance;
        }

        public static InteropNodes.ExportNode create(RubyNode[] arguments) {
            return new ExportNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.ExportNode.class)
        public static final class ExportNodeGen
        extends InteropNodes.ExportNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ExportNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                TruffleObject arguments1Value_;
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments1_.execute(frameValue);
                    throw this.unsupported(ex.getResult(), arguments1Value);
                }
                try {
                    arguments1Value_ = ExportNodeGen.expectTruffleObject(this.arguments1_.execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(arguments0Value_, ex.getResult());
                }
                if (RubyGuards.isRubyString(arguments0Value_) || RubyGuards.isRubySymbol(arguments0Value_)) {
                    return this.export(arguments0Value_, arguments1Value_);
                }
                throw this.unsupported(arguments0Value_, arguments1Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value, Object arguments1Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_, this.arguments1_}, arguments0Value, arguments1Value);
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }
        }
    }

    @GeneratedBy(value=InteropNodes.WriteNode.class)
    public static final class WriteNodeFactory
    extends NodeFactoryBase<InteropNodes.WriteNode> {
        private static WriteNodeFactory writeNodeFactoryInstance;

        private WriteNodeFactory() {
            super(InteropNodes.WriteNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.WriteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return WriteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.WriteNode> getInstance() {
            if (writeNodeFactoryInstance == null) {
                writeNodeFactoryInstance = new WriteNodeFactory();
            }
            return writeNodeFactoryInstance;
        }

        public static InteropNodes.WriteNode create(RubyNode[] arguments) {
            return new WriteNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.WriteNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class WriteNodeGen
        extends InteropNodes.WriteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeWriteCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private WriteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="writeUncached(VirtualFrame, TruffleObject, DynamicObject, Object, Node, BranchProfile)", value=InteropNodes.WriteNode.class)
            private static final class WriteUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private Node writeNode;
                private final BranchProfile exceptionProfile;

                WriteUncachedNode_(WriteNodeGen root, Node writeNode, BranchProfile exceptionProfile) {
                    super(root, 4);
                    this.writeNode = writeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.writeUncached(frameValue, arguments0Value_, arguments1Value_, arguments2Value, this.writeNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root, Node writeNode, BranchProfile exceptionProfile) {
                    return new WriteUncachedNode_(root, writeNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="writeCached(VirtualFrame, TruffleObject, DynamicObject, Object, Rope, String, Node, BranchProfile)", value=InteropNodes.WriteNode.class)
            private static final class WriteCachedNode_
            extends BaseNode_ {
                private final Rope cachedIdentifier;
                private final String identifierString;
                @Node.Child
                private Node writeNode;
                private final BranchProfile exceptionProfile;

                WriteCachedNode_(WriteNodeGen root, Rope cachedIdentifier, String identifierString, Node writeNode, BranchProfile exceptionProfile) {
                    super(root, 3);
                    this.cachedIdentifier = cachedIdentifier;
                    this.identifierString = identifierString;
                    this.writeNode = writeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (newNode.getClass() == WriteUncachedNode_.class) {
                        this.removeSame("Contained by writeUncached(VirtualFrame, TruffleObject, DynamicObject, Object, Node, BranchProfile)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedIdentifier);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedIdentifier)) {
                            return this.root.writeCached(frameValue, arguments0Value_, arguments1Value_, arguments2Value, this.cachedIdentifier, this.identifierString, this.writeNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root, Rope cachedIdentifier, String identifierString, Node writeNode, BranchProfile exceptionProfile) {
                    return new WriteCachedNode_(root, cachedIdentifier, identifierString, writeNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="write(VirtualFrame, TruffleObject, DynamicObject, Object, DynamicObject, String, Node, BranchProfile)", value=InteropNodes.WriteNode.class)
            private static final class Write1Node_
            extends BaseNode_ {
                private final DynamicObject cachedIdentifier;
                private final String identifierString;
                @Node.Child
                private Node writeNode;
                private final BranchProfile exceptionProfile;

                Write1Node_(WriteNodeGen root, DynamicObject cachedIdentifier, String identifierString, Node writeNode, BranchProfile exceptionProfile) {
                    super(root, 2);
                    this.cachedIdentifier = cachedIdentifier;
                    this.identifierString = identifierString;
                    this.writeNode = writeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && arguments1Value_ == this.cachedIdentifier;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == this.cachedIdentifier) {
                            return this.root.write(frameValue, arguments0Value_, arguments1Value_, arguments2Value, this.cachedIdentifier, this.identifierString, this.writeNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root, DynamicObject cachedIdentifier, String identifierString, Node writeNode, BranchProfile exceptionProfile) {
                    return new Write1Node_(root, cachedIdentifier, identifierString, writeNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="write(VirtualFrame, TruffleObject, Object, Object, Node, BranchProfile)", value=InteropNodes.WriteNode.class)
            private static final class Write0Node_
            extends BaseNode_ {
                @Node.Child
                private Node writeNode;
                private final BranchProfile exceptionProfile;

                Write0Node_(WriteNodeGen root, Node writeNode, BranchProfile exceptionProfile) {
                    super(root, 1);
                    this.writeNode = writeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        if (!RubyGuards.isRubySymbol(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.write(frameValue, arguments0Value_, arguments1Value, arguments2Value, this.writeNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root, Node writeNode, BranchProfile exceptionProfile) {
                    return new Write0Node_(root, writeNode, exceptionProfile);
                }
            }

            @GeneratedBy(value=InteropNodes.WriteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(WriteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.WriteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(WriteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(WriteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.WriteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected WriteNodeGen root;

                BaseNode_(WriteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (WriteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        if (!RubyGuards.isRubySymbol(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            Node writeNode1 = InteropNodes.WriteNode.createWriteNode();
                            BranchProfile exceptionProfile1 = BranchProfile.create();
                            return Write0Node_.create(this.root, writeNode1, exceptionProfile1);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            BranchProfile exceptionProfile3;
                            Node writeNode3;
                            String identifierString3;
                            BaseNode_ s;
                            BranchProfile exceptionProfile2;
                            Node writeNode2;
                            String identifierString2;
                            BaseNode_ s2;
                            DynamicObject arguments1Value_;
                            DynamicObject cachedIdentifier2 = arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == cachedIdentifier2 && this.countSame(s2 = Write1Node_.create(this.root, cachedIdentifier2, identifierString2 = cachedIdentifier2.toString(), writeNode2 = InteropNodes.WriteNode.createWriteNode(), exceptionProfile2 = BranchProfile.create())) < 3) {
                                return s2;
                            }
                            Rope cachedIdentifier3 = StringCachingGuards.privatizeRope(arguments1Value_);
                            if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, cachedIdentifier3) && !this.root.excludeWriteCached_ && this.countSame(s = WriteCachedNode_.create(this.root, cachedIdentifier3, identifierString3 = cachedIdentifier3.toString(), writeNode3 = InteropNodes.WriteNode.createWriteNode(), exceptionProfile3 = BranchProfile.create())) < this.root.getCacheLimit()) {
                                return s;
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                Node writeNode4 = InteropNodes.WriteNode.createWriteNode();
                                BranchProfile exceptionProfile4 = BranchProfile.create();
                                this.root.excludeWriteCached_ = true;
                                return WriteUncachedNode_.create(this.root, writeNode4, exceptionProfile4);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.ReadNode.class)
    public static final class ReadNodeFactory
    extends NodeFactoryBase<InteropNodes.ReadNode> {
        private static ReadNodeFactory readNodeFactoryInstance;

        private ReadNodeFactory() {
            super(InteropNodes.ReadNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.ReadNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ReadNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.ReadNode> getInstance() {
            if (readNodeFactoryInstance == null) {
                readNodeFactoryInstance = new ReadNodeFactory();
            }
            return readNodeFactoryInstance;
        }

        public static InteropNodes.ReadNode create(RubyNode[] arguments) {
            return new ReadNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.ReadNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ReadNodeGen
        extends InteropNodes.ReadNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeReadCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private ReadNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="readUncached(VirtualFrame, TruffleObject, DynamicObject, Node, BranchProfile)", value=InteropNodes.ReadNode.class)
            private static final class ReadUncachedNode_
            extends BaseNode_ {
                @Node.Child
                private Node readNode;
                private final BranchProfile exceptionProfile;

                ReadUncachedNode_(ReadNodeGen root, Node readNode, BranchProfile exceptionProfile) {
                    super(root, 4);
                    this.readNode = readNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.readUncached(frameValue, arguments0Value_, arguments1Value_, this.readNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root, Node readNode, BranchProfile exceptionProfile) {
                    return new ReadUncachedNode_(root, readNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="readCached(VirtualFrame, TruffleObject, DynamicObject, Rope, String, Node, BranchProfile)", value=InteropNodes.ReadNode.class)
            private static final class ReadCachedNode_
            extends BaseNode_ {
                private final Rope cachedIdentifier;
                private final String identifierString;
                @Node.Child
                private Node readNode;
                private final BranchProfile exceptionProfile;

                ReadCachedNode_(ReadNodeGen root, Rope cachedIdentifier, String identifierString, Node readNode, BranchProfile exceptionProfile) {
                    super(root, 3);
                    this.cachedIdentifier = cachedIdentifier;
                    this.identifierString = identifierString;
                    this.readNode = readNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ReadUncachedNode_.class) {
                        this.removeSame("Contained by readUncached(VirtualFrame, TruffleObject, DynamicObject, Node, BranchProfile)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubyString(arguments1Value_ = (DynamicObject)arguments1Value) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedIdentifier);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, this.cachedIdentifier)) {
                            return this.root.readCached(frameValue, arguments0Value_, arguments1Value_, this.cachedIdentifier, this.identifierString, this.readNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root, Rope cachedIdentifier, String identifierString, Node readNode, BranchProfile exceptionProfile) {
                    return new ReadCachedNode_(root, cachedIdentifier, identifierString, readNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="read(VirtualFrame, TruffleObject, DynamicObject, DynamicObject, String, Node, BranchProfile)", value=InteropNodes.ReadNode.class)
            private static final class Read1Node_
            extends BaseNode_ {
                private final DynamicObject cachedIdentifier;
                private final String identifierString;
                @Node.Child
                private Node readNode;
                private final BranchProfile exceptionProfile;

                Read1Node_(ReadNodeGen root, DynamicObject cachedIdentifier, String identifierString, Node readNode, BranchProfile exceptionProfile) {
                    super(root, 2);
                    this.cachedIdentifier = cachedIdentifier;
                    this.identifierString = identifierString;
                    this.readNode = readNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments1Value_;
                    return arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && RubyGuards.isRubySymbol(arguments1Value_ = (DynamicObject)arguments1Value) && arguments1Value_ == this.cachedIdentifier;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == this.cachedIdentifier) {
                            return this.root.read(frameValue, arguments0Value_, arguments1Value_, this.cachedIdentifier, this.identifierString, this.readNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root, DynamicObject cachedIdentifier, String identifierString, Node readNode, BranchProfile exceptionProfile) {
                    return new Read1Node_(root, cachedIdentifier, identifierString, readNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="read(VirtualFrame, TruffleObject, Object, Node, BranchProfile)", value=InteropNodes.ReadNode.class)
            private static final class Read0Node_
            extends BaseNode_ {
                @Node.Child
                private Node readNode;
                private final BranchProfile exceptionProfile;

                Read0Node_(ReadNodeGen root, Node readNode, BranchProfile exceptionProfile) {
                    super(root, 1);
                    this.readNode = readNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        if (!RubyGuards.isRubySymbol(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            return this.root.read(frameValue, arguments0Value_, arguments1Value, this.readNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root, Node readNode, BranchProfile exceptionProfile) {
                    return new Read0Node_(root, readNode, exceptionProfile);
                }
            }

            @GeneratedBy(value=InteropNodes.ReadNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ReadNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.ReadNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ReadNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ReadNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.ReadNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ReadNodeGen root;

                BaseNode_(ReadNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ReadNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        if (!RubyGuards.isRubySymbol(arguments1Value) && !RubyGuards.isRubyString(arguments1Value)) {
                            Node readNode1 = InteropNodes.ReadNode.createReadNode();
                            BranchProfile exceptionProfile1 = BranchProfile.create();
                            return Read0Node_.create(this.root, readNode1, exceptionProfile1);
                        }
                        if (arguments1Value instanceof DynamicObject) {
                            BranchProfile exceptionProfile3;
                            Node readNode3;
                            String identifierString3;
                            BaseNode_ s;
                            BranchProfile exceptionProfile2;
                            Node readNode2;
                            String identifierString2;
                            BaseNode_ s2;
                            DynamicObject arguments1Value_;
                            DynamicObject cachedIdentifier2 = arguments1Value_ = (DynamicObject)arguments1Value;
                            if (RubyGuards.isRubySymbol(arguments1Value_) && arguments1Value_ == cachedIdentifier2 && this.countSame(s2 = Read1Node_.create(this.root, cachedIdentifier2, identifierString2 = cachedIdentifier2.toString(), readNode2 = InteropNodes.ReadNode.createReadNode(), exceptionProfile2 = BranchProfile.create())) < 3) {
                                return s2;
                            }
                            Rope cachedIdentifier3 = StringCachingGuards.privatizeRope(arguments1Value_);
                            if (RubyGuards.isRubyString(arguments1Value_) && StringCachingGuards.ropesEqual(arguments1Value_, cachedIdentifier3) && !this.root.excludeReadCached_ && this.countSame(s = ReadCachedNode_.create(this.root, cachedIdentifier3, identifierString3 = cachedIdentifier3.toString(), readNode3 = InteropNodes.ReadNode.createReadNode(), exceptionProfile3 = BranchProfile.create())) < this.root.getCacheLimit()) {
                                return s;
                            }
                            if (RubyGuards.isRubyString(arguments1Value_)) {
                                Node readNode4 = InteropNodes.ReadNode.createReadNode();
                                BranchProfile exceptionProfile4 = BranchProfile.create();
                                this.root.excludeReadCached_ = true;
                                return ReadUncachedNode_.create(this.root, readNode4, exceptionProfile4);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.NullNode.class)
    public static final class NullNodeFactory
    extends NodeFactoryBase<InteropNodes.NullNode> {
        private static NullNodeFactory nullNodeFactoryInstance;

        private NullNodeFactory() {
            super(InteropNodes.NullNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.NullNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NullNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.NullNode> getInstance() {
            if (nullNodeFactoryInstance == null) {
                nullNodeFactoryInstance = new NullNodeFactory();
            }
            return nullNodeFactoryInstance;
        }

        public static InteropNodes.NullNode create(RubyNode[] arguments) {
            return new NullNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.NullNode.class)
        public static final class NullNodeGen
        extends InteropNodes.NullNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private NullNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="isNull(VirtualFrame, TruffleObject, Node)", value=InteropNodes.NullNode.class)
            private static final class IsNullNode_
            extends BaseNode_ {
                @Node.Child
                private Node isNullNode;

                IsNullNode_(NullNodeGen root, Node isNullNode) {
                    super(root, 1);
                    this.isNullNode = isNullNode;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = NullNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isNull(frameValue, arguments0Value_, this.isNullNode);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.isNull(frameValue, arguments0Value_, this.isNullNode);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(NullNodeGen root, Node isNullNode) {
                    return new IsNullNode_(root, isNullNode);
                }
            }

            @GeneratedBy(value=InteropNodes.NullNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(NullNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(NullNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.NullNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected NullNodeGen root;

                BaseNode_(NullNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (NullNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        Node isNullNode1 = this.root.createIsNullNode();
                        return IsNullNode_.create(this.root, isNullNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.UnboxNode.class)
    public static final class UnboxNodeFactory
    extends NodeFactoryBase<InteropNodes.UnboxNode> {
        private static UnboxNodeFactory unboxNodeFactoryInstance;

        private UnboxNodeFactory() {
            super(InteropNodes.UnboxNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.UnboxNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return UnboxNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.UnboxNode> getInstance() {
            if (unboxNodeFactoryInstance == null) {
                unboxNodeFactoryInstance = new UnboxNodeFactory();
            }
            return unboxNodeFactoryInstance;
        }

        public static InteropNodes.UnboxNode create(RubyNode[] arguments) {
            return new UnboxNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.UnboxNode.class)
        public static final class UnboxNodeGen
        extends InteropNodes.UnboxNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private UnboxNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeDouble(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                return this.specialization_.executeLong(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static boolean expectBoolean(Object value) throws UnexpectedResultException {
                if (value instanceof Boolean) {
                    return (Boolean)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static double expectDouble(Object value) throws UnexpectedResultException {
                if (value instanceof Double) {
                    return (Double)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static int expectInteger(Object value) throws UnexpectedResultException {
                if (value instanceof Integer) {
                    return (Integer)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static long expectLong(Object value) throws UnexpectedResultException {
                if (value instanceof Long) {
                    return (Long)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="unbox(VirtualFrame, TruffleObject, Node, BranchProfile)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox8Node_
            extends BaseNode_ {
                @Node.Child
                private Node unboxNode;
                private final BranchProfile exceptionProfile;

                Unbox8Node_(UnboxNodeGen root, Node unboxNode, BranchProfile exceptionProfile) {
                    super(root, 9);
                    this.unboxNode = unboxNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.unbox(frameValue, arguments0Value_, this.unboxNode, this.exceptionProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root, Node unboxNode, BranchProfile exceptionProfile) {
                    return new Unbox8Node_(root, unboxNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="unbox(CharSequence)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox7Node_
            extends BaseNode_ {
                Unbox7Node_(UnboxNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof CharSequence) {
                        CharSequence arguments0Value_ = (CharSequence)arguments0Value;
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new Unbox7Node_(root);
                }
            }

            @GeneratedBy(methodName="unbox(double)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Unbox6Node_(UnboxNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Unbox6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeDouble(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return UnboxNodeGen.expectDouble(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.unbox(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root, Object arguments0Value) {
                    return new Unbox6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="unbox(float)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox5Node_
            extends BaseNode_ {
                Unbox5Node_(UnboxNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Float) {
                        float arguments0Value_ = ((Float)arguments0Value).floatValue();
                        return Float.valueOf(this.root.unbox(arguments0Value_));
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new Unbox5Node_(root);
                }
            }

            @GeneratedBy(methodName="unbox(long)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Unbox4Node_(UnboxNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Unbox4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeLong(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return UnboxNodeGen.expectLong(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.unbox(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root, Object arguments0Value) {
                    return new Unbox4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="unbox(int)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                Unbox3Node_(UnboxNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((Unbox3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeInt(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return UnboxNodeGen.expectInteger(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.unbox(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root, Object arguments0Value) {
                    return new Unbox3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="unbox(short)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox2Node_
            extends BaseNode_ {
                Unbox2Node_(UnboxNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Short) {
                        short arguments0Value_ = (Short)arguments0Value;
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new Unbox2Node_(root);
                }
            }

            @GeneratedBy(methodName="unbox(byte)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox1Node_
            extends BaseNode_ {
                Unbox1Node_(UnboxNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Byte) {
                        byte arguments0Value_ = (Byte)arguments0Value;
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new Unbox1Node_(root);
                }
            }

            @GeneratedBy(methodName="unbox(boolean)", value=InteropNodes.UnboxNode.class)
            private static final class Unbox0Node_
            extends BaseNode_ {
                Unbox0Node_(UnboxNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    try {
                        return this.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return ex.getResult();
                    }
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return UnboxNodeGen.expectBoolean(this.getNext().execute_(frameValue, ex.getResult()));
                    }
                    return this.root.unbox(arguments0Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        return this.root.unbox(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new Unbox0Node_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.UnboxNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(UnboxNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.UnboxNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(UnboxNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(UnboxNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.UnboxNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected UnboxNodeGen root;

                BaseNode_(UnboxNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (UnboxNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                    return UnboxNodeGen.expectBoolean(this.execute(frameValue));
                }

                public double executeDouble(VirtualFrame frameValue) throws UnexpectedResultException {
                    return UnboxNodeGen.expectDouble(this.execute(frameValue));
                }

                public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
                    return UnboxNodeGen.expectInteger(this.execute(frameValue));
                }

                public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
                    return UnboxNodeGen.expectLong(this.execute(frameValue));
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        return Unbox0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Byte) {
                        return Unbox1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Short) {
                        return Unbox2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return Unbox3Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return Unbox4Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Float) {
                        return Unbox5Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return Unbox6Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof CharSequence) {
                        return Unbox7Node_.create(this.root);
                    }
                    if (arguments0Value instanceof TruffleObject) {
                        Node unboxNode9 = this.root.createUnboxNode();
                        BranchProfile exceptionProfile9 = BranchProfile.create();
                        return Unbox8Node_.create(this.root, unboxNode9, exceptionProfile9);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.BoxedNode.class)
    public static final class BoxedNodeFactory
    extends NodeFactoryBase<InteropNodes.BoxedNode> {
        private static BoxedNodeFactory boxedNodeFactoryInstance;

        private BoxedNodeFactory() {
            super(InteropNodes.BoxedNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.BoxedNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BoxedNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.BoxedNode> getInstance() {
            if (boxedNodeFactoryInstance == null) {
                boxedNodeFactoryInstance = new BoxedNodeFactory();
            }
            return boxedNodeFactoryInstance;
        }

        public static InteropNodes.BoxedNode create(RubyNode[] arguments) {
            return new BoxedNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.BoxedNode.class)
        public static final class BoxedNodeGen
        extends InteropNodes.BoxedNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BoxedNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static CharSequence expectCharSequence(Object value) throws UnexpectedResultException {
                if (value instanceof CharSequence) {
                    return (CharSequence)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static byte expectByte(Object value) throws UnexpectedResultException {
                if (value instanceof Byte) {
                    return (Byte)value;
                }
                throw new UnexpectedResultException(value);
            }

            private static float expectFloat(Object value) throws UnexpectedResultException {
                if (value instanceof Float) {
                    return ((Float)value).floatValue();
                }
                throw new UnexpectedResultException(value);
            }

            private static short expectShort(Object value) throws UnexpectedResultException {
                if (value instanceof Short) {
                    return (Short)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="isBoxed(Object)", value=InteropNodes.BoxedNode.class)
            private static final class FallbackNode_
            extends BaseNode_ {
                FallbackNode_(BoxedNodeGen root) {
                    super(root, 0x7FFFFFFE);
                }

                @CompilerDirectives.TruffleBoundary
                private boolean guardFallback(Object arguments0Value) {
                    return this.createNext((Frame)null, arguments0Value) == null;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    if (this.guardFallback(arguments0Value_)) {
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.guardFallback(arguments0Value)) {
                        return this.root.isBoxed(arguments0Value);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new FallbackNode_(root);
                }
            }

            @GeneratedBy(methodName="isBoxed(VirtualFrame, TruffleObject, Node, BranchProfile)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed8Node_
            extends BaseNode_ {
                @Node.Child
                private Node isBoxedNode;
                private final BranchProfile exceptionProfile;

                IsBoxed8Node_(BoxedNodeGen root, Node isBoxedNode, BranchProfile exceptionProfile) {
                    super(root, 9);
                    this.isBoxedNode = isBoxedNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = BoxedNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(frameValue, arguments0Value_, this.isBoxedNode, this.exceptionProfile);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.isBoxed(frameValue, arguments0Value_, this.isBoxedNode, this.exceptionProfile);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root, Node isBoxedNode, BranchProfile exceptionProfile) {
                    return new IsBoxed8Node_(root, isBoxedNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="isBoxed(CharSequence)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed7Node_
            extends BaseNode_ {
                IsBoxed7Node_(BoxedNodeGen root) {
                    super(root, 8);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    CharSequence arguments0Value_;
                    try {
                        arguments0Value_ = BoxedNodeGen.expectCharSequence(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof CharSequence) {
                        CharSequence arguments0Value_ = (CharSequence)arguments0Value;
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new IsBoxed7Node_(root);
                }
            }

            @GeneratedBy(methodName="isBoxed(double)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed6Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                IsBoxed6Node_(BoxedNodeGen root, Object arguments0Value) {
                    super(root, 7);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitDoubleClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((IsBoxed6Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    double arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Double.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeDouble(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitDouble(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitDouble(arguments0Value, this.arguments0ImplicitType)) {
                        double arguments0Value_ = RubyTypesGen.asImplicitDouble(arguments0Value, this.arguments0ImplicitType);
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root, Object arguments0Value) {
                    return new IsBoxed6Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="isBoxed(float)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed5Node_
            extends BaseNode_ {
                IsBoxed5Node_(BoxedNodeGen root) {
                    super(root, 6);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    float arguments0Value_;
                    try {
                        arguments0Value_ = BoxedNodeGen.expectFloat(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Float) {
                        float arguments0Value_ = ((Float)arguments0Value).floatValue();
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new IsBoxed5Node_(root);
                }
            }

            @GeneratedBy(methodName="isBoxed(long)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed4Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                IsBoxed4Node_(BoxedNodeGen root, Object arguments0Value) {
                    super(root, 5);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitLongClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((IsBoxed4Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    long arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Long.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeLong(frameValue);
                        } else if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = RubyTypes.promoteToLong(this.root.arguments0_.executeInteger(frameValue));
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitLong(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitLong(arguments0Value, this.arguments0ImplicitType)) {
                        long arguments0Value_ = RubyTypesGen.asImplicitLong(arguments0Value, this.arguments0ImplicitType);
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root, Object arguments0Value) {
                    return new IsBoxed4Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="isBoxed(int)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed3Node_
            extends BaseNode_ {
                private final Class<?> arguments0ImplicitType;

                IsBoxed3Node_(BoxedNodeGen root, Object arguments0Value) {
                    super(root, 4);
                    this.arguments0ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments0Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments0ImplicitType == ((IsBoxed3Node_)other).arguments0ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    int arguments0Value_;
                    try {
                        if (this.arguments0ImplicitType == Integer.TYPE) {
                            arguments0Value_ = this.root.arguments0_.executeInteger(frameValue);
                        } else {
                            Object arguments0Value__ = this.executeArguments0_(frameValue);
                            arguments0Value_ = RubyTypesGen.expectImplicitInteger(arguments0Value__, this.arguments0ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (RubyTypesGen.isImplicitInteger(arguments0Value, this.arguments0ImplicitType)) {
                        int arguments0Value_ = RubyTypesGen.asImplicitInteger(arguments0Value, this.arguments0ImplicitType);
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root, Object arguments0Value) {
                    return new IsBoxed3Node_(root, arguments0Value);
                }
            }

            @GeneratedBy(methodName="isBoxed(short)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed2Node_
            extends BaseNode_ {
                IsBoxed2Node_(BoxedNodeGen root) {
                    super(root, 3);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    short arguments0Value_;
                    try {
                        arguments0Value_ = BoxedNodeGen.expectShort(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Short) {
                        short arguments0Value_ = (Short)arguments0Value;
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new IsBoxed2Node_(root);
                }
            }

            @GeneratedBy(methodName="isBoxed(byte)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed1Node_
            extends BaseNode_ {
                IsBoxed1Node_(BoxedNodeGen root) {
                    super(root, 2);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    byte arguments0Value_;
                    try {
                        arguments0Value_ = BoxedNodeGen.expectByte(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Byte) {
                        byte arguments0Value_ = (Byte)arguments0Value;
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new IsBoxed1Node_(root);
                }
            }

            @GeneratedBy(methodName="isBoxed(boolean)", value=InteropNodes.BoxedNode.class)
            private static final class IsBoxed0Node_
            extends BaseNode_ {
                IsBoxed0Node_(BoxedNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeBoolean(frameValue);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    boolean arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isBoxed(arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        boolean arguments0Value_ = (Boolean)arguments0Value;
                        return this.root.isBoxed(arguments0Value_);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new IsBoxed0Node_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.BoxedNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BoxedNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.getNext().executeBoolean_(frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.BoxedNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BoxedNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value_);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(BoxedNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.BoxedNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BoxedNodeGen root;

                BaseNode_(BoxedNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BoxedNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.executeArguments0_(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof Boolean) {
                        return IsBoxed0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Byte) {
                        return IsBoxed1Node_.create(this.root);
                    }
                    if (arguments0Value instanceof Short) {
                        return IsBoxed2Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitInteger(arguments0Value)) {
                        return IsBoxed3Node_.create(this.root, arguments0Value);
                    }
                    if (RubyTypesGen.isImplicitLong(arguments0Value)) {
                        return IsBoxed4Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof Float) {
                        return IsBoxed5Node_.create(this.root);
                    }
                    if (RubyTypesGen.isImplicitDouble(arguments0Value)) {
                        return IsBoxed6Node_.create(this.root, arguments0Value);
                    }
                    if (arguments0Value instanceof CharSequence) {
                        return IsBoxed7Node_.create(this.root);
                    }
                    if (arguments0Value instanceof TruffleObject) {
                        Node isBoxedNode9 = this.root.createIsBoxedNode();
                        BranchProfile exceptionProfile9 = BranchProfile.create();
                        return IsBoxed8Node_.create(this.root, isBoxedNode9, exceptionProfile9);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createFallback() {
                    return FallbackNode_.create(this.root);
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments0_(Frame frameValue) {
                    Object object;
                    Class arguments0Type_ = this.root.arguments0Type_;
                    if (arguments0Type_ == Boolean.TYPE) {
                        return this.root.arguments0_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Double.TYPE) {
                        return this.root.arguments0_.executeDouble((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Integer.TYPE) {
                        return this.root.arguments0_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ == Long.TYPE) {
                        return this.root.arguments0_.executeLong((VirtualFrame)frameValue);
                    }
                    if (arguments0Type_ != null) return this.root.arguments0_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments0_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments0Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments0Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments0Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<InteropNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(InteropNodes.SizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static InteropNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends InteropNodes.SizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="size(VirtualFrame, TruffleObject, Node, BranchProfile)", value=InteropNodes.SizeNode.class)
            private static final class Size1Node_
            extends BaseNode_ {
                @Node.Child
                private Node getSizeNode;
                private final BranchProfile exceptionProfile;

                Size1Node_(SizeNodeGen root, Node getSizeNode, BranchProfile exceptionProfile) {
                    super(root, 2);
                    this.getSizeNode = getSizeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.size(frameValue, arguments0Value_, this.getSizeNode, this.exceptionProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root, Node getSizeNode, BranchProfile exceptionProfile) {
                    return new Size1Node_(root, getSizeNode, exceptionProfile);
                }
            }

            @GeneratedBy(methodName="size(String)", value=InteropNodes.SizeNode.class)
            private static final class Size0Node_
            extends BaseNode_ {
                Size0Node_(SizeNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof String) {
                        String arguments0Value_ = (String)arguments0Value;
                        return this.root.size(arguments0Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new Size0Node_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.SizeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SizeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().execute_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.SizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.SizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SizeNodeGen root;

                BaseNode_(SizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SizeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof String) {
                        return Size0Node_.create(this.root);
                    }
                    if (arguments0Value instanceof TruffleObject) {
                        Node getSizeNode2 = this.root.createGetSizeNode();
                        BranchProfile exceptionProfile2 = BranchProfile.create();
                        return Size1Node_.create(this.root, getSizeNode2, exceptionProfile2);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.HasSizeNode.class)
    public static final class HasSizeNodeFactory
    extends NodeFactoryBase<InteropNodes.HasSizeNode> {
        private static HasSizeNodeFactory hasSizeNodeFactoryInstance;

        private HasSizeNodeFactory() {
            super(InteropNodes.HasSizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.HasSizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return HasSizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.HasSizeNode> getInstance() {
            if (hasSizeNodeFactoryInstance == null) {
                hasSizeNodeFactoryInstance = new HasSizeNodeFactory();
            }
            return hasSizeNodeFactoryInstance;
        }

        public static InteropNodes.HasSizeNode create(RubyNode[] arguments) {
            return new HasSizeNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.HasSizeNode.class)
        public static final class HasSizeNodeGen
        extends InteropNodes.HasSizeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private HasSizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="hasSize(VirtualFrame, TruffleObject, Node)", value=InteropNodes.HasSizeNode.class)
            private static final class HasSizeNode_
            extends BaseNode_ {
                @Node.Child
                private Node hasSizeNode;

                HasSizeNode_(HasSizeNodeGen root, Node hasSizeNode) {
                    super(root, 1);
                    this.hasSizeNode = hasSizeNode;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = HasSizeNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.hasSize(frameValue, arguments0Value_, this.hasSizeNode);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.hasSize(frameValue, arguments0Value_, this.hasSizeNode);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(HasSizeNodeGen root, Node hasSizeNode) {
                    return new HasSizeNode_(root, hasSizeNode);
                }
            }

            @GeneratedBy(value=InteropNodes.HasSizeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(HasSizeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(HasSizeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.HasSizeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected HasSizeNodeGen root;

                BaseNode_(HasSizeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (HasSizeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        Node hasSizeNode1 = this.root.createHasSizeNode();
                        return HasSizeNode_.create(this.root, hasSizeNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.InvokeNode.class)
    public static final class InvokeNodeFactory
    extends NodeFactoryBase<InteropNodes.InvokeNode> {
        private static InvokeNodeFactory invokeNodeFactoryInstance;

        private InvokeNodeFactory() {
            super(InteropNodes.InvokeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.InvokeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InvokeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.InvokeNode> getInstance() {
            if (invokeNodeFactoryInstance == null) {
                invokeNodeFactoryInstance = new InvokeNodeFactory();
            }
            return invokeNodeFactoryInstance;
        }

        public static InteropNodes.InvokeNode create(RubyNode[] arguments) {
            return new InvokeNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.InvokeNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class InvokeNodeGen
        extends InteropNodes.InvokeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeInvokeCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private InvokeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="invokeUncached(VirtualFrame, TruffleObject, DynamicObject, Object[])", value=InteropNodes.InvokeNode.class)
            private static final class InvokeUncachedNode_
            extends BaseNode_ {
                InvokeUncachedNode_(InvokeNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if (RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.invokeUncached(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InvokeNodeGen root) {
                    return new InvokeUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="invokeCached(VirtualFrame, TruffleObject, DynamicObject, Object[], int, Node, ToJavaStringNode, BranchProfile)", value=InteropNodes.InvokeNode.class)
            private static final class InvokeCachedNode_
            extends BaseNode_ {
                private final int cachedArgsLength;
                @Node.Child
                private Node invokeNode;
                @Node.Child
                private ToJavaStringNode toJavaStringNode;
                private final BranchProfile exceptionProfile;

                InvokeCachedNode_(InvokeNodeGen root, int cachedArgsLength, Node invokeNode, ToJavaStringNode toJavaStringNode, BranchProfile exceptionProfile) {
                    super(root, 1);
                    this.cachedArgsLength = cachedArgsLength;
                    this.invokeNode = invokeNode;
                    this.toJavaStringNode = toJavaStringNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (newNode.getClass() == InvokeUncachedNode_.class) {
                        this.removeSame("Contained by invokeUncached(VirtualFrame, TruffleObject, DynamicObject, Object[])");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if ((RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_)) && arguments2Value_.length == this.cachedArgsLength) {
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        if ((RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_)) && arguments2Value_.length == this.cachedArgsLength) {
                            return this.root.invokeCached(frameValue, arguments0Value_, arguments1Value_, arguments2Value_, this.cachedArgsLength, this.invokeNode, this.toJavaStringNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InvokeNodeGen root, int cachedArgsLength, Node invokeNode, ToJavaStringNode toJavaStringNode, BranchProfile exceptionProfile) {
                    return new InvokeCachedNode_(root, cachedArgsLength, invokeNode, toJavaStringNode, exceptionProfile);
                }
            }

            @GeneratedBy(value=InteropNodes.InvokeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InvokeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InvokeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.InvokeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InvokeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(InvokeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.InvokeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InvokeNodeGen root;

                BaseNode_(InvokeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InvokeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    Object arguments2Value_ = this.root.arguments2_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof Object[]) {
                        BranchProfile exceptionProfile1;
                        ToJavaStringNode toJavaStringNode1;
                        Node invokeNode1;
                        BaseNode_ s;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Object[] arguments2Value_ = (Object[])arguments2Value;
                        int cachedArgsLength1 = arguments2Value_.length;
                        if ((RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_)) && arguments2Value_.length == cachedArgsLength1 && !this.root.excludeInvokeCached_ && this.countSame(s = InvokeCachedNode_.create(this.root, cachedArgsLength1, invokeNode1 = this.root.createInvokeNode(cachedArgsLength1), toJavaStringNode1 = this.root.createToJavaStringNode(), exceptionProfile1 = BranchProfile.create())) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (RubyGuards.isRubyString(arguments1Value_) || RubyGuards.isRubySymbol(arguments1Value_)) {
                            this.root.excludeInvokeCached_ = true;
                            return InvokeUncachedNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.ExecuteNode.class)
    public static final class ExecuteNodeFactory
    extends NodeFactoryBase<InteropNodes.ExecuteNode> {
        private static ExecuteNodeFactory executeNodeFactoryInstance;

        private ExecuteNodeFactory() {
            super(InteropNodes.ExecuteNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.ExecuteNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ExecuteNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.ExecuteNode> getInstance() {
            if (executeNodeFactoryInstance == null) {
                executeNodeFactoryInstance = new ExecuteNodeFactory();
            }
            return executeNodeFactoryInstance;
        }

        public static InteropNodes.ExecuteNode create(RubyNode[] arguments) {
            return new ExecuteNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.ExecuteNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class ExecuteNodeGen
        extends InteropNodes.ExecuteNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeExecuteForeignCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private ExecuteNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="executeForeignUncached(VirtualFrame, TruffleObject, Object[])", value=InteropNodes.ExecuteNode.class)
            private static final class ExecuteForeignUncachedNode_
            extends BaseNode_ {
                ExecuteForeignUncachedNode_(ExecuteNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof Object[]) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        return this.root.executeForeignUncached(frameValue, arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ExecuteNodeGen root) {
                    return new ExecuteForeignUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="executeForeignCached(VirtualFrame, TruffleObject, Object[], int, Node, BranchProfile)", value=InteropNodes.ExecuteNode.class)
            private static final class ExecuteForeignCachedNode_
            extends BaseNode_ {
                private final int cachedArgsLength;
                @Node.Child
                private Node executeNode;
                private final BranchProfile exceptionProfile;

                ExecuteForeignCachedNode_(ExecuteNodeGen root, int cachedArgsLength, Node executeNode, BranchProfile exceptionProfile) {
                    super(root, 1);
                    this.cachedArgsLength = cachedArgsLength;
                    this.executeNode = executeNode;
                    this.exceptionProfile = exceptionProfile;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == ExecuteForeignUncachedNode_.class) {
                        this.removeSame("Contained by executeForeignUncached(VirtualFrame, TruffleObject, Object[])");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    Object[] arguments1Value_;
                    return arguments0Value instanceof TruffleObject && arguments1Value instanceof Object[] && (arguments1Value_ = (Object[])arguments1Value).length == this.cachedArgsLength;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof Object[]) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        if (arguments1Value_.length == this.cachedArgsLength) {
                            return this.root.executeForeignCached(frameValue, arguments0Value_, arguments1Value_, this.cachedArgsLength, this.executeNode, this.exceptionProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ExecuteNodeGen root, int cachedArgsLength, Node executeNode, BranchProfile exceptionProfile) {
                    return new ExecuteForeignCachedNode_(root, cachedArgsLength, executeNode, exceptionProfile);
                }
            }

            @GeneratedBy(value=InteropNodes.ExecuteNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ExecuteNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ExecuteNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.ExecuteNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ExecuteNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ExecuteNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.ExecuteNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ExecuteNodeGen root;

                BaseNode_(ExecuteNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ExecuteNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof TruffleObject && arguments1Value instanceof Object[]) {
                        BranchProfile exceptionProfile1;
                        Node executeNode1;
                        BaseNode_ s;
                        Object[] arguments1Value_ = (Object[])arguments1Value;
                        int cachedArgsLength1 = arguments1Value_.length;
                        if (arguments1Value_.length == cachedArgsLength1 && !this.root.excludeExecuteForeignCached_ && this.countSame(s = ExecuteForeignCachedNode_.create(this.root, cachedArgsLength1, executeNode1 = this.root.createExecuteNode(cachedArgsLength1), exceptionProfile1 = BranchProfile.create())) < this.root.getCacheLimit()) {
                            return s;
                        }
                        this.root.excludeExecuteForeignCached_ = true;
                        return ExecuteForeignUncachedNode_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=InteropNodes.IsExecutableNode.class)
    public static final class IsExecutableNodeFactory
    extends NodeFactoryBase<InteropNodes.IsExecutableNode> {
        private static IsExecutableNodeFactory isExecutableNodeFactoryInstance;

        private IsExecutableNodeFactory() {
            super(InteropNodes.IsExecutableNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public InteropNodes.IsExecutableNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return IsExecutableNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<InteropNodes.IsExecutableNode> getInstance() {
            if (isExecutableNodeFactoryInstance == null) {
                isExecutableNodeFactoryInstance = new IsExecutableNodeFactory();
            }
            return isExecutableNodeFactoryInstance;
        }

        public static InteropNodes.IsExecutableNode create(RubyNode[] arguments) {
            return new IsExecutableNodeGen(arguments);
        }

        @GeneratedBy(value=InteropNodes.IsExecutableNode.class)
        public static final class IsExecutableNodeGen
        extends InteropNodes.IsExecutableNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private IsExecutableNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                return this.specialization_.executeBoolean(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            private static TruffleObject expectTruffleObject(Object value) throws UnexpectedResultException {
                if (value instanceof TruffleObject) {
                    return (TruffleObject)value;
                }
                throw new UnexpectedResultException(value);
            }

            @GeneratedBy(methodName="isExecutable(VirtualFrame, TruffleObject, Node)", value=InteropNodes.IsExecutableNode.class)
            private static final class IsExecutableNode_
            extends BaseNode_ {
                @Node.Child
                private Node isExecutableNode;

                IsExecutableNode_(IsExecutableNodeGen root, Node isExecutableNode) {
                    super(root, 1);
                    this.isExecutableNode = isExecutableNode;
                }

                @Override
                public boolean executeBoolean(VirtualFrame frameValue) {
                    TruffleObject arguments0Value_;
                    try {
                        arguments0Value_ = IsExecutableNodeGen.expectTruffleObject(this.root.arguments0_.execute(frameValue));
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeBoolean_(frameValue, ex.getResult());
                    }
                    return this.root.isExecutable(frameValue, arguments0Value_, this.isExecutableNode);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        TruffleObject arguments0Value_ = (TruffleObject)arguments0Value;
                        return this.root.isExecutable(frameValue, arguments0Value_, this.isExecutableNode);
                    }
                    return this.getNext().executeBoolean_(frameValue, arguments0Value);
                }

                static BaseNode_ create(IsExecutableNodeGen root, Node isExecutableNode) {
                    return new IsExecutableNode_(root, isExecutableNode);
                }
            }

            @GeneratedBy(value=InteropNodes.IsExecutableNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(IsExecutableNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public boolean executeBoolean_(VirtualFrame frameValue, Object arguments0Value) {
                    return (Boolean)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(IsExecutableNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=InteropNodes.IsExecutableNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected IsExecutableNodeGen root;

                BaseNode_(IsExecutableNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (IsExecutableNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeBoolean_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract boolean executeBoolean_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeBoolean_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public boolean executeBoolean(VirtualFrame frameValue) {
                    return (Boolean)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof TruffleObject) {
                        Node isExecutableNode1 = this.root.createIsExecutableNode();
                        return IsExecutableNode_.create(this.root, isExecutableNode1);
                    }
                    return null;
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }
}

