/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.string.StringCachingGuards;
import org.jruby.truffle.language.RubyNode;

@ImportStatic(value={StringCachingGuards.class})
@NodeChild(value="value", type=RubyNode.class)
public abstract class ToJavaStringNode
extends RubyNode {
    public ToJavaStringNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract String executeToJavaString(VirtualFrame var1, Object var2);

    @Specialization(guards={"isRubyString(value)", "ropesEqual(value, cachedRope)"}, limit="getLimit()")
    public String stringUncached(DynamicObject value, @Cached(value="privatizeRope(value)") Rope cachedRope, @Cached(value="value.toString()") String convertedString) {
        return convertedString;
    }

    protected String objectToString(DynamicObject object) {
        return object.toString();
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyString(value)"}, contains={"stringUncached"})
    public String stringCached(DynamicObject value) {
        return value.toString();
    }

    @Specialization(guards={"isRubySymbol(value)"})
    public String symbol(DynamicObject value) {
        return Layouts.SYMBOL.getString(value);
    }

    @Specialization
    public String javaString(String value) {
        return value;
    }

    protected int getLimit() {
        return this.getContext().getOptions().INTEROP_CONVERT_CACHE;
    }
}

