/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.dispatch;

import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.InvalidAssumptionException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.language.dispatch.CachedDispatchNode;
import org.jruby.truffle.language.dispatch.DispatchAction;
import org.jruby.truffle.language.dispatch.DispatchNode;
import org.jruby.truffle.language.methods.InternalMethod;

public class CachedSingletonDispatchNode
extends CachedDispatchNode {
    private final DynamicObject expectedReceiver;
    private final Assumption unmodifiedAssumption;
    private final InternalMethod method;
    @Node.Child
    private DirectCallNode callNode;

    public CachedSingletonDispatchNode(RubyContext context, Object cachedName, DispatchNode next, DynamicObject expectedReceiver, DynamicObject expectedClass, InternalMethod method, DispatchAction dispatchAction) {
        super(context, cachedName, next, dispatchAction);
        this.expectedReceiver = expectedReceiver;
        this.unmodifiedAssumption = Layouts.MODULE.getFields(expectedClass).getUnmodifiedAssumption();
        this.next = next;
        this.method = method;
        this.callNode = Truffle.getRuntime().createDirectCallNode(method.getCallTarget());
        this.applySplittingInliningStrategy(this.callNode, method);
    }

    @Override
    public boolean guard(Object methodName, Object receiver) {
        return this.guardName(methodName) && receiver == this.expectedReceiver;
    }

    @Override
    public Object executeDispatch(VirtualFrame frame, Object receiverObject, Object methodName, DynamicObject blockObject, Object[] argumentsObjects) {
        try {
            this.unmodifiedAssumption.check();
        }
        catch (InvalidAssumptionException e) {
            return this.resetAndDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects, "class modified");
        }
        if (!this.guard(methodName, receiverObject)) {
            return this.next.executeDispatch(frame, receiverObject, methodName, blockObject, argumentsObjects);
        }
        switch (this.getDispatchAction()) {
            case CALL_METHOD: {
                return CachedSingletonDispatchNode.call(this.callNode, frame, this.method, this.expectedReceiver, blockObject, argumentsObjects);
            }
            case RESPOND_TO_METHOD: {
                return true;
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public String toString() {
        return String.format("CachedBoxedDispatchNode(:%s, %s@%x, %s)", this.getCachedNameAsSymbol().toString(), this.expectedReceiver, this.expectedReceiver.hashCode(), this.method == null ? "null" : this.method.toString());
    }
}

