/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.DoesRespondDispatchHeadNode;

public class CheckStdoutVariableTypeNode
extends RubyNode {
    @Node.Child
    private RubyNode child;
    @Node.Child
    private DoesRespondDispatchHeadNode respondToWriteNode;
    private final BranchProfile unsuitableTypeProfile = BranchProfile.create();

    public CheckStdoutVariableTypeNode(RubyContext context, SourceSection sourceSection, RubyNode child) {
        super(context, sourceSection);
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object childValue = this.child.execute(frame);
        if (this.getContext().getOptions().PLATFORM_SAFE_IO && (childValue == this.nil() || !this.getRespondToWriteNode().doesRespondTo(frame, "write", childValue))) {
            this.unsuitableTypeProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorMustHaveWriteMethod(childValue, this));
        }
        return childValue;
    }

    private DoesRespondDispatchHeadNode getRespondToWriteNode() {
        if (this.respondToWriteNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.respondToWriteNode = this.insert(new DoesRespondDispatchHeadNode(this.getContext(), false));
        }
        return this.respondToWriteNode;
    }
}

