/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.globals;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.globals.GlobalVariableStorage;

public abstract class ReadGlobalVariableNode
extends RubyNode {
    private final String name;

    public ReadGlobalVariableNode(RubyContext context, SourceSection sourceSection, String name) {
        super(context, sourceSection);
        this.name = name;
    }

    @Specialization
    public Object read(@Cached(value="getStorage()") GlobalVariableStorage storage) {
        return storage.value;
    }

    protected GlobalVariableStorage getStorage() {
        return this.getContext().getCoreLibrary().getGlobalVariables().getStorage(this.name);
    }

    @Override
    public Object isDefined(VirtualFrame frame) {
        if (this.coreLibrary().getGlobalVariables().get(this.name) != this.nil()) {
            return this.coreStrings().GLOBAL_VARIABLE.createInstance();
        }
        return this.nil();
    }
}

