/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.methods;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.module.ModuleOperations;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.objects.SingletonClassNode;
import org.jruby.truffle.language.objects.SingletonClassNodeGen;

@NodeChildren(value={@NodeChild(value="moduleNode"), @NodeChild(value="methodNode"), @NodeChild(value="visibilityNode")})
public abstract class AddMethodNode
extends RubyNode {
    private final boolean ignoreNameVisibility;
    private final boolean isLiteralDef;
    @Node.Child
    private SingletonClassNode singletonClassNode;

    public AddMethodNode(RubyContext context, SourceSection sourceSection, boolean ignoreNameVisibility, boolean isLiteralDef) {
        super(context, sourceSection);
        this.ignoreNameVisibility = ignoreNameVisibility;
        this.isLiteralDef = isLiteralDef;
    }

    public abstract DynamicObject executeAddMethod(DynamicObject var1, InternalMethod var2, Visibility var3);

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyModule(module)"})
    public DynamicObject addMethod(DynamicObject module, InternalMethod method, Visibility visibility) {
        if (!this.ignoreNameVisibility && ModuleOperations.isMethodPrivateFromName(method.getName())) {
            visibility = Visibility.PRIVATE;
        }
        method = method.withVisibility(visibility);
        if (this.isLiteralDef) {
            method = method.withDeclaringModule(module);
        }
        if (visibility == Visibility.MODULE_FUNCTION) {
            this.addMethodToModule(module, method.withVisibility(Visibility.PRIVATE));
            DynamicObject singletonClass = this.getSingletonClass(module);
            this.addMethodToModule(singletonClass, method.withDeclaringModule(singletonClass).withVisibility(Visibility.PUBLIC));
        } else {
            this.addMethodToModule(module, method);
        }
        return this.getSymbol(method.getName());
    }

    public void addMethodToModule(DynamicObject module, InternalMethod method) {
        Layouts.MODULE.getFields(module).addMethod(this.getContext(), this, method);
    }

    protected DynamicObject getSingletonClass(DynamicObject object) {
        if (this.singletonClassNode == null) {
            CompilerDirectives.transferToInterpreter();
            this.singletonClassNode = this.insert(SingletonClassNodeGen.create(this.getContext(), this.getSourceSection(), null));
        }
        return this.singletonClassNode.executeSingletonClass(object);
    }
}

