/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.collections;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class WeakValuedMap<Key, Value> {
    private final Map<Key, KeyedReference<Key, Value>> map = this.newMap();
    private final ReferenceQueue<Value> deadRefs = new ReferenceQueue();

    public final void put(Key key2, Value value2) {
        this.cleanReferences();
        this.map.put(key2, new KeyedReference<Key, Value>(value2, key2, this.deadRefs));
    }

    public final Value get(Key key2) {
        this.cleanReferences();
        KeyedReference<Key, Value> reference2 = this.map.get(key2);
        if (reference2 == null) {
            return null;
        }
        return (Value)reference2.get();
    }

    public void clear() {
        this.cleanReferences();
        this.map.clear();
    }

    public int size() {
        this.cleanReferences();
        return this.map.size();
    }

    protected Map<Key, KeyedReference<Key, Value>> newMap() {
        return new ConcurrentHashMap();
    }

    private void cleanReferences() {
        KeyedReference ref;
        while ((ref = (KeyedReference)this.deadRefs.poll()) != null) {
            this.map.remove(ref.key);
        }
    }

    protected static class KeyedReference<Key, Value>
    extends WeakReference<Value> {
        protected final Key key;

        public KeyedReference(Value object, Key key2, ReferenceQueue<? super Value> queue) {
            super(object, queue);
            this.key = key2;
        }
    }
}

