/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsContext;
import org.bouncycastle.crypto.tls.TlsEncryptionCredentials;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsUtils;

public class TlsRSAUtils {
    public static byte[] generateEncryptedPreMasterSecret(TlsContext tlsContext, RSAKeyParameters rSAKeyParameters, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray);
        TlsUtils.writeVersion(tlsContext.getClientVersion(), byArray, 0);
        PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
        pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, tlsContext.getSecureRandom()));
        try {
            byte[] byArray2 = pKCS1Encoding.processBlock(byArray, 0, byArray.length);
            if (TlsUtils.isSSL(tlsContext)) {
                outputStream.write(byArray2);
            } else {
                TlsUtils.writeOpaque16(byArray2, outputStream);
            }
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new TlsFatalAlert(80);
        }
        return byArray;
    }

    public static byte[] safeDecryptPreMasterSecret(TlsContext tlsContext, TlsEncryptionCredentials tlsEncryptionCredentials, byte[] byArray) {
        ProtocolVersion protocolVersion = tlsContext.getClientVersion();
        boolean bl = false;
        byte[] byArray2 = new byte[48];
        tlsContext.getSecureRandom().nextBytes(byArray2);
        byte[] byArray3 = TlsUtils.EMPTY_BYTES;
        try {
            byArray3 = tlsEncryptionCredentials.decryptPreMasterSecret(byArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (byArray3.length != 48) {
            TlsUtils.writeVersion(protocolVersion, byArray2, 0);
            return byArray2;
        }
        if (!bl || !protocolVersion.isEqualOrEarlierVersionOf(ProtocolVersion.TLSv10)) {
            TlsUtils.writeVersion(protocolVersion, byArray3, 0);
        }
        return byArray3;
    }
}

