/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import org.apache.commons.httpclient.URIException;
import org.apache.log4j.Logger;
import org.parosproxy.paros.core.scanner.AbstractPlugin;
import org.parosproxy.paros.core.scanner.VariantAbstractQuery;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HtmlParameter;
import org.parosproxy.paros.network.HttpMessage;

public class VariantURLQuery
extends VariantAbstractQuery {
    private static final Logger log = Logger.getLogger(VariantURLQuery.class);

    @Override
    protected String getEscapedValue(HttpMessage httpMessage, String string) {
        return string != null ? AbstractPlugin.getURLEncode(string) : "";
    }

    @Override
    protected String getUnescapedValue(String string) {
        return string != null ? AbstractPlugin.getURLDecode(string) : "";
    }

    @Override
    public void setMessage(HttpMessage httpMessage) {
        this.setParams(1, Model.getSingleton().getSession().getParams(httpMessage, HtmlParameter.Type.url));
    }

    @Override
    protected void buildMessage(HttpMessage httpMessage, String string) {
        try {
            httpMessage.getRequestHeader().getURI().setEscapedQuery(string);
        }
        catch (URIException uRIException) {
            log.error((Object)(uRIException.getMessage() + string), (Throwable)uRIException);
        }
    }
}

