/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.lucene.BytesRefs;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.QueryParser;
import org.elasticsearch.index.query.QueryParsingException;

public class TermQueryParser
implements QueryParser {
    public static final String NAME = "term";
    private static final ParseField NAME_FIELD = new ParseField("_name", new String[0]).withAllDeprecated("query name is not supported in short version of term query");
    private static final ParseField BOOST_FIELD = new ParseField("boost", new String[0]).withAllDeprecated("boost is not supported in short version of term query");

    @Inject
    public TermQueryParser() {
    }

    @Override
    public String[] names() {
        return new String[]{NAME};
    }

    @Override
    public Query parse(QueryParseContext parseContext) throws IOException, QueryParsingException {
        XContentParser.Token token;
        XContentParser parser = parseContext.parser();
        String queryName = null;
        String fieldName = null;
        Object value = null;
        float boost = 1.0f;
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (parseContext.isDeprecatedSetting(currentFieldName)) continue;
            if (token == XContentParser.Token.START_OBJECT) {
                if (fieldName != null) {
                    throw new QueryParsingException(parseContext, "[term] query does not support different field names, use [bool] query instead", new Object[0]);
                }
                fieldName = currentFieldName;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if (NAME.equals(currentFieldName)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if ("value".equals(currentFieldName)) {
                        value = parser.objectBytes();
                        continue;
                    }
                    if ("_name".equals(currentFieldName)) {
                        queryName = parser.text();
                        continue;
                    }
                    if ("boost".equals(currentFieldName)) {
                        boost = parser.floatValue();
                        continue;
                    }
                    throw new QueryParsingException(parseContext, "[term] query does not support [" + currentFieldName + "]", new Object[0]);
                }
                continue;
            }
            if (token.isValue()) {
                if (parseContext.parseFieldMatcher().match(currentFieldName, NAME_FIELD)) {
                    queryName = parser.text();
                    continue;
                }
                if (parseContext.parseFieldMatcher().match(currentFieldName, BOOST_FIELD)) {
                    boost = parser.floatValue();
                    continue;
                }
                if (fieldName != null) {
                    throw new QueryParsingException(parseContext, "[term] query does not support different field names, use [bool] query instead", new Object[0]);
                }
                fieldName = currentFieldName;
                value = parser.objectBytes();
                continue;
            }
            if (token != XContentParser.Token.START_ARRAY) continue;
            throw new QueryParsingException(parseContext, "[term] query does not support array of values", new Object[0]);
        }
        if (value == null) {
            throw new QueryParsingException(parseContext, "No value specified for term query", new Object[0]);
        }
        Query query = null;
        MappedFieldType fieldType = parseContext.fieldMapper(fieldName);
        if (fieldType != null) {
            query = fieldType.termQuery(value, parseContext);
        }
        if (query == null) {
            query = new TermQuery(new Term(fieldName, BytesRefs.toBytesRef(value)));
        }
        query.setBoost(boost);
        if (queryName != null) {
            parseContext.addNamedQuery(queryName, query);
        }
        return query;
    }
}

