/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public class CircuitBreakerStats
implements Streamable,
ToXContent {
    private String name;
    private long limit;
    private long estimated;
    private long trippedCount;
    private double overhead;

    CircuitBreakerStats() {
    }

    public CircuitBreakerStats(String name, long limit, long estimated, double overhead, long trippedCount) {
        this.name = name;
        this.limit = limit;
        this.estimated = estimated;
        this.trippedCount = trippedCount;
        this.overhead = overhead;
    }

    public String getName() {
        return this.name;
    }

    public long getLimit() {
        return this.limit;
    }

    public long getEstimated() {
        return this.estimated;
    }

    public long getTrippedCount() {
        return this.trippedCount;
    }

    public double getOverhead() {
        return this.overhead;
    }

    public static CircuitBreakerStats readOptionalCircuitBreakerStats(StreamInput in) throws IOException {
        CircuitBreakerStats stats = in.readOptionalStreamable(new CircuitBreakerStats());
        return stats;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.limit = in.readLong();
        this.estimated = in.readLong();
        this.overhead = in.readDouble();
        this.trippedCount = in.readLong();
        this.name = in.readString();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeLong(this.limit);
        out.writeLong(this.estimated);
        out.writeDouble(this.overhead);
        out.writeLong(this.trippedCount);
        out.writeString(this.name);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name.toLowerCase(Locale.ROOT));
        builder.field(Fields.LIMIT, this.limit);
        builder.field(Fields.LIMIT_HUMAN, (Object)new ByteSizeValue(this.limit));
        builder.field(Fields.ESTIMATED, this.estimated);
        builder.field(Fields.ESTIMATED_HUMAN, (Object)new ByteSizeValue(this.estimated));
        builder.field(Fields.OVERHEAD, this.overhead);
        builder.field(Fields.TRIPPED_COUNT, this.trippedCount);
        builder.endObject();
        return builder;
    }

    public String toString() {
        return "[" + this.name + ",limit=" + this.limit + "/" + new ByteSizeValue(this.limit) + ",estimated=" + this.estimated + "/" + new ByteSizeValue(this.estimated) + ",overhead=" + this.overhead + ",tripped=" + this.trippedCount + "]";
    }

    static final class Fields {
        static final XContentBuilderString LIMIT = new XContentBuilderString("limit_size_in_bytes");
        static final XContentBuilderString LIMIT_HUMAN = new XContentBuilderString("limit_size");
        static final XContentBuilderString ESTIMATED = new XContentBuilderString("estimated_size_in_bytes");
        static final XContentBuilderString ESTIMATED_HUMAN = new XContentBuilderString("estimated_size");
        static final XContentBuilderString OVERHEAD = new XContentBuilderString("overhead");
        static final XContentBuilderString TRIPPED_COUNT = new XContentBuilderString("tripped");

        Fields() {
        }
    }
}

