/*
 * Decompiled with CFR 0.152.
 */
package esmska.transfer;

import esmska.data.Gateway;
import esmska.data.Gateways;
import esmska.data.Keyring;
import esmska.data.SMS;
import esmska.data.Tuple;
import esmska.transfer.GatewayExecutor;
import esmska.transfer.GatewayVariable;
import esmska.utils.L10N;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class GatewayInterpreter {
    private static final Logger logger = Logger.getLogger(GatewayInterpreter.class.getName());
    private static final ResourceBundle l10n = L10N.l10nBundle;
    private static final ScriptEngineManager manager = new ScriptEngineManager();
    private static final Keyring keyring = Keyring.getInstance();
    private Map<GatewayVariable, String> variables;
    private GatewayExecutor executor;
    private ScriptEngine engine;
    private Invocable invocable;

    private void init() {
        if (this.engine == null) {
            this.engine = manager.getEngineByName("js");
            this.invocable = (Invocable)((Object)this.engine);
        }
        if (this.engine == null) {
            throw new IllegalStateException("JavaScript execution not supported");
        }
        if (this.variables == null) {
            this.variables = new HashMap<GatewayVariable, String>();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendMessage(SMS sms) throws Exception {
        Gateway gateway = Gateways.getInstance().get(sms.getGateway());
        logger.log(Level.FINE, "Sending SMS to: {0}", gateway);
        this.init();
        this.executor = new GatewayExecutor(sms);
        if (gateway == null) {
            this.executor.setProblem((Object)GatewayExecutor.Problem.INTERNAL_MESSAGE, l10n.getString("GatewayInterpreter.unknown_gateway"));
            return false;
        }
        this.variables = GatewayInterpreter.extractVariables(sms, gateway);
        Reader reader = null;
        boolean sentOk = false;
        try {
            reader = new InputStreamReader(gateway.getScript().openStream(), "UTF-8");
            String language = this.getPreferredLanguage(gateway);
            this.executor.setPreferredLanguage(language);
            this.forwardVariables();
            this.engine.eval(reader);
            sentOk = (Boolean)this.invocable.invokeFunction("send", new Object[0]);
            logger.log(Level.FINE, "SMS sent ok: {0}", sentOk);
            if (!sentOk && sms.getProblem() == null) {
                this.executor.setProblem((Object)GatewayExecutor.Problem.UNKNOWN, null);
            }
        }
        catch (ScriptException ex) {
            logger.log(Level.SEVERE, "Error executing gateway script file " + gateway, ex);
            this.executor.setProblem((Object)GatewayExecutor.Problem.UNKNOWN, null);
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error closing gateway script file " + gateway, ex);
            }
        }
        return sentOk;
    }

    private static HashMap<GatewayVariable, String> extractVariables(SMS sms, Gateway gateway) {
        HashMap<GatewayVariable, String> map = new HashMap<GatewayVariable, String>();
        map.put(GatewayVariable.NUMBER, sms.getNumber());
        map.put(GatewayVariable.MESSAGE, sms.getText());
        map.put(GatewayVariable.SENDERNAME, sms.getSenderName());
        map.put(GatewayVariable.SENDERNUMBER, sms.getSenderNumber());
        Tuple<String, String> key = keyring.getKey(sms.getGateway());
        if (key != null) {
            map.put(GatewayVariable.LOGIN, key.get1());
            map.put(GatewayVariable.PASSWORD, key.get2());
        }
        if (gateway.getConfig().isReceipt()) {
            map.put(GatewayVariable.RECEIPT, "true");
        }
        return map;
    }

    private void forwardVariables() {
        for (GatewayVariable var : GatewayVariable.values()) {
            String value = this.variables.get((Object)var);
            this.engine.put(var.toString(), value != null ? value : "");
        }
        this.engine.put("EXEC", this.executor);
    }

    private String getPreferredLanguage(Gateway gateway) {
        List<String> languages = Arrays.asList(gateway.getSupportedLanguages());
        String defLang = Locale.getDefault().getLanguage();
        if (languages.isEmpty() || languages.contains(defLang)) {
            return defLang;
        }
        return languages.get(0);
    }
}

