/*
 * Decompiled with CFR 0.152.
 */
package esmska.transfer;

import esmska.data.Config;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class ProxyManager {
    private static final Logger logger = Logger.getLogger(ProxyManager.class.getName());
    private static final Config config = Config.getInstance();

    public static void setProxy(String httpProxy, String httpsProxy, String socksProxy) {
        String[] proxy = httpProxy == null ? new String[]{} : httpProxy.split(":");
        System.setProperty("http.proxyHost", proxy.length > 0 ? proxy[0] : "");
        System.setProperty("http.proxyPort", proxy.length > 1 ? proxy[1] : "");
        proxy = httpsProxy == null ? new String[]{} : httpsProxy.split(":");
        System.setProperty("https.proxyHost", proxy.length > 0 ? proxy[0] : "");
        System.setProperty("https.proxyPort", proxy.length > 1 ? proxy[1] : "");
        proxy = socksProxy == null ? new String[]{} : socksProxy.split(":");
        System.setProperty("socksProxyHost", proxy.length > 0 ? proxy[0] : "");
        System.setProperty("socksProxyPort", proxy.length > 1 ? proxy[1] : "");
        logger.fine("Network proxy set - httpProxy: " + httpProxy + ", httpsProxy: " + httpsProxy + ", socksProxy: " + socksProxy);
    }

    public static ProxyHost getProxyHost(ProxyType proxyType) {
        Validate.notNull((Object)proxyType);
        String host = null;
        int port = -1;
        try {
            if (!config.isUseProxy()) {
                return null;
            }
            switch (proxyType) {
                case HTTP: {
                    host = System.getProperty("http.proxyHost");
                    String port_ = System.getProperty("http.proxyPort");
                    port = Integer.parseInt(StringUtils.defaultIfEmpty(port_, "-1"));
                    break;
                }
                case HTTPS: {
                    host = System.getProperty("https.proxyHost");
                    String port_ = System.getProperty("https.proxyPort");
                    port = Integer.parseInt(StringUtils.defaultIfEmpty(port_, "-1"));
                    break;
                }
                case SOCKS: {
                    host = System.getProperty("socksProxyHost");
                    String port_ = System.getProperty("socksProxyPort");
                    port = Integer.parseInt(StringUtils.defaultIfEmpty(port_, "-1"));
                    break;
                }
                default: {
                    assert (false) : "Unknown proxy type";
                    return null;
                }
            }
            if (StringUtils.isNotEmpty(host)) {
                return new ProxyHost(host, port);
            }
            return null;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Could not create " + (Object)((Object)proxyType) + " proxy for: " + host + ":" + port, ex);
            return null;
        }
    }

    public static enum ProxyType {
        HTTP,
        HTTPS,
        SOCKS;

    }
}

