/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.cache;

import org.apache.commons.lang.WordUtils;
import org.gradle.api.internal.cache.Cache;
import org.gradle.cache.CacheAccess;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.PersistentIndexedCache;
import org.gradle.cache.PersistentIndexedCacheParameters;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.internal.Factory;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.serialize.Serializer;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MinimalPersistentCache<K, V>
implements Cache<K, V>,
Stoppable {
    private final PersistentCache cacheAccess;
    private final PersistentIndexedCache<K, V> cache;
    private final String cacheName;

    public MinimalPersistentCache(CacheRepository cacheRepository, String cacheName, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cacheName = cacheName;
        String identifier = WordUtils.uncapitalize((String)GUtil.toCamelCase((CharSequence)cacheName));
        this.cacheAccess = cacheRepository.cache(identifier).withDisplayName(cacheName + " cache").withLockOptions(LockOptionsBuilder.mode(FileLockManager.LockMode.None)).open();
        PersistentIndexedCacheParameters<K, V> params = new PersistentIndexedCacheParameters<K, V>(identifier, keySerializer, valueSerializer);
        this.cache = this.cacheAccess.createCache(params);
    }

    @Override
    public V get(final K key, Factory<V> factory) {
        Object cached = this.cacheAccess.useCache("Loading " + this.cacheName, new Factory<V>(){

            public V create() {
                return MinimalPersistentCache.this.cache.get(key);
            }
        });
        if (cached != null) {
            return (V)cached;
        }
        final Object value = factory.create();
        this.cacheAccess.useCache("Storing " + this.cacheName, new Runnable(){

            public void run() {
                MinimalPersistentCache.this.cache.put(key, value);
            }
        });
        return (V)value;
    }

    public CacheAccess getCacheAccess() {
        return this.cacheAccess;
    }

    public PersistentIndexedCache<K, V> getCache() {
        return this.cache;
    }

    public void stop() {
        this.cacheAccess.close();
    }
}

