/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.Collections;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.CacheValidator;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheFactory;
import org.gradle.cache.internal.CacheScopeMapping;
import org.gradle.cache.internal.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptions;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;

public class DefaultCacheRepository
implements CacheRepository {
    private final CacheScopeMapping cacheScopeMapping;
    private final CacheFactory factory;

    public DefaultCacheRepository(CacheScopeMapping cacheScopeMapping, CacheFactory factory) {
        this.cacheScopeMapping = cacheScopeMapping;
        this.factory = factory;
    }

    public CacheBuilder store(String key) {
        return new PersistentStoreBuilder(null, key);
    }

    public CacheBuilder store(Object scope, String key) {
        return new PersistentStoreBuilder(scope, key);
    }

    public CacheBuilder cache(String key) {
        return new PersistentCacheBuilder(null, key);
    }

    public CacheBuilder cache(File baseDir) {
        return new PersistentCacheBuilder(baseDir);
    }

    public CacheBuilder cache(Object scope, String key) {
        return new PersistentCacheBuilder(scope, key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentStoreBuilder
    extends AbstractCacheBuilder {
        private PersistentStoreBuilder(Object scope, String key) {
            super(scope, key);
        }

        @Override
        protected PersistentCache doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            if (!properties.isEmpty()) {
                throw new UnsupportedOperationException("Properties are not supported for stores.");
            }
            return DefaultCacheRepository.this.factory.openStore(cacheDir, this.displayName, this.lockOptions, (Action<? super PersistentCache>)this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentCacheBuilder
    extends AbstractCacheBuilder {
        private PersistentCacheBuilder(Object scope, String key) {
            super(scope, key);
        }

        private PersistentCacheBuilder(File baseDir) {
            super(baseDir);
        }

        @Override
        protected PersistentCache doOpen(File cacheDir, Map<String, ?> properties, CacheValidator validator) {
            return DefaultCacheRepository.this.factory.open(cacheDir, this.displayName, validator, properties, this.lockOptions, (Action<? super PersistentCache>)this.initializer);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AbstractCacheBuilder
    implements CacheBuilder {
        final Object scope;
        final String key;
        final File baseDir;
        Map<String, ?> properties = Collections.emptyMap();
        CacheValidator validator;
        Action<? super PersistentCache> initializer;
        LockOptions lockOptions = LockOptionsBuilder.mode(FileLockManager.LockMode.Shared);
        String displayName;
        CacheBuilder.VersionStrategy versionStrategy = CacheBuilder.VersionStrategy.CachePerVersion;

        protected AbstractCacheBuilder(Object scope, String key) {
            this.scope = scope;
            this.key = key;
            this.baseDir = null;
        }

        protected AbstractCacheBuilder(File baseDir) {
            this.scope = null;
            this.key = null;
            this.baseDir = baseDir;
        }

        @Override
        public CacheBuilder withProperties(Map<String, ?> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public CacheBuilder withCrossVersionCache() {
            this.versionStrategy = CacheBuilder.VersionStrategy.SharedCache;
            return this;
        }

        @Override
        public CacheBuilder withValidator(CacheValidator validator) {
            this.validator = validator;
            return this;
        }

        @Override
        public CacheBuilder withDisplayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        @Override
        public CacheBuilder withLockOptions(LockOptions lockOptions) {
            this.lockOptions = lockOptions;
            return this;
        }

        @Override
        public CacheBuilder withInitializer(Action<? super PersistentCache> initializer) {
            this.initializer = initializer;
            return this;
        }

        @Override
        public PersistentCache open() {
            File cacheBaseDir = this.baseDir != null ? this.baseDir : DefaultCacheRepository.this.cacheScopeMapping.getBaseDirectory(this.scope, this.key, this.versionStrategy);
            return this.doOpen(cacheBaseDir, this.properties, this.validator);
        }

        protected abstract PersistentCache doOpen(File var1, Map<String, ?> var2, CacheValidator var3);
    }
}

