/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.api.logging.LogLevel;
import org.gradle.logging.internal.LoggingConfigurer;
import org.gradle.logging.internal.LoggingSystem;

public class LoggingSystemAdapter
implements LoggingSystem {
    private final LoggingConfigurer configurer;
    private LogLevel logLevel = LogLevel.LIFECYCLE;

    public LoggingSystemAdapter(LoggingConfigurer configurer) {
        this.configurer = configurer;
    }

    public LoggingSystem.Snapshot snapshot() {
        return new SnapshotImpl(this.logLevel);
    }

    public LoggingSystem.Snapshot on(LogLevel minimumLevel, LogLevel defaultLevel) {
        SnapshotImpl snapshot = new SnapshotImpl(this.logLevel);
        this.setLevel(defaultLevel);
        return snapshot;
    }

    public void restore(LoggingSystem.Snapshot state) {
        LogLevel oldLevel;
        this.logLevel = oldLevel = ((SnapshotImpl)state).level;
        if (oldLevel != null) {
            this.configurer.configure(oldLevel);
        }
    }

    private void setLevel(LogLevel level) {
        this.configurer.configure(level);
        this.logLevel = level;
    }

    private class SnapshotImpl
    implements LoggingSystem.Snapshot {
        private final LogLevel level;

        public SnapshotImpl(LogLevel level) {
            this.level = level;
        }
    }
}

