/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.detection;

import org.gradle.api.Task;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.classpath.ModuleRegistry;
import org.gradle.api.internal.tasks.testing.TestClassProcessor;
import org.gradle.api.internal.tasks.testing.TestFramework;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.WorkerTestClassProcessorFactory;
import org.gradle.api.internal.tasks.testing.detection.DefaultTestClassScanner;
import org.gradle.api.internal.tasks.testing.detection.TestExecuter;
import org.gradle.api.internal.tasks.testing.detection.TestFrameworkDetector;
import org.gradle.api.internal.tasks.testing.processors.MaxNParallelTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.RestartEveryNTestClassProcessor;
import org.gradle.api.internal.tasks.testing.processors.TestMainAction;
import org.gradle.api.internal.tasks.testing.worker.ForkingTestClassProcessor;
import org.gradle.api.tasks.testing.Test;
import org.gradle.internal.Factory;
import org.gradle.internal.TimeProvider;
import org.gradle.internal.TrueTimeProvider;
import org.gradle.internal.progress.OperationIdGenerator;
import org.gradle.messaging.actor.ActorFactory;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.WorkerProcessFactory;

public class DefaultTestExecuter
implements TestExecuter {
    private final WorkerProcessFactory workerFactory;
    private final ActorFactory actorFactory;
    private final ModuleRegistry moduleRegistry;

    public DefaultTestExecuter(WorkerProcessFactory workerFactory, ActorFactory actorFactory, ModuleRegistry moduleRegistry) {
        this.workerFactory = workerFactory;
        this.actorFactory = actorFactory;
        this.moduleRegistry = moduleRegistry;
    }

    public void execute(final Test testTask, TestResultProcessor testResultProcessor) {
        DefaultTestClassScanner detector;
        final TestFramework testFramework = testTask.getTestFramework();
        final WorkerTestClassProcessorFactory testInstanceFactory = testFramework.getProcessorFactory();
        Factory<TestClassProcessor> forkingProcessorFactory = new Factory<TestClassProcessor>(){

            public TestClassProcessor create() {
                return new ForkingTestClassProcessor(DefaultTestExecuter.this.workerFactory, testInstanceFactory, (JavaForkOptions)testTask, (Iterable)testTask.getClasspath(), testFramework.getWorkerConfigurationAction(), DefaultTestExecuter.this.moduleRegistry);
            }
        };
        Factory<TestClassProcessor> reforkingProcessorFactory = new Factory<TestClassProcessor>((Factory)forkingProcessorFactory, testTask){
            final /* synthetic */ Factory val$forkingProcessorFactory;
            final /* synthetic */ Test val$testTask;
            {
                this.val$forkingProcessorFactory = factory;
                this.val$testTask = test;
            }

            public TestClassProcessor create() {
                return new RestartEveryNTestClassProcessor(this.val$forkingProcessorFactory, this.val$testTask.getForkEvery());
            }
        };
        MaxNParallelTestClassProcessor processor = new MaxNParallelTestClassProcessor(testTask.getMaxParallelForks(), (Factory)reforkingProcessorFactory, this.actorFactory);
        FileTree testClassFiles = testTask.getCandidateClassFiles();
        if (testTask.isScanForTestClasses()) {
            TestFrameworkDetector testFrameworkDetector = testTask.getTestFramework().getDetector();
            testFrameworkDetector.setTestClassesDirectory(testTask.getTestClassesDir());
            testFrameworkDetector.setTestClasspath(testTask.getClasspath());
            detector = new DefaultTestClassScanner(testClassFiles, testFrameworkDetector, (TestClassProcessor)processor);
        } else {
            detector = new DefaultTestClassScanner(testClassFiles, null, (TestClassProcessor)processor);
        }
        Object testTaskOperationId = OperationIdGenerator.generateId((Task)testTask);
        new TestMainAction((Runnable)detector, (TestClassProcessor)processor, testResultProcessor, (TimeProvider)new TrueTimeProvider(), testTaskOperationId, (Object)testTask.getPath(), String.format("Gradle Test Run %s", testTask.getPath())).run();
    }
}

