/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testkit.jarjar.org.gradle.internal.io;

import java.io.IOException;
import java.io.OutputStream;
import org.gradle.testkit.jarjar.org.gradle.internal.SystemProperties;
import org.gradle.testkit.jarjar.org.gradle.internal.io.TextStream;

public class LineBufferingOutputStream
extends OutputStream {
    private boolean hasBeenClosed;
    private final byte[] lineSeparator;
    private final int bufferIncrement;
    private final TextStream handler;
    private byte[] buf;
    private int count;

    public LineBufferingOutputStream(TextStream handler) {
        this(handler, 2048);
    }

    public LineBufferingOutputStream(TextStream handler, int bufferLength) {
        this.handler = handler;
        this.bufferIncrement = bufferLength;
        this.buf = new byte[bufferLength];
        this.count = 0;
        this.lineSeparator = SystemProperties.getInstance().getLineSeparator().getBytes();
    }

    public void close() throws IOException {
        this.hasBeenClosed = true;
        this.flush();
        this.handler.endOfStream(null);
    }

    public void write(int b) throws IOException {
        if (this.hasBeenClosed) {
            throw new IOException("The stream has been closed.");
        }
        if (this.count == this.buf.length) {
            int newBufLength = this.buf.length + this.bufferIncrement;
            byte[] newBuf = new byte[newBufLength];
            System.arraycopy(this.buf, 0, newBuf, 0, this.buf.length);
            this.buf = newBuf;
        }
        this.buf[this.count] = (byte)b;
        ++this.count;
        if (this.endsWithLineSeparator()) {
            this.flush();
        }
    }

    private boolean endsWithLineSeparator() {
        if (this.count < this.lineSeparator.length) {
            return false;
        }
        for (int i = 0; i < this.lineSeparator.length; ++i) {
            if (this.buf[this.count - this.lineSeparator.length + i] == this.lineSeparator[i]) continue;
            return false;
        }
        return true;
    }

    public void flush() {
        if (this.count != 0) {
            this.handler.text(new String(this.buf, 0, this.count));
        }
        this.reset();
    }

    private void reset() {
        if (this.buf.length > this.bufferIncrement) {
            this.buf = new byte[this.bufferIncrement];
        }
        this.count = 0;
    }
}

