/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.sonar.runner.tasks;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.TaskAction;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.internal.DefaultJavaForkOptions;
import org.gradle.process.internal.ExecHandleFactory;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class SonarRunner
extends DefaultTask {
    private static final Logger LOGGER = Logging.getLogger(SonarRunner.class);
    private static final String MAIN_CLASS_NAME = "org.sonar.runner.Main";
    private JavaForkOptions forkOptions;
    private Map<String, Object> sonarProperties;

    @TaskAction
    public void run() {
        this.prepareExec().build().start().waitForFinish().assertNormalExitValue();
    }

    JavaExecHandleBuilder prepareExec() {
        Map<String, Object> properties = this.getSonarProperties();
        if (this.getProject().file((Object)"sonar-project.properties").exists()) {
            LOGGER.warn("Found 'sonar-project.properties' in project directory: SonarQube Runner may read this file to override the Gradle 'sonarRunner' configuration.");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Executing SonarQube Runner with properties:\n[{}]", (Object)Joiner.on((String)", ").withKeyValueSeparator(": ").join(properties));
        }
        JavaExecHandleBuilder javaExec = this.getExecHandleFactory().newJavaExec();
        this.getForkOptions().copyTo((JavaForkOptions)javaExec);
        Configuration sonarRunnerConfiguration = this.getProject().getConfigurations().getAt("sonarRunner");
        Properties propertiesObject = new Properties();
        propertiesObject.putAll(properties);
        File propertyFile = new File(this.getTemporaryDir(), "sonar-project.properties");
        GUtil.saveProperties((Properties)propertiesObject, (File)propertyFile);
        return javaExec.systemProperty("project.settings", (Object)propertyFile.getAbsolutePath()).systemProperty("project.home", (Object)this.getProject().getProjectDir().getAbsolutePath()).setClasspath((FileCollection)sonarRunnerConfiguration).setMain(MAIN_CLASS_NAME);
    }

    public JavaForkOptions getForkOptions() {
        if (this.forkOptions == null) {
            this.forkOptions = new DefaultJavaForkOptions(this.getFileResolver());
        }
        return this.forkOptions;
    }

    @Input
    public Map<String, Object> getSonarProperties() {
        if (this.sonarProperties == null) {
            this.sonarProperties = Maps.newLinkedHashMap();
        }
        return this.sonarProperties;
    }

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ExecHandleFactory getExecHandleFactory() {
        throw new UnsupportedOperationException();
    }
}

