/*
 * Decompiled with CFR 0.152.
 */
package jspecview.app;

import java.net.URL;
import java.util.Map;
import javajs.util.Lst;
import javajs.util.PT;
import jspecview.api.AppletFrame;
import jspecview.api.JSVAppInterface;
import jspecview.api.JSVPanel;
import jspecview.api.PanelListener;
import jspecview.common.Coordinate;
import jspecview.common.JSVFileManager;
import jspecview.common.JSViewer;
import jspecview.common.PanelData;
import jspecview.common.PanelNode;
import jspecview.common.PeakPickEvent;
import jspecview.common.ScriptToken;
import jspecview.common.Spectrum;
import jspecview.common.SubSpecChangeEvent;
import jspecview.common.ZoomEvent;
import jspecview.source.JDXSource;
import org.jmol.util.Logger;

public class JSVApp
implements PanelListener,
JSVAppInterface {
    protected AppletFrame appletFrame;
    boolean isNewWindow;
    public String appletReadyCallbackFunctionName;
    private String coordCallbackFunctionName;
    private String loadFileCallbackFunctionName;
    private String peakCallbackFunctionName;
    private String syncCallbackFunctionName;
    public JSViewer vwr;
    private JSVPanel prevPanel;

    public JSVApp(AppletFrame appletFrame, boolean isJS) {
        this.appletFrame = appletFrame;
        this.initViewer(isJS);
        this.initParams(appletFrame.getParameter("script"));
    }

    private void initViewer(boolean isJS) {
        this.vwr = new JSViewer(this, true, isJS);
        this.appletFrame.setDropTargetListener(this.isSigned(), this.vwr);
        URL path = this.appletFrame.getDocumentBase();
        JSVFileManager.setDocumentBase(this.vwr, path);
    }

    @Override
    public boolean isPro() {
        return this.isSigned();
    }

    @Override
    public boolean isSigned() {
        return false;
    }

    public AppletFrame getAppletFrame() {
        return this.appletFrame;
    }

    public void dispose() {
        try {
            this.vwr.dispose();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Map<String, Object> getPropertyAsJavaObject(String key) {
        return this.vwr.getPropertyAsJavaObject(key);
    }

    @Override
    public String getPropertyAsJSON(String key) {
        return PT.toJSON(null, this.getPropertyAsJavaObject(key));
    }

    @Override
    public String getCoordinate() {
        return this.vwr.getCoordinate();
    }

    @Override
    public void loadInline(String data) {
        this.siOpenDataOrFile(data, null, null, null, -1, -1, true, null, null);
        this.appletFrame.validateContent(3);
    }

    @Override
    public String exportSpectrum(String type, int n) {
        return this.vwr.export(type, n);
    }

    @Override
    public void setFilePath(String tmpFilePath) {
        this.runScript("load " + PT.esc(tmpFilePath));
    }

    @Override
    public void setSpectrumNumber(int n) {
        this.runScript((Object)((Object)ScriptToken.SPECTRUMNUMBER) + " " + n);
    }

    @Override
    public void reversePlot() {
        this.toggle(ScriptToken.REVERSEPLOT);
    }

    @Override
    public void toggleGrid() {
        this.toggle(ScriptToken.GRIDON);
    }

    @Override
    public void toggleCoordinate() {
        this.toggle(ScriptToken.COORDINATESON);
    }

    @Override
    public void toggleIntegration() {
        this.toggle(ScriptToken.INTEGRATE);
    }

    private void toggle(ScriptToken st) {
        if (this.vwr.selectedPanel != null) {
            this.runScript((Object)((Object)st) + " TOGGLE");
        }
    }

    @Override
    public void addHighlight(double x1, double x2, int r, int g, int b, int a) {
        this.runScript("HIGHLIGHT " + x1 + " " + x2 + " " + r + " " + g + " " + b + " " + a);
    }

    @Override
    public void removeHighlight(double x1, double x2) {
        this.runScript("HIGHLIGHT " + x1 + " " + x2 + " OFF");
    }

    @Override
    public void removeAllHighlights() {
        this.runScript("HIGHLIGHT OFF");
    }

    @Override
    public void syncScript(String peakScript) {
        this.vwr.syncScript(peakScript);
    }

    @Override
    public void writeStatus(String msg) {
        Logger.info(msg);
    }

    public void initParams(String params) {
        this.vwr.parseInitScript(params);
        this.newAppletPanel();
        this.vwr.setPopupMenu(this.vwr.allowMenu, this.vwr.parameters.getBoolean(ScriptToken.ENABLEZOOM));
        if (this.vwr.allowMenu) {
            this.vwr.closeSource(null);
        }
        this.runScriptNow(params);
    }

    private void newAppletPanel() {
        Logger.info("newAppletPanel");
        this.appletFrame.createMainPanel(this.vwr);
    }

    @Override
    public void repaint() {
        Object applet = this.vwr == null ? null : this.vwr.html5Applet;
        this.appletFrame.repaint();
    }

    public void updateJS(int width, int height) {
    }

    @Override
    public boolean runScriptNow(String params) {
        return this.vwr.runScriptNow(params);
    }

    private void checkCallbacks() {
        Coordinate actualCoord;
        if (this.coordCallbackFunctionName == null && this.peakCallbackFunctionName == null) {
            return;
        }
        Coordinate coord = new Coordinate();
        Coordinate coordinate = actualCoord = this.peakCallbackFunctionName == null ? null : new Coordinate();
        if (!this.vwr.pd().getPickedCoordinates(coord, actualCoord)) {
            return;
        }
        int iSpec = this.vwr.mainPanel.getCurrentPanelIndex();
        if (actualCoord == null) {
            this.appletFrame.callToJavaScript(this.coordCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), iSpec + 1});
        } else {
            this.appletFrame.callToJavaScript(this.peakCallbackFunctionName, new Object[]{coord.getXVal(), coord.getYVal(), actualCoord.getXVal(), actualCoord.getYVal(), iSpec + 1});
        }
    }

    public void doAdvanced(String filePath) {
    }

    @Override
    public void panelEvent(Object eventObj) {
        if (eventObj instanceof PeakPickEvent) {
            this.vwr.processPeakPickEvent(eventObj, false);
        } else if (!(eventObj instanceof ZoomEvent)) {
            boolean cfr_ignored_0 = eventObj instanceof SubSpecChangeEvent;
        }
    }

    @Override
    public String getSolnColour() {
        return this.vwr.getSolutionColorStr(true);
    }

    private void updateJSView(String msg) {
        Object applet = this.vwr.html5Applet;
        JSVPanel panel = applet == null ? null : this.vwr.selectedPanel;
    }

    @Override
    public synchronized void syncToJmol(String msg) {
        this.updateJSView(msg);
        if (this.syncCallbackFunctionName == null) {
            return;
        }
        Logger.info("JSVApp.syncToJmol JSV>Jmol " + msg);
        this.appletFrame.callToJavaScript(this.syncCallbackFunctionName, new Object[]{this.vwr.fullName, msg});
    }

    @Override
    public void setVisible(boolean b) {
        this.appletFrame.setPanelVisible(b);
    }

    @Override
    public void setCursor(int id) {
        this.vwr.apiPlatform.setCursor(id, this.appletFrame);
    }

    @Override
    public void runScript(String script) {
        this.vwr.runScript(script);
    }

    @Override
    public Lst<String> getScriptQueue() {
        return this.vwr.scriptQueue;
    }

    @Override
    public void siSetCurrentSource(JDXSource source) {
        this.vwr.currentSource = source;
    }

    @Override
    public void siSendPanelChange() {
        if (this.vwr.selectedPanel == this.prevPanel) {
            return;
        }
        this.prevPanel = this.vwr.selectedPanel;
        this.vwr.sendPanelChange();
    }

    @Override
    public void siNewWindow(boolean isSelected, boolean fromFrame) {
        this.isNewWindow = isSelected;
        if (fromFrame) {
            if (this.vwr.jsvpPopupMenu != null) {
                this.vwr.jsvpPopupMenu.setSelected("Window", false);
            }
        } else {
            this.appletFrame.newWindow(isSelected);
        }
    }

    @Override
    public void siValidateAndRepaint(boolean isAll) {
        PanelData pd = this.vwr.pd();
        if (pd != null) {
            pd.taintedAll = true;
        }
        this.appletFrame.validate();
        this.repaint();
    }

    @Override
    public void siSyncLoad(String filePath) {
        this.newAppletPanel();
        Logger.info("JSVP syncLoad reading " + filePath);
        this.siOpenDataOrFile(null, null, null, filePath, -1, -1, false, null, null);
        this.appletFrame.validateContent(3);
    }

    @Override
    public void siOpenDataOrFile(Object data, String name, Lst<Spectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend, String script, String id) {
        switch (this.vwr.openDataOrFile(data, name, specs, url, firstSpec, lastSpec, isAppend, id)) {
            case 0: {
                if (script == null) break;
                this.runScript(script);
                break;
            }
            case -1: {
                return;
            }
            default: {
                this.siSetSelectedPanel(null);
                return;
            }
        }
        if (this.vwr.jsvpPopupMenu != null) {
            this.vwr.jsvpPopupMenu.setCompoundMenu(this.vwr.panelNodes, this.vwr.allowCompoundMenu);
        }
        Logger.info(String.valueOf(this.appletFrame.getAppletInfo()) + " File " + this.vwr.currentSource.getFilePath() + " Loaded Successfully");
    }

    @Override
    public void siProcessCommand(String scriptItem) {
        this.vwr.runScriptNow(scriptItem);
    }

    @Override
    public void siSetSelectedPanel(JSVPanel jsvp) {
        this.vwr.mainPanel.setSelectedPanel(this.vwr, jsvp, this.vwr.panelNodes);
        this.vwr.selectedPanel = jsvp;
        this.vwr.spectraTree.setSelectedPanel(this, jsvp);
        if (jsvp == null) {
            this.vwr.selectedPanel = jsvp = this.appletFrame.getJSVPanel(this.vwr, null);
            this.vwr.mainPanel.setSelectedPanel(this.vwr, jsvp, null);
        }
        this.appletFrame.validate();
        if (jsvp != null) {
            jsvp.setEnabled(true);
            jsvp.setFocusable(true);
        }
    }

    @Override
    public void siExecSetCallback(ScriptToken st, String value) {
        switch (st) {
            case APPLETREADYCALLBACKFUNCTIONNAME: {
                this.appletReadyCallbackFunctionName = value;
                break;
            }
            case LOADFILECALLBACKFUNCTIONNAME: {
                this.loadFileCallbackFunctionName = value;
                break;
            }
            case PEAKCALLBACKFUNCTIONNAME: {
                this.peakCallbackFunctionName = value;
                break;
            }
            case SYNCCALLBACKFUNCTIONNAME: {
                this.syncCallbackFunctionName = value;
                break;
            }
            case COORDCALLBACKFUNCTIONNAME: {
                this.coordCallbackFunctionName = value;
            }
        }
    }

    @Override
    public String siLoaded(String value) {
        if (this.loadFileCallbackFunctionName != null) {
            this.appletFrame.callToJavaScript(this.loadFileCallbackFunctionName, new Object[]{this.vwr.appletName, value});
        }
        this.updateJSView(null);
        return null;
    }

    @Override
    public void siExecHidden(boolean b) {
    }

    @Override
    public void siExecScriptComplete(String msg, boolean isOK) {
        this.vwr.showMessage(msg);
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siUpdateBoolean(ScriptToken st, boolean TF) {
    }

    @Override
    public void siCheckCallbacks(String title) {
        this.checkCallbacks();
    }

    @Override
    public void siNodeSet(PanelNode panelNode) {
        this.appletFrame.validateContent(2);
        this.siValidateAndRepaint(false);
    }

    @Override
    public void siSourceClosed(JDXSource source) {
    }

    @Override
    public JSVPanel siGetNewJSVPanel(Spectrum spec) {
        if (spec == null) {
            this.vwr.initialStartIndex = -1;
            this.vwr.initialEndIndex = -1;
            return null;
        }
        Lst<Spectrum> specs = new Lst<Spectrum>();
        specs.addLast(spec);
        JSVPanel jsvp = this.appletFrame.getJSVPanel(this.vwr, specs);
        jsvp.getPanelData().addListener(this);
        this.vwr.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public JSVPanel siGetNewJSVPanel2(Lst<Spectrum> specs) {
        if (specs == null) {
            this.vwr.initialStartIndex = -1;
            this.vwr.initialEndIndex = -1;
            return this.appletFrame.getJSVPanel(this.vwr, null);
        }
        JSVPanel jsvp = this.appletFrame.getJSVPanel(this.vwr, specs);
        this.vwr.initialStartIndex = -1;
        this.vwr.initialEndIndex = -1;
        jsvp.getPanelData().addListener(this);
        this.vwr.parameters.setFor(jsvp, null, true);
        return jsvp;
    }

    @Override
    public void siSetPropertiesFromPreferences(JSVPanel jsvp, boolean includeMeasures) {
        this.vwr.checkAutoIntegrate();
    }

    @Override
    public void siSetLoaded(String fileName, String filePath) {
    }

    @Override
    public void siSetMenuEnables(PanelNode node, boolean isSplit) {
    }

    @Override
    public void siUpdateRecentMenus(String filePath) {
    }

    @Override
    public void siExecTest(String value) {
        String data = "";
        this.loadInline(data);
    }

    @Override
    public String print(String fileName) {
        return this.vwr.print(fileName);
    }
}

