/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools.bugreport;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.tools.bugreport.BugReport;

public class ReportedException
extends RuntimeException {
    private static final int MAX_COLLECTION_ENTRIES = 30;
    private static final long serialVersionUID = 737333873766201033L;
    private final transient Map<Thread, StackTraceElement[]> allStackTraces;
    private final transient LinkedList<Section> sections = new LinkedList();
    private final transient Thread caughtOnThread;
    private final Throwable exception;
    private String methodWarningFrom;

    ReportedException(Throwable throwable) {
        this(throwable, Thread.currentThread());
    }

    ReportedException(Throwable throwable, Thread thread) {
        super(throwable);
        this.exception = throwable;
        this.allStackTraces = Thread.getAllStackTraces();
        this.caughtOnThread = thread;
    }

    public void warn() {
        this.methodWarningFrom = BugReport.getCallingMethod(2);
    }

    public void startSection(String string) {
        this.sections.add(new Section(string));
    }

    public void printReportDataTo(PrintWriter printWriter) {
        printWriter.println("=== REPORTED CRASH DATA ===");
        for (Section section : this.sections) {
            section.printSection(printWriter);
            printWriter.println();
        }
        if (this.methodWarningFrom != null) {
            printWriter.println("Warning issued by: " + this.methodWarningFrom);
            printWriter.println();
        }
    }

    public void printReportStackTo(PrintWriter printWriter) {
        printWriter.println("=== STACK TRACE ===");
        printWriter.println(ReportedException.niceThreadName(this.caughtOnThread));
        this.getCause().printStackTrace(printWriter);
        printWriter.println();
    }

    public void printReportThreadsTo(PrintWriter printWriter) {
        printWriter.println("=== RUNNING THREADS ===");
        for (Map.Entry<Thread, StackTraceElement[]> entry : this.allStackTraces.entrySet()) {
            printWriter.println(ReportedException.niceThreadName(entry.getKey()));
            if (this.caughtOnThread.equals(entry.getKey())) {
                printWriter.println("Stacktrace see above.");
            } else {
                for (StackTraceElement stackTraceElement : entry.getValue()) {
                    printWriter.println(stackTraceElement);
                }
            }
            printWriter.println();
        }
    }

    private static String niceThreadName(Thread thread) {
        String string = "Thread: " + thread.getName() + " (" + thread.getId() + ')';
        ThreadGroup threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            string = string + " of " + threadGroup.getName();
        }
        return string;
    }

    public boolean isSame(ReportedException reportedException) {
        if (!this.getMessage().equals(reportedException.getMessage())) {
            return false;
        }
        Set<Throwable> set = Collections.newSetFromMap(new IdentityHashMap());
        return ReportedException.hasSameStackTrace(set, this.exception, reportedException.exception);
    }

    private static boolean hasSameStackTrace(Set<Throwable> set, Throwable throwable, Throwable throwable2) {
        Throwable throwable3;
        if (set.contains(throwable)) {
            return true;
        }
        set.add(throwable);
        Object[] objectArray = throwable.getStackTrace();
        Object[] objectArray2 = throwable2.getStackTrace();
        if (!Arrays.equals(objectArray, objectArray2)) {
            return false;
        }
        Throwable throwable4 = throwable.getCause();
        if (throwable4 == null != ((throwable3 = throwable2.getCause()) == null)) {
            return false;
        }
        if (throwable4 != null) {
            return ReportedException.hasSameStackTrace(set, throwable4, throwable3);
        }
        return true;
    }

    public ReportedException put(String string, Object object) {
        String string2;
        try {
            string2 = object == null ? "null" : (object instanceof Collection ? ReportedException.makeCollectionNice((Collection)object) : (object.getClass().isArray() ? ReportedException.makeCollectionNice(Arrays.asList(object)) : object.toString()));
        }
        catch (RuntimeException runtimeException) {
            Main.warn(runtimeException);
            string2 = "<Error calling toString()>";
        }
        this.sections.getLast().put(string, string2);
        return this;
    }

    private static String makeCollectionNice(Collection<?> collection) {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (Object obj : collection) {
            stringBuilder.append("\n    - ");
            if (n <= 30) {
                stringBuilder.append(obj);
                continue;
            }
            stringBuilder.append("\n    ... (");
            stringBuilder.append(collection.size());
            stringBuilder.append(" entries)");
            break;
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return new StringBuilder(48).append("CrashReportedException [on thread ").append(this.caughtOnThread).append(']').toString();
    }

    private static class Section {
        private String sectionName;
        private ArrayList<SectionEntry> entries = new ArrayList();

        Section(String string) {
            this.sectionName = string;
        }

        public void put(String string, String string2) {
            this.entries.add(new SectionEntry(string, string2));
        }

        public void printSection(PrintWriter printWriter) {
            printWriter.println(this.sectionName + ':');
            if (this.entries.isEmpty()) {
                printWriter.println("No data collected.");
            } else {
                for (SectionEntry sectionEntry : this.entries) {
                    sectionEntry.print(printWriter);
                }
            }
        }
    }

    private static class SectionEntry {
        private final String key;
        private final String value;

        SectionEntry(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public void print(PrintWriter printWriter) {
            printWriter.print(" - ");
            printWriter.print(this.key);
            printWriter.print(": ");
            printWriter.println(this.value);
        }
    }
}

