/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.ProcessNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ProcessNodes.class)
public final class ProcessNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(ClockGetTimeNodeFactory.getInstance(), KillNodeFactory.getInstance(), PidNodeFactory.getInstance());
    }

    @GeneratedBy(value=ProcessNodes.PidNode.class)
    public static final class PidNodeFactory
    extends NodeFactoryBase<ProcessNodes.PidNode> {
        private static PidNodeFactory pidNodeFactoryInstance;

        private PidNodeFactory() {
            super(ProcessNodes.PidNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public ProcessNodes.PidNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return PidNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ProcessNodes.PidNode> getInstance() {
            if (pidNodeFactoryInstance == null) {
                pidNodeFactoryInstance = new PidNodeFactory();
            }
            return pidNodeFactoryInstance;
        }

        public static ProcessNodes.PidNode create(RubyNode[] arguments) {
            return new PidNodeGen(arguments);
        }

        @GeneratedBy(value=ProcessNodes.PidNode.class)
        public static final class PidNodeGen
        extends ProcessNodes.PidNode {
            private PidNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.pid();
            }
        }
    }

    @GeneratedBy(value=ProcessNodes.KillNode.class)
    public static final class KillNodeFactory
    extends NodeFactoryBase<ProcessNodes.KillNode> {
        private static KillNodeFactory killNodeFactoryInstance;

        private KillNodeFactory() {
            super(ProcessNodes.KillNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public ProcessNodes.KillNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return KillNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ProcessNodes.KillNode> getInstance() {
            if (killNodeFactoryInstance == null) {
                killNodeFactoryInstance = new KillNodeFactory();
            }
            return killNodeFactoryInstance;
        }

        public static ProcessNodes.KillNode create(RubyNode[] arguments) {
            return new KillNodeGen(arguments);
        }

        @GeneratedBy(value=ProcessNodes.KillNode.class)
        public static final class KillNodeGen
        extends ProcessNodes.KillNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private KillNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="kill(DynamicObject, int)", value=ProcessNodes.KillNode.class)
            private static final class KillNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                KillNode_(KillNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((KillNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (RubyGuards.isRubySymbol(arguments0Value_)) {
                        return this.root.kill(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        if (RubyGuards.isRubySymbol(arguments0Value_)) {
                            return this.root.kill(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KillNodeGen root, Object arguments1Value) {
                    return new KillNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=ProcessNodes.KillNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(KillNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KillNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.KillNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(KillNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(KillNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.KillNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected KillNodeGen root;

                BaseNode_(KillNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (KillNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && RubyGuards.isRubySymbol(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return KillNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
    public static final class ClockGetTimeNodeFactory
    extends NodeFactoryBase<ProcessNodes.ClockGetTimeNode> {
        private static ClockGetTimeNodeFactory clockGetTimeNodeFactoryInstance;

        private ClockGetTimeNodeFactory() {
            super(ProcessNodes.ClockGetTimeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public ProcessNodes.ClockGetTimeNode createNode(Object ... arguments) {
            if (!(arguments.length != 4 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode) || arguments[3] != null && !(arguments[3] instanceof RubyNode))) {
                return ClockGetTimeNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode)arguments[2], (RubyNode)arguments[3]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<ProcessNodes.ClockGetTimeNode> getInstance() {
            if (clockGetTimeNodeFactoryInstance == null) {
                clockGetTimeNodeFactoryInstance = new ClockGetTimeNodeFactory();
            }
            return clockGetTimeNodeFactoryInstance;
        }

        public static ProcessNodes.ClockGetTimeNode create(RubyContext context, SourceSection sourceSection, RubyNode clock_id, RubyNode unit) {
            return new ClockGetTimeNodeGen(context, sourceSection, clock_id, unit);
        }

        @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
        public static final class ClockGetTimeNodeGen
        extends ProcessNodes.ClockGetTimeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode clock_id_;
            @Node.Child
            private RubyNode unit_;
            @CompilerDirectives.CompilationFinal
            private Class<?> clock_idType_;
            @Node.Child
            private BaseNode_ specialization_;

            private ClockGetTimeNodeGen(RubyContext context, SourceSection sourceSection, RubyNode clock_id, RubyNode unit) {
                super(context, sourceSection);
                this.clock_id_ = clock_id;
                this.unit_ = this.coerceUnit(unit);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="clock_gettime_monotonic_raw(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_monotonic_rawNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_monotonic_rawNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 4);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_monotonic_rawNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_monotonic_raw(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_monotonic_raw(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_monotonic_rawNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_thread_cputime(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_thread_cputimeNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_thread_cputimeNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 3);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_thread_cputimeNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_thread_cputime(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_thread_cputime(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_thread_cputimeNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_realtime(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_realtimeNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_realtimeNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 2);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_realtimeNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_realtime(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_realtime(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_realtimeNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(methodName="clock_gettime_monotonic(int, DynamicObject)", value=ProcessNodes.ClockGetTimeNode.class)
            private static final class Clock_gettime_monotonicNode_
            extends BaseNode_ {
                private final Class<?> clock_idImplicitType;

                Clock_gettime_monotonicNode_(ClockGetTimeNodeGen root, Object clock_idValue) {
                    super(root, 1);
                    this.clock_idImplicitType = RubyTypesGen.getImplicitIntegerClass(clock_idValue);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.clock_idImplicitType == ((Clock_gettime_monotonicNode_)other).clock_idImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    DynamicObject unitValue_;
                    int clock_idValue_;
                    try {
                        if (this.clock_idImplicitType == Integer.TYPE) {
                            clock_idValue_ = this.root.clock_id_.executeInteger(frameValue);
                        } else {
                            Object clock_idValue__ = this.executeClock_id_(frameValue);
                            clock_idValue_ = RubyTypesGen.expectImplicitInteger(clock_idValue__, this.clock_idImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object unitValue = this.root.unit_.execute(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), unitValue);
                    }
                    try {
                        unitValue_ = this.root.unit_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, clock_idValue_, ex.getResult());
                    }
                    if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                        return this.root.clock_gettime_monotonic(clock_idValue_, unitValue_);
                    }
                    return this.getNext().execute_(frameValue, clock_idValue_, unitValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue, this.clock_idImplicitType) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue, this.clock_idImplicitType);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return this.root.clock_gettime_monotonic(clock_idValue_, unitValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root, Object clock_idValue) {
                    return new Clock_gettime_monotonicNode_(root, clock_idValue);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ClockGetTimeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object clock_idValue, Object unitValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, clock_idValue, unitValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    return this.getNext().execute_(frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ClockGetTimeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object clock_idValue, Object unitValue) {
                    return this.uninitialized((Frame)frameValue, clock_idValue, unitValue);
                }

                static BaseNode_ create(ClockGetTimeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=ProcessNodes.ClockGetTimeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ClockGetTimeNodeGen root;

                BaseNode_(ClockGetTimeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ClockGetTimeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.clock_id_, this.root.unit_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object clock_idValue, Object unitValue) {
                    return this.execute_((VirtualFrame)frameValue, clock_idValue, unitValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object clock_idValue_ = this.executeClock_id_(frameValue);
                    Object unitValue_ = this.root.unit_.execute(frameValue);
                    return this.execute_(frameValue, clock_idValue_, unitValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object clock_idValue, Object unitValue) {
                    if (RubyTypesGen.isImplicitInteger(clock_idValue) && unitValue instanceof DynamicObject) {
                        int clock_idValue_ = RubyTypesGen.asImplicitInteger(clock_idValue);
                        DynamicObject unitValue_ = (DynamicObject)unitValue;
                        if (ProcessNodes.ClockGetTimeNode.isMonotonic(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_monotonicNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isRealtime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_realtimeNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isThreadCPUTime(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_thread_cputimeNode_.create(this.root, clock_idValue);
                        }
                        if (ProcessNodes.ClockGetTimeNode.isMonotonicRaw(clock_idValue_) && RubyGuards.isRubySymbol(unitValue_)) {
                            return Clock_gettime_monotonic_rawNode_.create(this.root, clock_idValue);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeClock_id_(Frame frameValue) {
                    Object object;
                    Class clock_idType_ = this.root.clock_idType_;
                    if (clock_idType_ == Integer.TYPE) {
                        return this.root.clock_id_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (clock_idType_ != null) return this.root.clock_id_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.clock_id_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.clock_idType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.clock_idType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.clock_idType_ = _type;
                    return object;
                }
            }
        }
    }
}

