/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.encoding;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.dsl.internal.SuppressFBWarnings;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jcodings.Encoding;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.CoreMethodNode;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;

@GeneratedBy(value=EncodingNodes.class)
public final class EncodingNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AsciiCompatibleNodeFactory.getInstance(), CompatibleQueryNodeFactory.getInstance(), SetDefaultExternalNodeFactory.getInstance(), SetDefaultInternalNodeFactory.getInstance(), ListNodeFactory.getInstance(), LocaleCharacterMapNodeFactory.getInstance(), DummyNodeFactory.getInstance(), EncodingMapNodeFactory.getInstance(), ToSNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=EncodingNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<EncodingNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(EncodingNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public EncodingNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static EncodingNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=EncodingNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends EncodingNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<EncodingNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(EncodingNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static EncodingNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends EncodingNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.EncodingMapNode.class)
    public static final class EncodingMapNodeFactory
    extends NodeFactoryBase<EncodingNodes.EncodingMapNode> {
        private static EncodingMapNodeFactory encodingMapNodeFactoryInstance;

        private EncodingMapNodeFactory() {
            super(EncodingNodes.EncodingMapNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public EncodingNodes.EncodingMapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EncodingMapNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.EncodingMapNode> getInstance() {
            if (encodingMapNodeFactoryInstance == null) {
                encodingMapNodeFactoryInstance = new EncodingMapNodeFactory();
            }
            return encodingMapNodeFactoryInstance;
        }

        public static EncodingNodes.EncodingMapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new EncodingMapNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=EncodingNodes.EncodingMapNode.class)
        public static final class EncodingMapNodeGen
        extends EncodingNodes.EncodingMapNode {
            private EncodingMapNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.encodingMap(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.DummyNode.class)
    public static final class DummyNodeFactory
    extends NodeFactoryBase<EncodingNodes.DummyNode> {
        private static DummyNodeFactory dummyNodeFactoryInstance;

        private DummyNodeFactory() {
            super(EncodingNodes.DummyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.DummyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return DummyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.DummyNode> getInstance() {
            if (dummyNodeFactoryInstance == null) {
                dummyNodeFactoryInstance = new DummyNodeFactory();
            }
            return dummyNodeFactoryInstance;
        }

        public static EncodingNodes.DummyNode create(RubyNode[] arguments) {
            return new DummyNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.DummyNode.class)
        public static final class DummyNodeGen
        extends EncodingNodes.DummyNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private DummyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isDummy(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
    public static final class LocaleCharacterMapNodeFactory
    extends NodeFactoryBase<EncodingNodes.LocaleCharacterMapNode> {
        private static LocaleCharacterMapNodeFactory localeCharacterMapNodeFactoryInstance;

        private LocaleCharacterMapNodeFactory() {
            super(EncodingNodes.LocaleCharacterMapNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.LocaleCharacterMapNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LocaleCharacterMapNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.LocaleCharacterMapNode> getInstance() {
            if (localeCharacterMapNodeFactoryInstance == null) {
                localeCharacterMapNodeFactoryInstance = new LocaleCharacterMapNodeFactory();
            }
            return localeCharacterMapNodeFactoryInstance;
        }

        public static EncodingNodes.LocaleCharacterMapNode create(RubyNode[] arguments) {
            return new LocaleCharacterMapNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.LocaleCharacterMapNode.class)
        public static final class LocaleCharacterMapNodeGen
        extends EncodingNodes.LocaleCharacterMapNode {
            private LocaleCharacterMapNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.localeCharacterMap();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.ListNode.class)
    public static final class ListNodeFactory
    extends NodeFactoryBase<EncodingNodes.ListNode> {
        private static ListNodeFactory listNodeFactoryInstance;

        private ListNodeFactory() {
            super(EncodingNodes.ListNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.ListNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ListNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.ListNode> getInstance() {
            if (listNodeFactoryInstance == null) {
                listNodeFactoryInstance = new ListNodeFactory();
            }
            return listNodeFactoryInstance;
        }

        public static EncodingNodes.ListNode create(RubyNode[] arguments) {
            return new ListNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.ListNode.class)
        public static final class ListNodeGen
        extends EncodingNodes.ListNode {
            private ListNodeGen(RubyNode[] arguments) {
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.list();
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
    public static final class SetDefaultInternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.SetDefaultInternalNode> {
        private static SetDefaultInternalNodeFactory setDefaultInternalNodeFactoryInstance;

        private SetDefaultInternalNodeFactory() {
            super(EncodingNodes.SetDefaultInternalNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.SetDefaultInternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultInternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultInternalNode> getInstance() {
            if (setDefaultInternalNodeFactoryInstance == null) {
                setDefaultInternalNodeFactoryInstance = new SetDefaultInternalNodeFactory();
            }
            return setDefaultInternalNodeFactoryInstance;
        }

        public static EncodingNodes.SetDefaultInternalNode create(RubyNode[] arguments) {
            return new SetDefaultInternalNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
        public static final class SetDefaultInternalNodeGen
        extends EncodingNodes.SetDefaultInternalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultInternalNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="defaultInternal(VirtualFrame, Object)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal2Node_
            extends BaseNode_ {
                DefaultInternal2Node_(SetDefaultInternalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!RubyGuards.isRubyEncoding(arguments0Value) && !this.root.isNil(arguments0Value)) {
                        return this.root.defaultInternal(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal2Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultInternal(Object)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal1Node_
            extends BaseNode_ {
                DefaultInternal1Node_(SetDefaultInternalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.defaultInternal(arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal1Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultInternal(DynamicObject)", value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class DefaultInternal0Node_
            extends BaseNode_ {
                DefaultInternal0Node_(SetDefaultInternalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultInternal(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new DefaultInternal0Node_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultInternalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultInternalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultInternalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultInternalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetDefaultInternalNodeGen root;

                BaseNode_(SetDefaultInternalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetDefaultInternalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return DefaultInternal0Node_.create(this.root);
                    }
                    if (this.root.isNil(arguments0Value)) {
                        return DefaultInternal1Node_.create(this.root);
                    }
                    if (!RubyGuards.isRubyEncoding(arguments0Value) && !this.root.isNil(arguments0Value)) {
                        return DefaultInternal2Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
    public static final class SetDefaultExternalNodeFactory
    extends NodeFactoryBase<EncodingNodes.SetDefaultExternalNode> {
        private static SetDefaultExternalNodeFactory setDefaultExternalNodeFactoryInstance;

        private SetDefaultExternalNodeFactory() {
            super(EncodingNodes.SetDefaultExternalNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.SetDefaultExternalNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetDefaultExternalNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.SetDefaultExternalNode> getInstance() {
            if (setDefaultExternalNodeFactoryInstance == null) {
                setDefaultExternalNodeFactoryInstance = new SetDefaultExternalNodeFactory();
            }
            return setDefaultExternalNodeFactoryInstance;
        }

        public static EncodingNodes.SetDefaultExternalNode create(RubyNode[] arguments) {
            return new SetDefaultExternalNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
        public static final class SetDefaultExternalNodeGen
        extends EncodingNodes.SetDefaultExternalNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetDefaultExternalNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="defaultExternal(VirtualFrame, Object)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal2Node_
            extends BaseNode_ {
                DefaultExternal2Node_(SetDefaultExternalNodeGen root) {
                    super(root, 4);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (!(RubyGuards.isRubyEncoding(arguments0Value) || RubyGuards.isRubyString(arguments0Value) || this.root.isNil(arguments0Value))) {
                        return this.root.defaultExternal(frameValue, arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal2Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternal(Object)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal1Node_
            extends BaseNode_ {
                DefaultExternal1Node_(SetDefaultExternalNodeGen root) {
                    super(root, 3);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    if (this.root.isNil(arguments0Value)) {
                        return this.root.defaultExternal(arguments0Value);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal1Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternal(DynamicObject)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternal0Node_
            extends BaseNode_ {
                DefaultExternal0Node_(SetDefaultExternalNodeGen root) {
                    super(root, 2);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyString(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultExternal(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternal0Node_(root);
                }
            }

            @GeneratedBy(methodName="defaultExternalEncoding(DynamicObject)", value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class DefaultExternalEncodingNode_
            extends BaseNode_ {
                DefaultExternalEncodingNode_(SetDefaultExternalNodeGen root) {
                    super(root, 1);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyGuards.isRubyEncoding(arguments0Value_ = (DynamicObject)arguments0Value)) {
                        return this.root.defaultExternalEncoding(arguments0Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new DefaultExternalEncodingNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetDefaultExternalNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetDefaultExternalNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value);
                }

                static BaseNode_ create(SetDefaultExternalNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.SetDefaultExternalNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetDefaultExternalNodeGen root;

                BaseNode_(SetDefaultExternalNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetDefaultExternalNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        if (RubyGuards.isRubyEncoding(arguments0Value_)) {
                            return DefaultExternalEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments0Value_)) {
                            return DefaultExternal0Node_.create(this.root);
                        }
                    }
                    if (this.root.isNil(arguments0Value)) {
                        return DefaultExternal1Node_.create(this.root);
                    }
                    if (!(RubyGuards.isRubyEncoding(arguments0Value) || RubyGuards.isRubyString(arguments0Value) || this.root.isNil(arguments0Value))) {
                        return DefaultExternal2Node_.create(this.root);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
    public static final class CompatibleQueryNodeFactory
    extends NodeFactoryBase<EncodingNodes.CompatibleQueryNode> {
        private static CompatibleQueryNodeFactory compatibleQueryNodeFactoryInstance;

        private CompatibleQueryNodeFactory() {
            super(EncodingNodes.CompatibleQueryNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.CompatibleQueryNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CompatibleQueryNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.CompatibleQueryNode> getInstance() {
            if (compatibleQueryNodeFactoryInstance == null) {
                compatibleQueryNodeFactoryInstance = new CompatibleQueryNodeFactory();
            }
            return compatibleQueryNodeFactoryInstance;
        }

        public static EncodingNodes.CompatibleQueryNode create(RubyNode[] arguments) {
            return new CompatibleQueryNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
        @SuppressFBWarnings(value={"SA_LOCAL_SELF_COMPARISON"})
        public static final class CompatibleQueryNodeGen
        extends EncodingNodes.CompatibleQueryNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private boolean excludeIsCompatibleStringStringCached_;
            @Node.Child
            private BaseNode_ specialization_;

            private CompatibleQueryNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="isCompatibleStringEncoding(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringEncodingNode_
            extends BaseNode_ {
                IsCompatibleStringEncodingNode_(CompatibleQueryNodeGen root) {
                    super(root, 11);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return this.root.isCompatibleStringEncoding(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleSymbolSymbol(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleSymbolSymbolNode_
            extends BaseNode_ {
                IsCompatibleSymbolSymbolNode_(CompatibleQueryNodeGen root) {
                    super(root, 10);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.isCompatibleSymbolSymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleSymbolSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringSymbol(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringSymbolNode_
            extends BaseNode_ {
                IsCompatibleStringSymbolNode_(CompatibleQueryNodeGen root) {
                    super(root, 9);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.isCompatibleStringSymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleSymbolRegexp(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleSymbolRegexpNode_
            extends BaseNode_ {
                IsCompatibleSymbolRegexpNode_(CompatibleQueryNodeGen root) {
                    super(root, 8);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubySymbol(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return this.root.isCompatibleSymbolRegexp(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleSymbolRegexpNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleRegexpSymbol(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleRegexpSymbolNode_
            extends BaseNode_ {
                IsCompatibleRegexpSymbolNode_(CompatibleQueryNodeGen root) {
                    super(root, 7);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.isCompatibleRegexpSymbol(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleRegexpSymbolNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleRegexpRegexp(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleRegexpRegexpNode_
            extends BaseNode_ {
                IsCompatibleRegexpRegexpNode_(CompatibleQueryNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return this.root.isCompatibleRegexpRegexp(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleRegexpRegexpNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleRegexpString(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleRegexpStringNode_
            extends BaseNode_ {
                IsCompatibleRegexpStringNode_(CompatibleQueryNodeGen root) {
                    super(root, 5);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.isCompatibleRegexpString(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleRegexpStringNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringRegexp(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringRegexpNode_
            extends BaseNode_ {
                IsCompatibleStringRegexpNode_(CompatibleQueryNodeGen root) {
                    super(root, 4);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return this.root.isCompatibleStringRegexp(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringRegexpNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleEncodingEncoding(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleEncodingEncodingNode_
            extends BaseNode_ {
                IsCompatibleEncodingEncodingNode_(CompatibleQueryNodeGen root) {
                    super(root, 3);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyEncoding(arguments0Value_) && RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return this.root.isCompatibleEncodingEncoding(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleEncodingEncodingNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringStringUncached(DynamicObject, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringStringUncachedNode_
            extends BaseNode_ {
                IsCompatibleStringStringUncachedNode_(CompatibleQueryNodeGen root) {
                    super(root, 2);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.isCompatibleStringStringUncached(arguments0Value_, arguments1Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new IsCompatibleStringStringUncachedNode_(root);
                }
            }

            @GeneratedBy(methodName="isCompatibleStringStringCached(DynamicObject, DynamicObject, Encoding, Encoding, DynamicObject)", value=EncodingNodes.CompatibleQueryNode.class)
            private static final class IsCompatibleStringStringCachedNode_
            extends BaseNode_ {
                private final Encoding firstEncoding;
                private final Encoding secondEncoding;
                private final DynamicObject rubyEncoding;

                IsCompatibleStringStringCachedNode_(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, DynamicObject rubyEncoding) {
                    super(root, 1);
                    this.firstEncoding = firstEncoding;
                    this.secondEncoding = secondEncoding;
                    this.rubyEncoding = rubyEncoding;
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (newNode.getClass() == IsCompatibleStringStringUncachedNode_.class) {
                        this.removeSame("Contained by isCompatibleStringStringUncached(DynamicObject, DynamicObject)");
                    }
                    return super.merge(newNode, frameValue, arguments0Value, arguments1Value);
                }

                @Override
                public boolean isIdentical(SpecializationNode other, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && this.root.extractEncoding(arguments0Value_) == this.firstEncoding && this.root.extractEncoding(arguments1Value_) == this.secondEncoding) {
                            assert (this.firstEncoding == this.secondEncoding);
                            return true;
                        }
                    }
                    return false;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && this.root.extractEncoding(arguments0Value_) == this.firstEncoding && this.root.extractEncoding(arguments1Value_) == this.secondEncoding) {
                            assert (this.firstEncoding == this.secondEncoding);
                            return this.root.isCompatibleStringStringCached(arguments0Value_, arguments1Value_, this.firstEncoding, this.secondEncoding, this.rubyEncoding);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root, Encoding firstEncoding, Encoding secondEncoding, DynamicObject rubyEncoding) {
                    return new IsCompatibleStringStringCachedNode_(root, firstEncoding, secondEncoding, rubyEncoding);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(CompatibleQueryNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(CompatibleQueryNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(CompatibleQueryNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=EncodingNodes.CompatibleQueryNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected CompatibleQueryNodeGen root;

                BaseNode_(CompatibleQueryNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (CompatibleQueryNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.root.arguments1_.execute(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject) {
                        DynamicObject rubyEncoding1;
                        BaseNode_ s;
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        Encoding firstEncoding1 = this.root.extractEncoding(arguments0Value_);
                        Encoding secondEncoding1 = this.root.extractEncoding(arguments1Value_);
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_) && firstEncoding1 == secondEncoding1 && this.root.extractEncoding(arguments0Value_) == firstEncoding1 && this.root.extractEncoding(arguments1Value_) == secondEncoding1 && !this.root.excludeIsCompatibleStringStringCached_ && this.countSame(s = IsCompatibleStringStringCachedNode_.create(this.root, firstEncoding1, secondEncoding1, rubyEncoding1 = this.root.isCompatibleStringStringUncached(arguments0Value_, arguments1Value_))) < this.root.getCacheLimit()) {
                            return s;
                        }
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            this.root.excludeIsCompatibleStringStringCached_ = true;
                            return IsCompatibleStringStringUncachedNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyEncoding(arguments0Value_) && RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return IsCompatibleEncodingEncodingNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return IsCompatibleStringRegexpNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubyString(arguments1Value_)) {
                            return IsCompatibleRegexpStringNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return IsCompatibleRegexpRegexpNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyRegexp(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return IsCompatibleRegexpSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments0Value_) && RubyGuards.isRubyRegexp(arguments1Value_)) {
                            return IsCompatibleSymbolRegexpNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return IsCompatibleStringSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubySymbol(arguments0Value_) && RubyGuards.isRubySymbol(arguments1Value_)) {
                            return IsCompatibleSymbolSymbolNode_.create(this.root);
                        }
                        if (RubyGuards.isRubyString(arguments0Value_) && RubyGuards.isRubyEncoding(arguments1Value_)) {
                            return IsCompatibleStringEncodingNode_.create(this.root);
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }
            }
        }
    }

    @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
    public static final class AsciiCompatibleNodeFactory
    extends NodeFactoryBase<EncodingNodes.AsciiCompatibleNode> {
        private static AsciiCompatibleNodeFactory asciiCompatibleNodeFactoryInstance;

        private AsciiCompatibleNodeFactory() {
            super(EncodingNodes.AsciiCompatibleNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public EncodingNodes.AsciiCompatibleNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AsciiCompatibleNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<EncodingNodes.AsciiCompatibleNode> getInstance() {
            if (asciiCompatibleNodeFactoryInstance == null) {
                asciiCompatibleNodeFactoryInstance = new AsciiCompatibleNodeFactory();
            }
            return asciiCompatibleNodeFactoryInstance;
        }

        public static EncodingNodes.AsciiCompatibleNode create(RubyNode[] arguments) {
            return new AsciiCompatibleNodeGen(arguments);
        }

        @GeneratedBy(value=EncodingNodes.AsciiCompatibleNode.class)
        public static final class AsciiCompatibleNodeGen
        extends EncodingNodes.AsciiCompatibleNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AsciiCompatibleNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.isCompatible(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

