/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;

public abstract class EncodingPrimitiveNodes {

    @RubiniusPrimitive(name="encoding_get_object_encoding", needsSelf=false)
    public static abstract class EncodingGetObjectEncodingNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization(guards={"isRubyString(string)"})
        public DynamicObject encodingGetObjectEncodingString(DynamicObject string) {
            return EncodingNodes.getEncoding(Layouts.STRING.getRope(string).getEncoding());
        }

        @Specialization(guards={"isRubySymbol(symbol)"})
        public DynamicObject encodingGetObjectEncodingSymbol(DynamicObject symbol) {
            return EncodingNodes.getEncoding(Layouts.SYMBOL.getRope(symbol).getEncoding());
        }

        @Specialization(guards={"isRubyEncoding(encoding)"})
        public DynamicObject encodingGetObjectEncoding(DynamicObject encoding) {
            return encoding;
        }

        @Specialization(guards={"isRubyRegexp(regexp)"})
        public DynamicObject encodingGetObjectEncodingRegexp(DynamicObject regexp) {
            return EncodingNodes.getEncoding(Layouts.REGEXP.getSource(regexp).getEncoding());
        }

        @Specialization(guards={"!isRubyString(object)", "!isRubySymbol(object)", "!isRubyEncoding(object)", "!isRubyRegexp(object)"})
        public DynamicObject encodingGetObjectEncodingNil(DynamicObject object) {
            return this.nil();
        }
    }
}

