/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.rubinius;

import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.lang.ref.WeakReference;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.rubinius.RubiniusPrimitive;
import org.jruby.truffle.core.rubinius.RubiniusPrimitiveArrayArgumentsNode;

public abstract class WeakRefPrimitiveNodes {

    @RubiniusPrimitive(name="weakref_object")
    public static abstract class WeakRefObjectPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public Object weakRefObject(DynamicObject weakRef) {
            return Layouts.WEAK_REF_LAYOUT.getReference(weakRef).get();
        }
    }

    @RubiniusPrimitive(name="weakref_set_object")
    public static abstract class WeakRefSetObjectPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public Object weakRefSetObject(DynamicObject weakRef, Object object) {
            Layouts.WEAK_REF_LAYOUT.setReference(weakRef, new WeakReference<Object>(object));
            return object;
        }
    }

    @RubiniusPrimitive(name="weakref_new", needsSelf=false)
    public static abstract class WeakRefNewPrimitiveNode
    extends RubiniusPrimitiveArrayArgumentsNode {
        @Specialization
        public DynamicObject weakRefNew(Object object) {
            return Layouts.WEAK_REF_LAYOUT.createWeakRef(this.coreLibrary().getWeakRefFactory(), new WeakReference<Object>(object));
        }
    }
}

