/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.symbol;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.truffle.core.BinaryCoreMethodNode;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.CoreMethodArrayArgumentsNode;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.proc.ProcOperations;
import org.jruby.truffle.core.proc.ProcType;
import org.jruby.truffle.language.RubyRootNode;
import org.jruby.truffle.language.arguments.RubyArguments;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.methods.Arity;
import org.jruby.truffle.language.methods.InternalMethod;
import org.jruby.truffle.language.methods.SharedMethodInfo;
import org.jruby.truffle.language.methods.SymbolProcNode;
import org.jruby.truffle.language.parser.jruby.Translator;

@CoreClass(name="Symbol")
public abstract class SymbolNodes {

    @CoreMethod(names={"allocate"}, constructor=true)
    public static abstract class AllocateNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allocate(DynamicObject rubyClass) {
            throw new RaiseException(this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }

    @CoreMethod(names={"to_s"})
    public static abstract class ToSNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject toS(DynamicObject symbol) {
            return this.createString(Layouts.SYMBOL.getRope(symbol));
        }
    }

    @CoreMethod(names={"to_proc"})
    public static abstract class ToProcNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"cachedSymbol == symbol"}, limit="getCacheLimit()")
        public DynamicObject toProcCached(VirtualFrame frame, DynamicObject symbol, @Cached(value="symbol") DynamicObject cachedSymbol, @Cached(value="createProc(frame, symbol)") DynamicObject cachedProc) {
            return cachedProc;
        }

        @Specialization
        public DynamicObject toProcUncached(VirtualFrame frame, DynamicObject symbol) {
            return this.createProc(frame, symbol);
        }

        protected DynamicObject createProc(VirtualFrame frame, DynamicObject symbol) {
            CompilerDirectives.transferToInterpreter();
            SourceSection sourceSection = this.getContext().getCallStack().getCallerFrameIgnoringSend().getCallNode().getEncapsulatingSourceSection();
            SharedMethodInfo sharedMethodInfo = new SharedMethodInfo(sourceSection, null, Arity.AT_LEAST_ONE, Layouts.SYMBOL.getString(symbol), true, ArgumentDescriptor.ANON_REST, false, false, false);
            RubyRootNode rootNode = new RubyRootNode(this.getContext(), sourceSection, new FrameDescriptor(this.nil()), sharedMethodInfo, Translator.sequence(this.getContext(), sourceSection, Arrays.asList(Translator.createCheckArityNode(this.getContext(), sourceSection, Arity.AT_LEAST_ONE), new SymbolProcNode(this.getContext(), sourceSection, Layouts.SYMBOL.getString(symbol)))), false);
            RootCallTarget callTarget = Truffle.getRuntime().createCallTarget(rootNode);
            InternalMethod method = RubyArguments.getMethod(frame);
            return ProcOperations.createRubyProc(this.coreLibrary().getProcFactory(), ProcType.PROC, sharedMethodInfo, callTarget, callTarget, null, method, this.coreLibrary().getNilObject(), null);
        }

        protected int getCacheLimit() {
            return this.getContext().getOptions().SYMBOL_TO_PROC_CACHE;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public int hash(DynamicObject symbol) {
            return Layouts.SYMBOL.getHashCode(symbol);
        }
    }

    @CoreMethod(names={"encoding"})
    public static abstract class EncodingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        public DynamicObject encoding(DynamicObject symbol) {
            return EncodingNodes.getEncoding(Layouts.SYMBOL.getRope(symbol).getEncoding());
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends BinaryCoreMethodNode {
        @Specialization(guards={"isRubySymbol(b)"})
        public boolean equal(DynamicObject a, DynamicObject b) {
            return a == b;
        }

        @Specialization(guards={"!isRubySymbol(b)"})
        public boolean equal(VirtualFrame frame, DynamicObject a, Object b) {
            return false;
        }
    }

    @CoreMethod(names={"all_symbols"}, onSingleton=true)
    public static abstract class AllSymbolsNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject allSymbols() {
            Object[] store = this.getContext().getSymbolTable().allSymbols().toArray();
            return Layouts.ARRAY.createArray(this.coreLibrary().getArrayFactory(), store, store.length);
        }
    }
}

