/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.source.SourceSection;
import org.jcodings.Encoding;
import org.jcodings.specific.UTF8Encoding;
import org.jruby.truffle.core.CoreClass;
import org.jruby.truffle.core.CoreMethod;
import org.jruby.truffle.core.UnaryCoreMethodNode;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringOperations;
import org.jruby.truffle.core.thread.ThreadBacktraceLocationLayoutImpl;
import org.jruby.truffle.language.backtrace.Activation;

@CoreClass(name="Thread::Backtrace::Location")
public class ThreadBacktraceLocationNodes {

    @CoreMethod(names={"to_s", "inspect"})
    public static abstract class ToSNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject toS(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            if (activation.getCallNode() == null) {
                return this.coreStrings().BACKTRACE_OMITTED_LIMIT.createInstance();
            }
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() == null) {
                return this.createString(StringOperations.encodeRope(sourceSection.getShortDescription(), (Encoding)UTF8Encoding.INSTANCE));
            }
            return this.createString(RopeOperations.format(this.getContext(), sourceSection.getSource().getName(), ":", sourceSection.getStartLine(), ":in `", sourceSection.getIdentifier(), "'"));
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LinenoNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public int lineno(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            return sourceSection.getStartLine();
        }
    }

    @CoreMethod(names={"absolute_path", "path"})
    public static abstract class AbsolutePathNode
    extends UnaryCoreMethodNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        public DynamicObject absolutePath(DynamicObject threadBacktraceLocation) {
            Activation activation = ThreadBacktraceLocationLayoutImpl.INSTANCE.getActivation(threadBacktraceLocation);
            if (activation.getCallNode() == null) {
                return this.coreStrings().BACKTRACE_OMITTED_LIMIT.createInstance();
            }
            SourceSection sourceSection = activation.getCallNode().getEncapsulatingSourceSection();
            if (sourceSection.getSource() == null) {
                return this.createString(StringOperations.encodeRope(sourceSection.getShortDescription(), (Encoding)UTF8Encoding.INSTANCE));
            }
            String path = sourceSection.getSource().getPath();
            if (path == null) {
                return this.coreStrings().UNKNOWN.createInstance();
            }
            return this.createString(this.getContext().getRopeTable().getRope(path));
        }
    }
}

