/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.debug;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameInstance;
import org.jruby.truffle.RubyContext;

public abstract class DebugHelpers {
    public static Object eval(String code, Object ... arguments) {
        return DebugHelpers.eval(RubyContext.getLatestInstance(), code, arguments);
    }

    public static Object eval(RubyContext context, String code, Object ... arguments) {
        CompilerAsserts.neverPartOfCompilation();
        FrameInstance currentFrameInstance = Truffle.getRuntime().getCurrentFrame();
        Frame currentFrame = currentFrameInstance.getFrame(FrameInstance.FrameAccess.MATERIALIZE, true);
        return context.getCodeLoader().inline(null, currentFrame, code, arguments);
    }
}

