/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.arguments;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.arguments.RubyArguments;

public class ReadRemainingArgumentsNode
extends RubyNode {
    private final int start;
    private final ConditionProfile remainingArguments = ConditionProfile.createBinaryProfile();

    public ReadRemainingArgumentsNode(int start) {
        this.start = start;
    }

    @Override
    public Object[] executeObjectArray(VirtualFrame frame) {
        int count = RubyArguments.getArgumentsCount(frame);
        if (this.remainingArguments.profile(this.start < count)) {
            return RubyArguments.getArguments(frame, this.start);
        }
        return new Object[0];
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.executeObjectArray(frame);
    }
}

