/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.Layouts;
import org.jruby.truffle.core.klass.ClassNodes;
import org.jruby.truffle.language.RubyConstant;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.control.RaiseException;
import org.jruby.truffle.language.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.language.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.language.objects.DefineModuleNode;

public class DefineClassNode
extends RubyNode {
    protected final String name;
    @Node.Child
    private RubyNode superClass;
    @Node.Child
    private CallDispatchHeadNode inheritedNode;
    @Node.Child
    private RubyNode lexicalParentModule;
    @Node.Child
    private IndirectCallNode indirectCallNode;
    private final ConditionProfile needToDefineProfile = ConditionProfile.createBinaryProfile();
    private final BranchProfile errorProfile = BranchProfile.create();

    public DefineClassNode(RubyContext context, SourceSection sourceSection, String name, RubyNode lexicalParent, RubyNode superClass) {
        super(context, sourceSection);
        this.name = name;
        this.lexicalParentModule = lexicalParent;
        this.superClass = superClass;
        this.indirectCallNode = IndirectCallNode.create();
    }

    @Override
    public Object execute(VirtualFrame frame) {
        DynamicObject definingClass;
        Object lexicalParentObject = this.lexicalParentModule.execute(frame);
        if (!RubyGuards.isRubyModule(lexicalParentObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeErrorIsNotA(lexicalParentObject, "module", (Node)this));
        }
        DynamicObject lexicalParentModule = (DynamicObject)lexicalParentObject;
        RubyConstant constant = DefineModuleNode.lookupForExistingModule(frame, this.getContext(), this.name, lexicalParentModule, this.indirectCallNode);
        Object superClassObject = this.superClass.execute(frame);
        if (!RubyGuards.isRubyClass(superClassObject)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("superclass must be a Class", this));
        }
        DynamicObject superClassModule = (DynamicObject)superClassObject;
        if (Layouts.CLASS.getIsSingleton(superClassModule)) {
            this.errorProfile.enter();
            throw new RaiseException(this.coreExceptions().typeError("can't make subclass of virtual class", this));
        }
        if (this.needToDefineProfile.profile(constant == null)) {
            definingClass = ClassNodes.createInitializedRubyClass(this.getContext(), lexicalParentModule, superClassModule, this.name);
            if (this.inheritedNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.inheritedNode = this.insert(DispatchHeadNodeFactory.createMethodCallOnSelf(this.getContext()));
            }
            this.inheritedNode.call(frame, superClassModule, "inherited", null, definingClass);
        } else {
            if (!RubyGuards.isRubyClass(constant.getValue())) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().typeErrorIsNotA(constant.getValue(), "class", (Node)this));
            }
            definingClass = (DynamicObject)constant.getValue();
            if (!this.isBlankOrRootClass(superClassModule) && !this.isBlankOrRootClass(definingClass) && ClassNodes.getSuperClass(definingClass) != superClassModule) {
                this.errorProfile.enter();
                throw new RaiseException(this.coreExceptions().superclassMismatch(Layouts.MODULE.getFields(definingClass).getName(), this));
            }
        }
        return definingClass;
    }

    private boolean isBlankOrRootClass(DynamicObject rubyClass) {
        return rubyClass == this.coreLibrary().getBasicObjectClass() || rubyClass == this.coreLibrary().getObjectClass();
    }
}

