/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.util.Collections;
import junit.framework.TestCase;
import org.junit.Test;
import org.languagetool.AnalyzedToken;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.chunking.ChunkTag;
import org.languagetool.language.Demo;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.PatternTokenMatcher;
import org.languagetool.rules.patterns.Unifier;

public class AbstractPatternRulePerformerTest {
    @Test
    public void testTestAllReadings() throws Exception {
        PatternToken patternToken1 = new PatternToken("foo", false, false, false);
        PatternRule simpleRule = new PatternRule("FAKE", (Language)new Demo(), Collections.singletonList(patternToken1), "descr", "message", "short");
        PatternTokenMatcher elemMatcher = new PatternTokenMatcher(patternToken1);
        MockAbstractPatternRulePerformer p = new MockAbstractPatternRulePerformer((AbstractPatternRule)simpleRule, null);
        TestCase.assertTrue((boolean)p.testAllReadings(this.tokenReadings("foo", null), elemMatcher, null, 0, 0, 0));
        TestCase.assertFalse((boolean)p.testAllReadings(this.tokenReadings("bar", null), elemMatcher, null, 0, 0, 0));
        TestCase.assertTrue((boolean)p.testAllReadings(this.tokenReadings("foo", "myChunk"), elemMatcher, null, 0, 0, 0));
        TestCase.assertTrue((boolean)p.testAllReadings(this.tokenReadings("foo", "otherChunk"), elemMatcher, null, 0, 0, 0));
    }

    @Test
    public void testTestAllReadingsWithChunks() throws Exception {
        PatternToken chunkPatternToken = new PatternToken(null, false, false, false);
        chunkPatternToken.setChunkTag(new ChunkTag("myChunk"));
        PatternRule simpleRule = new PatternRule("FAKE", (Language)new Demo(), Collections.singletonList(chunkPatternToken), "descr", "message", "short");
        PatternTokenMatcher elemMatcher = new PatternTokenMatcher(chunkPatternToken);
        MockAbstractPatternRulePerformer p = new MockAbstractPatternRulePerformer((AbstractPatternRule)simpleRule, null);
        TestCase.assertFalse((boolean)p.testAllReadings(this.tokenReadings("bar", null), elemMatcher, null, 0, 0, 0));
        TestCase.assertTrue((boolean)p.testAllReadings(this.tokenReadings("bar", "myChunk"), elemMatcher, null, 0, 0, 0));
        TestCase.assertFalse((boolean)p.testAllReadings(this.tokenReadings("bar", "otherChunk"), elemMatcher, null, 0, 0, 0));
    }

    private AnalyzedTokenReadings[] tokenReadings(String token, String chunkTag) {
        AnalyzedTokenReadings tokenReadings1 = new AnalyzedTokenReadings(new AnalyzedToken(token, "pos", "lemma"), 0);
        if (chunkTag != null) {
            tokenReadings1.setChunkTags(Collections.singletonList(new ChunkTag(chunkTag)));
        }
        return new AnalyzedTokenReadings[]{tokenReadings1};
    }

    class MockAbstractPatternRulePerformer
    extends AbstractPatternRulePerformer {
        protected MockAbstractPatternRulePerformer(AbstractPatternRule rule, Unifier unifier) {
            super(rule, unifier);
        }
    }
}

