/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.TestTools;
import org.languagetool.language.Demo;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.rules.patterns.PatternRuleMatcher;
import org.languagetool.rules.patterns.PatternRuleTest;
import org.languagetool.rules.patterns.PatternToken;

public class DemoPatternRuleTest
extends PatternRuleTest {
    private static final Language language = TestTools.getDemoLanguage();

    public void testRules() throws IOException {
        this.runTestForLanguage(new Demo());
    }

    public void testGrammarRulesFromXML2() throws IOException {
        new PatternRule("-1", language, Collections.emptyList(), "", "", "");
    }

    public void testMakeSuggestionUppercase() throws IOException {
        JLanguageTool langTool = new JLanguageTool(language);
        PatternToken patternToken = new PatternToken("Were", false, false, false);
        String message = "Did you mean: <suggestion>where</suggestion> or <suggestion>we</suggestion>?";
        PatternRule rule = new PatternRule("MY_ID", language, Collections.singletonList(patternToken), "desc", "Did you mean: <suggestion>where</suggestion> or <suggestion>we</suggestion>?", "msg");
        RuleMatch[] matches = rule.match(langTool.getAnalyzedSentence("Were are in the process of ..."));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        RuleMatch match = matches[0];
        List replacements = match.getSuggestedReplacements();
        DemoPatternRuleTest.assertEquals((int)2, (int)replacements.size());
        DemoPatternRuleTest.assertEquals((String)"Where", (String)((String)replacements.get(0)));
        DemoPatternRuleTest.assertEquals((String)"We", (String)((String)replacements.get(1)));
    }

    public void testRule() throws IOException {
        JLanguageTool langTool = new JLanguageTool(language);
        PatternRule pr = this.makePatternRule("one");
        RuleMatch[] matches = pr.match(langTool.getAnalyzedSentence("A non-matching sentence."));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("A matching sentence with one match."));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        DemoPatternRuleTest.assertEquals((int)25, (int)matches[0].getFromPos());
        DemoPatternRuleTest.assertEquals((int)28, (int)matches[0].getToPos());
        DemoPatternRuleTest.assertEquals((int)-1, (int)matches[0].getColumn());
        DemoPatternRuleTest.assertEquals((int)-1, (int)matches[0].getLine());
        DemoPatternRuleTest.assertEquals((String)"ID1", (String)matches[0].getRule().getId());
        DemoPatternRuleTest.assertTrue((boolean)matches[0].getMessage().equals("user visible message"));
        DemoPatternRuleTest.assertTrue((boolean)matches[0].getShortMessage().equals("short comment"));
        matches = pr.match(langTool.getAnalyzedSentence("one one and one: three matches"));
        DemoPatternRuleTest.assertEquals((int)3, (int)matches.length);
        pr = this.makePatternRule("one two");
        matches = pr.match(langTool.getAnalyzedSentence("this is one not two"));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("this is two one"));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("this is one two three"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("one two"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        pr = this.makePatternRule("one|foo|xxxx two", false, true);
        matches = pr.match(langTool.getAnalyzedSentence("one foo three"));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("one two"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("foo two"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("one foo two"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("y x z one two blah foo"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        pr = this.makePatternRule("one|foo|xxxx two|yyy", false, true);
        matches = pr.match(langTool.getAnalyzedSentence("one, yyy"));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("one yyy"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("xxxx two"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("xxxx yyy"));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
    }

    public void testSentenceStart() throws IOException {
        JLanguageTool langTool = new JLanguageTool(language);
        PatternRule pr = this.makePatternRule("SENT_START One");
        RuleMatch[] matches = pr.match(langTool.getAnalyzedSentence("Not One word."));
        DemoPatternRuleTest.assertEquals((int)0, (int)matches.length);
        matches = pr.match(langTool.getAnalyzedSentence("One word."));
        DemoPatternRuleTest.assertEquals((int)1, (int)matches.length);
    }

    public void testFormatMultipleSynthesis() throws Exception {
        String[] suggestions1 = new String[]{"blah blah", "foo bar"};
        DemoPatternRuleTest.assertEquals((String)"This is how you should write: <suggestion>blah blah</suggestion>, <suggestion>foo bar</suggestion>.", (String)PatternRuleMatcher.formatMultipleSynthesis((String[])suggestions1, (String)"This is how you should write: <suggestion>", (String)"</suggestion>."));
        String[] suggestions2 = new String[]{"test", " "};
        DemoPatternRuleTest.assertEquals((String)"This is how you should write: <suggestion>test</suggestion>, <suggestion> </suggestion>.", (String)PatternRuleMatcher.formatMultipleSynthesis((String[])suggestions2, (String)"This is how you should write: <suggestion>", (String)"</suggestion>."));
    }

    private PatternRule makePatternRule(String s) {
        return this.makePatternRule(s, false, false);
    }
}

