/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import junit.framework.TestCase;
import org.languagetool.AnalyzedToken;
import org.languagetool.rules.patterns.PatternToken;

public class PatternTokenTest
extends TestCase {
    public void testSentenceStart() {
        PatternToken patternToken = new PatternToken("", false, false, false);
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", false, false));
        PatternTokenTest.assertTrue((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", false, true));
        PatternTokenTest.assertFalse((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", true, false));
        PatternTokenTest.assertTrue((boolean)patternToken.isSentenceStart());
        patternToken.setPosToken(new PatternToken.PosToken("SENT_START", true, true));
        PatternTokenTest.assertFalse((boolean)patternToken.isSentenceStart());
        PatternToken patternToken2 = new PatternToken("bla|blah", false, true, false);
        patternToken2.setPosToken(new PatternToken.PosToken("foo", true, true));
        PatternTokenTest.assertFalse((boolean)patternToken2.isSentenceStart());
    }

    public void testUnknownTag() {
        PatternToken patternToken = new PatternToken("", false, false, false);
        patternToken.setPosToken(new PatternToken.PosToken("UNKNOWN", false, false));
        PatternToken patternToken2 = new PatternToken("", false, false, false);
        patternToken2.setPosToken(new PatternToken.PosToken("UNKNOWN", false, true));
        PatternToken patternToken3 = new PatternToken("", false, false, false);
        patternToken3.setPosToken(new PatternToken.PosToken("UNKNOWN|VBG", true, false));
        PatternToken patternToken4 = new PatternToken("", false, false, false);
        patternToken4.setPosToken(new PatternToken.PosToken("UNKNOWN|VBG", true, true));
        PatternToken patternToken5 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken5.setPosToken(new PatternToken.PosToken("UNKNOWN", false, false));
        AnalyzedToken an = new AnalyzedToken("schword", null, null);
        PatternTokenTest.assertTrue((boolean)patternToken.isMatched(an));
        PatternTokenTest.assertFalse((boolean)patternToken2.isMatched(an));
        PatternTokenTest.assertTrue((boolean)patternToken3.isMatched(an));
        PatternTokenTest.assertFalse((boolean)patternToken4.isMatched(an));
        PatternTokenTest.assertTrue((boolean)patternToken5.isMatched(an));
        an.setNoPOSTag(false);
        PatternTokenTest.assertFalse((boolean)patternToken.isMatched(an));
        PatternTokenTest.assertTrue((boolean)patternToken2.isMatched(an));
        PatternTokenTest.assertFalse((boolean)patternToken3.isMatched(an));
        PatternTokenTest.assertTrue((boolean)patternToken4.isMatched(an));
        PatternTokenTest.assertFalse((boolean)patternToken5.isMatched(an));
        AnalyzedToken anSentEnd = new AnalyzedToken("schword", "SENT_END", null);
        PatternTokenTest.assertTrue((boolean)patternToken.isMatched(anSentEnd));
        PatternTokenTest.assertFalse((boolean)patternToken2.isMatched(anSentEnd));
        PatternTokenTest.assertTrue((boolean)patternToken3.isMatched(anSentEnd));
        PatternTokenTest.assertFalse((boolean)patternToken4.isMatched(anSentEnd));
        PatternTokenTest.assertTrue((boolean)patternToken5.isMatched(anSentEnd));
        PatternToken patternToken6 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken6.setPosToken(new PatternToken.PosToken("SENT_END", false, false));
        PatternTokenTest.assertTrue((boolean)patternToken6.isMatched(anSentEnd));
        PatternToken patternToken7 = new PatternToken("\\p{Ll}+", false, true, false);
        patternToken7.setPosToken(new PatternToken.PosToken("SENT_END|BLABLA", true, false));
        PatternTokenTest.assertTrue((boolean)patternToken7.isMatched(anSentEnd));
        anSentEnd.setNoPOSTag(false);
        PatternTokenTest.assertFalse((boolean)patternToken.isMatched(anSentEnd));
        PatternTokenTest.assertTrue((boolean)patternToken2.isMatched(anSentEnd));
        PatternTokenTest.assertFalse((boolean)patternToken3.isMatched(anSentEnd));
        PatternTokenTest.assertTrue((boolean)patternToken4.isMatched(anSentEnd));
        PatternTokenTest.assertFalse((boolean)patternToken5.isMatched(anSentEnd));
        AnalyzedToken anParaEnd = new AnalyzedToken("schword", "PARA_END", null);
        PatternTokenTest.assertTrue((boolean)patternToken.isMatched(anParaEnd));
        PatternTokenTest.assertFalse((boolean)patternToken2.isMatched(anParaEnd));
        PatternTokenTest.assertTrue((boolean)patternToken3.isMatched(anParaEnd));
        PatternTokenTest.assertFalse((boolean)patternToken4.isMatched(anParaEnd));
        PatternTokenTest.assertTrue((boolean)patternToken5.isMatched(anParaEnd));
        anParaEnd.setNoPOSTag(false);
        PatternTokenTest.assertFalse((boolean)patternToken.isMatched(anParaEnd));
        PatternTokenTest.assertTrue((boolean)patternToken2.isMatched(anParaEnd));
        PatternTokenTest.assertFalse((boolean)patternToken3.isMatched(anParaEnd));
        PatternTokenTest.assertTrue((boolean)patternToken4.isMatched(anParaEnd));
        PatternTokenTest.assertFalse((boolean)patternToken5.isMatched(anParaEnd));
        AnalyzedToken anWithPOS = new AnalyzedToken("schword", "POS", null);
        PatternTokenTest.assertFalse((boolean)patternToken.isMatched(anWithPOS));
        PatternTokenTest.assertTrue((boolean)patternToken2.isMatched(anWithPOS));
        PatternTokenTest.assertFalse((boolean)patternToken3.isMatched(anWithPOS));
        PatternTokenTest.assertTrue((boolean)patternToken4.isMatched(anWithPOS));
        PatternTokenTest.assertFalse((boolean)patternToken5.isMatched(anWithPOS));
    }
}

