/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.pdmodel.encryption;

import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSString;
import org.sejda.sambox.pdmodel.encryption.AccessPermission;
import org.sejda.sambox.pdmodel.encryption.DecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.MessageDigests;
import org.sejda.sambox.pdmodel.encryption.PDEncryption;
import org.sejda.sambox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.sejda.sambox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.sejda.sambox.pdmodel.encryption.SecurityHandler;

public final class PublicKeySecurityHandler
extends SecurityHandler {
    public static final String FILTER = "Adobe.PubSec";
    private PublicKeyProtectionPolicy policy = null;

    public PublicKeySecurityHandler() {
    }

    public PublicKeySecurityHandler(PublicKeyProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    @Override
    public void prepareForDecryption(PDEncryption encryption, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws IOException {
        if (!(decryptionMaterial instanceof PublicKeyDecryptionMaterial)) {
            throw new IOException("Provided decryption material is not compatible with the document");
        }
        this.setDecryptMetadata(encryption.isEncryptMetaData());
        if (encryption.getLength() != 0) {
            this.keyLength = encryption.getLength();
        }
        PublicKeyDecryptionMaterial material = (PublicKeyDecryptionMaterial)decryptionMaterial;
        try {
            int i;
            boolean foundRecipient = false;
            byte[] envelopedData = null;
            byte[][] recipientFieldsBytes = new byte[encryption.getRecipientsLength()][];
            int recipientFieldsLength = 0;
            StringBuilder extraInfo = new StringBuilder();
            for (i = 0; i < encryption.getRecipientsLength(); ++i) {
                COSString recipientFieldString = encryption.getRecipientStringAt(i);
                byte[] recipientBytes = recipientFieldString.getBytes();
                CMSEnvelopedData data = new CMSEnvelopedData(recipientBytes);
                Iterator<RecipientInformation> recipCertificatesIt = data.getRecipientInfos().getRecipients().iterator();
                int j = 0;
                while (recipCertificatesIt.hasNext()) {
                    RecipientId rid;
                    RecipientInformation ri = recipCertificatesIt.next();
                    X509Certificate certificate = material.getCertificate();
                    X509CertificateHolder materialCert = null;
                    if (null != certificate) {
                        materialCert = new X509CertificateHolder(certificate.getEncoded());
                    }
                    if ((rid = ri.getRID()).match(materialCert) && !foundRecipient) {
                        foundRecipient = true;
                        PrivateKey privateKey = (PrivateKey)material.getPrivateKey();
                        envelopedData = ri.getContent(new JceKeyTransEnvelopedRecipient(privateKey).setProvider("BC"));
                        break;
                    }
                    ++j;
                    if (certificate == null) continue;
                    extraInfo.append('\n');
                    extraInfo.append(j);
                    extraInfo.append(": ");
                    if (!(rid instanceof KeyTransRecipientId)) continue;
                    this.appendCertInfo(extraInfo, (KeyTransRecipientId)rid, certificate, materialCert);
                }
                recipientFieldsBytes[i] = recipientBytes;
                recipientFieldsLength += recipientBytes.length;
            }
            if (!foundRecipient || envelopedData == null) {
                throw new IOException("The certificate matches none of " + i + " recipient entries" + extraInfo.toString());
            }
            if (envelopedData.length != 24) {
                throw new IOException("The enveloped data does not contain 24 bytes");
            }
            byte[] accessBytes = new byte[4];
            System.arraycopy(envelopedData, 20, accessBytes, 0, 4);
            AccessPermission currentAccessPermission = new AccessPermission(accessBytes);
            currentAccessPermission.setReadOnly();
            this.setCurrentAccessPermission(currentAccessPermission);
            byte[] sha1Input = new byte[recipientFieldsLength + 20];
            System.arraycopy(envelopedData, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (byte[] recipientFieldsByte : recipientFieldsBytes) {
                System.arraycopy(recipientFieldsByte, 0, sha1Input, sha1InputOffset, recipientFieldsByte.length);
                sha1InputOffset += recipientFieldsByte.length;
            }
            MessageDigest md = MessageDigests.getSHA1();
            byte[] mdResult = md.digest(sha1Input);
            this.encryptionKey = new byte[this.keyLength / 8];
            System.arraycopy(mdResult, 0, this.encryptionKey, 0, this.keyLength / 8);
        }
        catch (CMSException e) {
            throw new IOException(e);
        }
        catch (KeyStoreException e) {
            throw new IOException(e);
        }
        catch (CertificateEncodingException e) {
            throw new IOException(e);
        }
    }

    private void appendCertInfo(StringBuilder extraInfo, KeyTransRecipientId ktRid, X509Certificate certificate, X509CertificateHolder materialCert) {
        BigInteger ridSerialNumber = ktRid.getSerialNumber();
        if (ridSerialNumber != null) {
            String certSerial = "unknown";
            BigInteger certSerialNumber = certificate.getSerialNumber();
            if (certSerialNumber != null) {
                certSerial = certSerialNumber.toString(16);
            }
            extraInfo.append("serial-#: rid ");
            extraInfo.append(ridSerialNumber.toString(16));
            extraInfo.append(" vs. cert ");
            extraInfo.append(certSerial);
            extraInfo.append(" issuer: rid '");
            extraInfo.append(ktRid.getIssuer());
            extraInfo.append("' vs. cert '");
            extraInfo.append(materialCert == null ? "null" : materialCert.getIssuer());
            extraInfo.append("' ");
        }
    }

    @Override
    public boolean hasProtectionPolicy() {
        return this.policy != null;
    }
}

