/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.internet.AddressException;

public class NewsAddress
extends Address {
    private static final String TYPE = "news";
    protected String newsgroup;
    protected String host;

    public NewsAddress() {
    }

    public NewsAddress(String newsgroup) {
        this(newsgroup, null);
    }

    public NewsAddress(String newsgroup, String host) {
        this.newsgroup = newsgroup;
        this.host = host;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public void setNewsgroup(String newsgroup) {
        this.newsgroup = newsgroup;
    }

    public String getNewsgroup() {
        return this.newsgroup;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }

    @Override
    public String toString() {
        return this.newsgroup;
    }

    @Override
    public boolean equals(Object a) {
        if (a instanceof NewsAddress) {
            NewsAddress na = (NewsAddress)a;
            return this.newsgroup.equals(na.newsgroup) && (this.host == null && na.host == null || this.host != null && na.host != null && this.host.equalsIgnoreCase(na.host));
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 0;
        if (this.newsgroup != null) {
            hashCode += this.newsgroup.hashCode();
        }
        if (this.host != null) {
            hashCode += this.host.hashCode();
        }
        return hashCode;
    }

    public static String toString(Address[] addresses) {
        if (addresses == null || addresses.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < addresses.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            NewsAddress na = (NewsAddress)addresses[i];
            buffer.append(na.toString());
        }
        return buffer.toString();
    }

    public static NewsAddress[] parse(String newsgroups) throws AddressException {
        StringTokenizer st = new StringTokenizer(newsgroups, ",");
        ArrayList<NewsAddress> acc = new ArrayList<NewsAddress>();
        while (st.hasMoreTokens()) {
            acc.add(new NewsAddress(st.nextToken()));
        }
        NewsAddress[] addresses = new NewsAddress[acc.size()];
        acc.toArray(addresses);
        return addresses;
    }
}

