/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import gnu.inet.util.GetSystemPropertyAction;
import java.io.UnsupportedEncodingException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;

public class ParameterList {
    private LinkedHashMap list = new LinkedHashMap();

    public ParameterList() {
    }

    public ParameterList(String s) throws ParseException {
        Object value;
        GetSystemPropertyAction a = new GetSystemPropertyAction("mail.mime.decodeparameters");
        boolean decodeParameters = "true".equals(AccessController.doPrivileged(a));
        LinkedHashMap<String, String> charsets = new LinkedHashMap<String, String>();
        HeaderTokenizer ht = new HeaderTokenizer(s, "()<>@,;:\\\"\t []/?=");
        int type = 0;
        while (type != -4) {
            HeaderTokenizer.Token token = ht.next();
            type = token.getType();
            if (type == -4) continue;
            if (type != 59) {
                throw new ParseException("expected ';': " + s);
            }
            token = ht.next();
            type = token.getType();
            if (type != -1) {
                throw new ParseException("expected parameter name: " + s);
            }
            String key = token.getValue().toLowerCase();
            token = ht.next();
            type = token.getType();
            if (type != 61) {
                throw new ParseException("expected '=': " + s);
            }
            token = ht.next();
            type = token.getType();
            if (type != -1 && type != -2) {
                throw new ParseException("expected parameter value: " + s);
            }
            value = token.getValue();
            int si = key.indexOf(42);
            if (decodeParameters && si > 0) {
                int len = key.length();
                if (si == len - 1 || si == len - 3 && key.charAt(si + 1) == '0' && key.charAt(si + 2) == '*') {
                    key = key.substring(0, si);
                    int ai = ((String)value).indexOf(39);
                    if (ai == -1) {
                        throw new ParseException("no charset specified: " + (String)value);
                    }
                    String charset = ((String)value).substring(0, ai);
                    charset = MimeUtility.javaCharset(charset);
                    charsets.put(key, charset);
                    int i = ((String)value).indexOf(39, ai + 1);
                    while (i != -1) {
                        ai = i;
                        i = ((String)value).indexOf(39, ai + 1);
                    }
                    value = this.decode(((String)value).substring(ai + 1), charset);
                    ArrayList values = new ArrayList();
                    this.set(values, 0, value);
                    this.list.put(key, values);
                    continue;
                }
                int end = key.charAt(len - 1) == '*' ? len - 1 : len;
                int section = -1;
                try {
                    section = Integer.parseInt(key.substring(si + 1, end));
                    if (section < 1) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException e) {
                    throw new ParseException("invalid section: " + key);
                }
                key = key.substring(0, si);
                String charset = (String)charsets.get(key);
                ArrayList values = (ArrayList)this.list.get(key);
                if (charset == null || values == null) {
                    throw new ParseException("no initial extended parameter for '" + key + "'");
                }
                if (type == -1) {
                    value = this.decode((String)value, charset);
                }
                this.set(values, section, value);
                continue;
            }
            this.set(key, (String)value, null);
        }
        int len = this.list.size();
        String[] keys = new String[len];
        this.list.keySet().toArray(keys);
        for (int i = 0; i < len; ++i) {
            value = this.list.get(keys[i]);
            if (!(value instanceof ArrayList)) continue;
            ArrayList values = (ArrayList)value;
            StringBuffer buf = new StringBuffer();
            for (String comp : values) {
                if (comp == null) continue;
                buf.append(comp);
            }
            String charset = (String)charsets.get(keys[i]);
            this.set(keys[i], buf.toString(), charset);
        }
    }

    private void set(ArrayList list, int index, Object value) {
        int len = list.size();
        while (index > len - 1) {
            list.add(null);
            ++len;
        }
        list.set(index, value);
    }

    private String decode(String text, String charset) throws ParseException {
        char[] schars = text.toCharArray();
        int slen = schars.length;
        byte[] dchars = new byte[slen];
        int dlen = 0;
        for (int i = 0; i < slen; ++i) {
            char c = schars[i];
            if (c == '%') {
                if (i + 3 > slen) {
                    throw new ParseException("malformed: " + text);
                }
                int val = Character.digit(schars[i + 2], 16) + Character.digit(schars[i + 1], 16) * 16;
                dchars[dlen++] = (byte)val;
                i += 2;
                continue;
            }
            dchars[dlen++] = (byte)c;
        }
        try {
            return new String(dchars, 0, dlen, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new ParseException("Unsupported encoding: " + charset);
        }
    }

    public int size() {
        return this.list.size();
    }

    public String get(String name) {
        String[] vc = (String[])this.list.get(name.toLowerCase().trim());
        return vc != null ? vc[0] : null;
    }

    public void set(String name, String value) {
        this.set(name, value, null);
    }

    public void set(String name, String value, String charset) {
        String[] vc = new String[]{value, charset};
        this.list.put(name.toLowerCase().trim(), vc);
    }

    public void remove(String name) {
        this.list.remove(name.toLowerCase().trim());
    }

    public Enumeration getNames() {
        return new ParameterEnumeration(this.list.keySet().iterator());
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int used) {
        GetSystemPropertyAction a = new GetSystemPropertyAction("mail.mime.encodeparameters");
        boolean encodeParameters = "true".equals(AccessController.doPrivileged(a));
        StringBuffer buffer = new StringBuffer();
        for (Map.Entry entry : this.list.entrySet()) {
            String key = (String)entry.getKey();
            String[] vc = (String[])entry.getValue();
            String value = vc[0];
            String charset = vc[1];
            if (encodeParameters) {
                try {
                    value = MimeUtility.encodeText(value, charset, "Q");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            value = MimeUtility.quote(value, "()<>@,;:\\\"\t []/?=");
            buffer.append("; ");
            int len = key.length() + value.length() + 1;
            if ((used += 2) + len > 76) {
                buffer.append("\r\n\t");
                used = 8;
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(value);
        }
        return buffer.toString();
    }

    static class ParameterEnumeration
    implements Enumeration {
        Iterator source;

        ParameterEnumeration(Iterator source) {
            this.source = source;
        }

        @Override
        public boolean hasMoreElements() {
            return this.source.hasNext();
        }

        public Object nextElement() {
            return this.source.next();
        }
    }
}

