/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui.tabcontrol;

import java.awt.Component;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.core.windows.Debug;
import org.netbeans.core.windows.ModeImpl;
import org.netbeans.core.windows.WindowManagerImpl;
import org.netbeans.core.windows.actions.ActionUtils;
import org.netbeans.core.windows.view.ui.tabcontrol.TabbedAdapter;
import org.netbeans.swing.tabcontrol.ComponentConverter;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.customtabs.Tabbed;
import org.netbeans.swing.tabcontrol.plaf.EqualPolygon;
import org.openide.util.ChangeSupport;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public abstract class AbstractTabbedImpl
extends Tabbed {
    private PropertyChangeListener tooltipListener;
    private PropertyChangeListener weakTooltipListener;
    private final ChangeSupport cs = new ChangeSupport((Object)this);
    private static final boolean DEBUG = Debug.isLoggable(TabbedAdapter.class);

    protected abstract TabDataModel getTabModel();

    protected abstract SingleSelectionModel getSelectionModel();

    public final void addTopComponent(String string, Icon icon, TopComponent topComponent, String string2) {
        this.insertComponent(string, icon, (Component)topComponent, string2, this.getTabCount());
    }

    public final TopComponent getTopComponentAt(int n) {
        if (n == -1 || n >= this.getTabModel().size()) {
            return null;
        }
        return (TopComponent)this.getTabModel().getTab(n).getComponent();
    }

    public final TopComponent getSelectedTopComponent() {
        int n = this.getSelectionModel().getSelectedIndex();
        return n == -1 ? null : this.getTopComponentAt(n);
    }

    public final void requestAttention(TopComponent topComponent) {
        int n = this.indexOf((Component)topComponent);
        if (n >= 0) {
            this.requestAttention(n);
        } else {
            Logger.getAnonymousLogger().fine("RequestAttention on component unknown to container: " + topComponent);
        }
    }

    protected abstract void requestAttention(int var1);

    public final void cancelRequestAttention(TopComponent topComponent) {
        int n = this.indexOf((Component)topComponent);
        if (n < 0) {
            throw new IllegalArgumentException("TopComponent " + topComponent + " is not a child of this container");
        }
        this.cancelRequestAttention(n);
    }

    protected abstract void cancelRequestAttention(int var1);

    public final void setAttentionHighlight(TopComponent topComponent, boolean bl) {
        int n = this.indexOf((Component)topComponent);
        if (n < 0) {
            throw new IllegalArgumentException("TopComponent " + topComponent + " is not a child of this container");
        }
        this.setAttentionHighlight(n, bl);
    }

    protected abstract void setAttentionHighlight(int var1, boolean var2);

    public final void insertComponent(String string, Icon icon, Component component, String string2, int n) {
        TabData tabData = new TabData((Object)component, icon, string, string2);
        if (DEBUG) {
            Debug.log(AbstractTabbedImpl.class, "InsertTab: " + string + " hash:" + System.identityHashCode(component));
        }
        this.getTabModel().addTab(n, tabData);
        component.addPropertyChangeListener("ToolTipText", this.getTooltipListener(component));
    }

    public final void setSelectedComponent(Component component) {
        int n = this.indexOf(component);
        if (n == -1 && null != component) {
            throw new IllegalArgumentException("Component not a child of this control: " + component);
        }
        this.getSelectionModel().setSelectedIndex(n);
    }

    public final TopComponent[] getTopComponents() {
        ComponentConverter componentConverter = this.getComponentConverter();
        TabData[] tabDataArray = this.getTabModel().getTabs().toArray(new TabData[0]);
        TopComponent[] topComponentArray = new TopComponent[this.getTabModel().size()];
        for (int i = 0; i < tabDataArray.length; ++i) {
            topComponentArray[i] = (TopComponent)componentConverter.getComponent(tabDataArray[i]);
        }
        return topComponentArray;
    }

    public final void removeComponent(Component component) {
        int n = this.indexOf(component);
        this.getTabModel().removeTab(n);
        component.removePropertyChangeListener("ToolTipText", this.getTooltipListener(component));
        if (this.getTabModel().size() == 0) {
            ((JComponent)this.getComponent()).revalidate();
            ((JComponent)this.getComponent()).repaint();
        }
    }

    public final void setTopComponents(TopComponent[] topComponentArray, TopComponent topComponent) {
        int n;
        if (topComponent == null && topComponentArray.length > 0) {
            topComponent = topComponentArray[0];
            Logger.getLogger(TabbedAdapter.class.getName()).warning("Selected component is null although open components are " + Arrays.asList(topComponentArray));
        }
        int n2 = this.getTabModel().size();
        this.detachTooltipListeners(this.getTabModel().getTabs());
        TabData[] tabDataArray = new TabData[topComponentArray.length];
        int n3 = -1;
        for (n = 0; n < topComponentArray.length; ++n) {
            TopComponent topComponent2 = topComponentArray[n];
            Image image = topComponent2.getIcon();
            String string = WindowManagerImpl.getInstance().getTopComponentDisplayName(topComponent2);
            tabDataArray[n] = new TabData((Object)topComponent2, (Icon)(image == null ? null : new ImageIcon(image)), string == null ? "" : string, topComponent2.getToolTipText());
            if (topComponent == topComponentArray[n]) {
                n3 = n;
            }
            topComponent2.addPropertyChangeListener("ToolTipText", this.getTooltipListener((Component)topComponent2));
        }
        assert (topComponent != null && n3 != -1) : "Tried to set a selected component that was  not in the array of open components. ToSelect: " + topComponent + " ToSelectName=" + topComponent.getDisplayName() + " ToSelectClass=" + topComponent.getClass() + " open components: " + Arrays.asList(topComponentArray);
        this.getTabModel().setTabs(tabDataArray);
        if (n3 != -1) {
            this.getSelectionModel().setSelectedIndex(n3);
        } else if (topComponent != null) {
            Logger.getAnonymousLogger().warning("Tried toset a selected component that was not in the array of open components.  ToSelect: " + topComponent + " components: " + Arrays.asList(topComponentArray));
        }
        n = this.getTabModel().size();
        if (n2 != 0 && n == 0) {
            ((JComponent)this.getComponent()).revalidate();
            ((JComponent)this.getComponent()).repaint();
        }
    }

    public final Object getConstraintForLocation(Point point, boolean bl) {
        String string;
        int n = this.tabForCoordinate(point);
        if (n != -1) {
            int n2 = this.dropIndexOfPoint(point);
            return n2 < 0 ? null : Integer.valueOf(n2);
        }
        if (bl && (string = this.getSideForLocation(point)) != null) {
            return string;
        }
        int n3 = this.dropIndexOfPoint(point);
        return n3 < 0 ? null : Integer.valueOf(n3);
    }

    protected abstract int dropIndexOfPoint(Point var1);

    private String getSideForLocation(Point point) {
        Rectangle rectangle;
        int n;
        Rectangle rectangle2 = this.getComponent().getBounds();
        rectangle2.setLocation(0, 0);
        int n2 = (int)(0.25 * (double)rectangle2.height);
        int n3 = n = Math.max(this.getComponent().getWidth() / 8, 40);
        if (DEBUG) {
            AbstractTabbedImpl.debugLog("");
            AbstractTabbedImpl.debugLog("TOP_HEIGHT    =10");
            AbstractTabbedImpl.debugLog("BOTTOM_HEIGHT =" + n2);
            AbstractTabbedImpl.debugLog("LEFT_WIDTH    =" + n);
            AbstractTabbedImpl.debugLog("RIGHT_WIDTH   =" + n3);
        }
        if ((rectangle = new Rectangle(0, 0, rectangle2.width, n2)).contains(point)) {
            return "top";
        }
        EqualPolygon equalPolygon = new EqualPolygon(new int[]{0, n, n, 0}, new int[]{10, 10, rectangle2.height - n2, rectangle2.height}, 4);
        if (equalPolygon.contains(point)) {
            return "left";
        }
        EqualPolygon equalPolygon2 = new EqualPolygon(new int[]{rectangle2.width - n3, rectangle2.width, rectangle2.width, rectangle2.width - n3}, new int[]{10, 10, rectangle2.height, rectangle2.height - n2}, 4);
        if (equalPolygon2.contains(point)) {
            return "right";
        }
        EqualPolygon equalPolygon3 = new EqualPolygon(new int[]{n, rectangle2.width - n3, rectangle2.width, 0}, new int[]{rectangle2.height - n2, rectangle2.height - n2, rectangle2.height, rectangle2.height}, 4);
        if (equalPolygon3.contains(point)) {
            return "bottom";
        }
        return null;
    }

    public final Shape getIndicationForLocation(Point point, TopComponent topComponent, Point point2, boolean bl) {
        Object object;
        Rectangle rectangle = this.getComponent().getBounds();
        rectangle.setLocation(0, 0);
        TopComponent topComponent2 = topComponent;
        int n = this.tabForCoordinate(point);
        if (n != -1 && (object = this.getDropIndication(topComponent2, point)) != null) {
            return object;
        }
        object = bl ? this.getSideForLocation(point) : null;
        double d = 0.5;
        if (object == "top") {
            return new Rectangle(0, 0, rectangle.width, (int)((double)rectangle.height * d));
        }
        if (object == "left") {
            return new Rectangle(0, 0, (int)((double)rectangle.width * d), rectangle.height);
        }
        if (object == "right") {
            return new Rectangle(rectangle.width - (int)((double)rectangle.width * d), 0, (int)((double)rectangle.width * d), rectangle.height);
        }
        if (object == "bottom") {
            return new Rectangle(0, rectangle.height - (int)((double)rectangle.height * d), rectangle.width, (int)((double)rectangle.height * d));
        }
        Shape shape = this.getDropIndication(topComponent2, point);
        if (shape != null) {
            return shape;
        }
        if (null != topComponent && point2 != null && this.indexOf((Component)topComponent) != -1) {
            return this.getStartingIndication(point2, point);
        }
        return rectangle;
    }

    private Shape getStartingIndication(Point point, Point point2) {
        Rectangle rectangle = this.getComponent().getBounds();
        rectangle.setLocation(point2.x - point.x, point2.y - point.y);
        return rectangle;
    }

    public final Action[] getPopupActions(Action[] actionArray, int n) {
        if (n < 0) {
            ModeImpl modeImpl = this.getModeImpl();
            if (null != modeImpl) {
                return ActionUtils.createDefaultPopupActions(modeImpl);
            }
            return null;
        }
        return actionArray;
    }

    private ModeImpl getModeImpl() {
        TopComponent[] topComponentArray = this.getTopComponents();
        if (topComponentArray.length < 1) {
            return null;
        }
        return (ModeImpl)WindowManagerImpl.getInstance().findMode(topComponentArray[0]);
    }

    public final void addChangeListener(ChangeListener changeListener) {
        this.cs.addChangeListener(changeListener);
    }

    public final void removeChangeListener(ChangeListener changeListener) {
        this.cs.removeChangeListener(changeListener);
    }

    public boolean isBusy(TopComponent topComponent) {
        return WindowManagerImpl.getInstance().isTopComponentBusy(topComponent);
    }

    protected abstract ComponentConverter getComponentConverter();

    PropertyChangeListener getTooltipListener(Component component) {
        if (this.tooltipListener == null) {
            this.tooltipListener = new ToolTipListener();
            this.weakTooltipListener = WeakListeners.propertyChange((PropertyChangeListener)this.tooltipListener, (Object)component);
        }
        return this.weakTooltipListener;
    }

    protected abstract Shape getDropIndication(TopComponent var1, Point var2);

    private void detachTooltipListeners(List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JComponent jComponent = (JComponent)((TabData)iterator.next()).getComponent();
            jComponent.removePropertyChangeListener("ToolTipText", this.getTooltipListener(jComponent));
        }
    }

    protected final void fireStateChanged() {
        if (!SwingUtilities.isEventDispatchThread()) {
            Logger.getAnonymousLogger().warning("All state changes to the tab component must happen on the event thread!");
            Exception exception = new Exception();
            exception.fillInStackTrace();
            Logger.getAnonymousLogger().warning(exception.getStackTrace()[1].toString());
        }
        this.cs.fireChange();
    }

    private static void debugLog(String string) {
        Debug.log(TabbedAdapter.class, string);
    }

    private class ToolTipListener
    implements PropertyChangeListener {
        private ToolTipListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("ToolTipText".equals(propertyChangeEvent.getPropertyName())) {
                List list = AbstractTabbedImpl.this.getTabModel().getTabs();
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    JComponent jComponent = (JComponent)((TabData)iterator.next()).getComponent();
                    if (jComponent == propertyChangeEvent.getSource() && n < AbstractTabbedImpl.this.getTabCount()) {
                        AbstractTabbedImpl.this.setToolTipTextAt(n, (String)propertyChangeEvent.getNewValue());
                        break;
                    }
                    ++n;
                }
            }
        }
    }
}

