/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javajs.util.AU;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.SB;
import org.jmol.api.SymmetryInterface;
import org.jmol.java.BS;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Chain;
import org.jmol.modelset.Group;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Orientation;
import org.jmol.util.BSUtil;

public class Model {
    public ModelSet ms;
    public M4 mat4;
    public int modelIndex;
    int fileIndex;
    public boolean isBioModel;
    public boolean isPdbWithMultipleBonds;
    public boolean isModelKit;
    public Chain[] chains = new Chain[8];
    public SymmetryInterface simpleCage;
    public Map<String, Object> dssrCache;
    public Orientation orientation;
    protected Map<String, Object> auxiliaryInfo;
    public Properties properties;
    public SymmetryInterface biosymmetry;
    Map<String, Integer> dataFrames;
    P3 translation;
    int dataSourceFrame = -1;
    public String loadState = "";
    public SB loadScript = new SB();
    public boolean hasRasmolHBonds;
    public boolean structureTainted;
    public boolean isJmolDataFrame;
    boolean isTrajectory;
    public int trajectoryBaseIndex;
    public int altLocCount;
    int insertionCount;
    public int act = 0;
    private int bondCount = -1;
    protected int chainCount = 0;
    public int groupCount = -1;
    public int hydrogenCount;
    public int moleculeCount;
    int biosymmetryCount;
    public int firstAtomIndex;
    int firstMoleculeIndex;
    public final BS bsAtoms = new BS();
    public final BS bsAtomsDeleted = new BS();
    float defaultRotationRadius;
    public long frameDelay;
    public int selectedTrajectory = -1;
    String jmolData;
    String jmolFrameType;
    public String pdbID;
    private BS bsCheck;

    public Model set(ModelSet modelSet, int modelIndex, int trajectoryBaseIndex, String jmolData, Properties properties, Map<String, Object> auxiliaryInfo) {
        this.ms = modelSet;
        this.dataSourceFrame = this.modelIndex = modelIndex;
        this.isTrajectory = trajectoryBaseIndex >= 0;
        int n = this.trajectoryBaseIndex = this.isTrajectory ? trajectoryBaseIndex : modelIndex;
        if (auxiliaryInfo == null) {
            auxiliaryInfo = new Hashtable<String, Object>();
        }
        this.auxiliaryInfo = auxiliaryInfo;
        if (auxiliaryInfo.containsKey("biosymmetryCount")) {
            this.biosymmetryCount = (Integer)auxiliaryInfo.get("biosymmetryCount");
            this.biosymmetry = (SymmetryInterface)auxiliaryInfo.get("biosymmetry");
        }
        this.properties = properties;
        if (jmolData == null) {
            this.jmolFrameType = "modelSet";
        } else {
            this.jmolData = jmolData;
            this.isJmolDataFrame = true;
            auxiliaryInfo.put("jmolData", jmolData);
            auxiliaryInfo.put("title", jmolData);
            this.jmolFrameType = jmolData.indexOf("ramachandran") >= 0 ? "ramachandran" : (jmolData.indexOf("quaternion") >= 0 ? "quaternion" : "data");
        }
        return this;
    }

    public int getTrueAtomCount() {
        return this.bsAtoms.cardinality() - this.bsAtomsDeleted.cardinality();
    }

    public boolean isContainedIn(BS bs) {
        if (this.bsCheck == null) {
            this.bsCheck = new BS();
        }
        this.bsCheck.or(bs);
        this.bsCheck.and(this.bsAtoms);
        this.bsCheck.andNot(this.bsAtomsDeleted);
        return this.bsCheck.cardinality() == this.getTrueAtomCount();
    }

    public void resetBoundCount() {
        this.bondCount = -1;
    }

    public int getBondCount() {
        if (this.bondCount >= 0) {
            return this.bondCount;
        }
        Bond[] bonds = this.ms.bo;
        this.bondCount = 0;
        int i = this.ms.bondCount;
        while (--i >= 0) {
            if (bonds[i].atom1.mi != this.modelIndex) continue;
            ++this.bondCount;
        }
        return this.bondCount;
    }

    public int getChainCount(boolean countWater) {
        if (this.chainCount > 1 && !countWater) {
            for (int i = 0; i < this.chainCount; ++i) {
                if (this.chains[i].chainID != 0) continue;
                return this.chainCount - 1;
            }
        }
        return this.chainCount;
    }

    void calcSelectedGroupsCount(BS bsSelected) {
        int i = this.chainCount;
        while (--i >= 0) {
            this.chains[i].calcSelectedGroupsCount(bsSelected);
        }
    }

    public int getGroupCount() {
        if (this.groupCount < 0) {
            this.groupCount = 0;
            int i = this.chainCount;
            while (--i >= 0) {
                this.groupCount += this.chains[i].groupCount;
            }
        }
        return this.groupCount;
    }

    public Chain getChainAt(int i) {
        return i < this.chainCount ? this.chains[i] : null;
    }

    Chain getChain(int chainID) {
        int i = this.chainCount;
        while (--i >= 0) {
            Chain chain = this.chains[i];
            if (chain.chainID != chainID) continue;
            return chain;
        }
        return null;
    }

    public void fixIndices(int modelIndex, int nAtomsDeleted, BS bsDeleted) {
        this.fixIndicesM(modelIndex, nAtomsDeleted, bsDeleted);
    }

    protected void fixIndicesM(int modelIndex, int nAtomsDeleted, BS bsDeleted) {
        if (this.dataSourceFrame > modelIndex) {
            --this.dataSourceFrame;
        }
        if (this.trajectoryBaseIndex > modelIndex) {
            --this.trajectoryBaseIndex;
        }
        this.firstAtomIndex -= nAtomsDeleted;
        for (int i = 0; i < this.chainCount; ++i) {
            this.chains[i].fixIndices(nAtomsDeleted, bsDeleted);
        }
        BSUtil.deleteBits(this.bsAtoms, bsDeleted);
        BSUtil.deleteBits(this.bsAtomsDeleted, bsDeleted);
    }

    public boolean freeze() {
        this.freezeM();
        return false;
    }

    protected void freezeM() {
        int i;
        for (i = 0; i < this.chainCount; ++i) {
            if (this.chains[i].groupCount != 0) continue;
            for (int j = i + 1; j < this.chainCount; ++j) {
                this.chains[j - 1] = this.chains[j];
            }
            --this.chainCount;
        }
        this.chains = (Chain[])AU.arrayCopyObject(this.chains, this.chainCount);
        this.groupCount = -1;
        this.getGroupCount();
        for (i = 0; i < this.chainCount; ++i) {
            this.chains[i].groups = (Group[])AU.arrayCopyObject(this.chains[i].groups, this.chains[i].groupCount);
        }
    }
}

