/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.i18n;

import org.jmol.i18n.GT;

public class Language {
    public final String code;
    public final String language;
    public final String nativeLanguage;
    public boolean display;

    public static Language[] getLanguageList() {
        return new Language[]{new Language("ar", GT._("Arabic"), "\u0627\u0644\u0639\u0631\u0628\u064a\u0629", false), new Language("ast", GT._("Asturian"), "Asturian", false), new Language("az", GT._("Azerbaijani"), "az\u0259rbaycan dili", false), new Language("bs", GT._("Bosnian"), "bosanski jezik", false), new Language("ca", GT._("Catalan"), "Catal\u00e0", true), new Language("cs", GT._("Czech"), "\u010ce\u0161tina", true), new Language("da", GT._("Danish"), "Dansk", true), new Language("de", GT._("German"), "Deutsch", true), new Language("el", GT._("Greek"), "\u0395\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac", false), new Language("en_AU", GT._("Australian English"), "Australian English", false), new Language("en_GB", GT._("British English"), "British English", true), new Language("en_US", GT._("American English"), "American English", true), new Language("es", GT._("Spanish"), "Espa\u00f1ol", true), new Language("et", GT._("Estonian"), "Eesti", false), new Language("eu", GT._("Basque"), "Euskara", true), new Language("fi", GT._("Finnish"), "Suomi", true), new Language("fo", GT._("Faroese"), "F\u00f8royskt", false), new Language("fr", GT._("French"), "Fran\u00e7ais", true), new Language("fy", GT._("Frisian"), "Frysk", false), new Language("gl", GT._("Galician"), "Galego", false), new Language("hr", GT._("Croatian"), "Hrvatski", false), new Language("hu", GT._("Hungarian"), "Magyar", true), new Language("hy", GT._("Armenian"), "\u0540\u0561\u0575\u0565\u0580\u0565\u0576", false), new Language("id", GT._("Indonesian"), "Indonesia", true), new Language("it", GT._("Italian"), "Italiano", true), new Language("ja", GT._("Japanese"), "\u65e5\u672c\u8a9e", true), new Language("jv", GT._("Javanese"), "Basa Jawa", false), new Language("ko", GT._("Korean"), "\ud55c\uad6d\uc5b4", true), new Language("ms", GT._("Malay"), "Bahasa Melayu", true), new Language("nb", GT._("Norwegian Bokmal"), "Norsk Bokm\u00e5l", false), new Language("nl", GT._("Dutch"), "Nederlands", true), new Language("oc", GT._("Occitan"), "Occitan", false), new Language("pl", GT._("Polish"), "Polski", false), new Language("pt", GT._("Portuguese"), "Portugu\u00eas", false), new Language("pt_BR", GT._("Brazilian Portuguese"), "Portugu\u00eas brasileiro", true), new Language("ru", GT._("Russian"), "\u0420\u0443\u0441\u0441\u043a\u0438\u0439", false), new Language("sl", GT._("Slovenian"), "Sloven\u0161\u010dina", false), new Language("sr", GT._("Serbian"), "\u0441\u0440\u043f\u0441\u043a\u0438 \u0458\u0435\u0437\u0438\u043a", false), new Language("sv", GT._("Swedish"), "Svenska", true), new Language("ta", GT._("Tamil"), "\u0ba4\u0bae\u0bbf\u0bb4\u0bcd", false), new Language("te", GT._("Telugu"), "\u0c24\u0c46\u0c32\u0c41\u0c17\u0c41", false), new Language("tr", GT._("Turkish"), "T\u00fcrk\u00e7e", true), new Language("ug", GT._("Uyghur"), "Uy\u01a3urq\u0259", false), new Language("uk", GT._("Ukrainian"), "\u0423\u043a\u0440\u0430\u0457\u043d\u0441\u044c\u043a\u0430", true), new Language("uz", GT._("Uzbek"), "O'zbek", false), new Language("zh_CN", GT._("Simplified Chinese"), "\u7b80\u4f53\u4e2d\u6587", true), new Language("zh_TW", GT._("Traditional Chinese"), "\u7e41\u9ad4\u4e2d\u6587", true)};
    }

    private Language(String code, String language, String nativeLanguage, boolean display) {
        this.code = code;
        this.language = language;
        this.nativeLanguage = nativeLanguage;
        this.display = display;
    }

    static String getSupported(Language[] list, String code) {
        int i = list.length;
        while (--i >= 0) {
            if (!list[i].code.equalsIgnoreCase(code)) continue;
            return list[i].code;
        }
        i = list.length;
        while (--i >= 0) {
            if (!list[i].code.startsWith(code)) continue;
            return list[i].code;
        }
        return null;
    }
}

