/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import javajs.util.M3;
import javajs.util.M4;
import javajs.util.P3;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Pixelator;
import org.jmol.util.Shader;

public class SphereRenderer {
    private final Graphics3D g3d;
    private final Shader shader;
    private static final int maxOddSizeSphere = 49;
    static final int maxSphereDiameter = 1000;
    static final int maxSphereDiameter2 = 2000;
    private double[] zroot = new double[2];
    private M3 mat;
    private double[] coef;
    private M4 mDeriv;
    private int selectedOctant;
    private int planeShade;
    private int[] zbuf;
    private int width;
    private int height;
    private int depth;
    private int slab;
    private int offsetPbufBeginLine;
    private static final int SHADE_SLAB_CLIPPED = 47;
    private final P3 ptTemp = new P3();
    private final int[] planeShades = new int[3];
    private final float[][] dxyz = new float[3][3];

    SphereRenderer(Graphics3D g3d) {
        this.g3d = g3d;
        this.shader = g3d.shader;
    }

    void render(int[] shades, int diameter, int x, int y, int z, M3 mat, double[] coef, M4 mDeriv, int selectedOctant, P3[] octantPoints) {
        if (z == 1) {
            return;
        }
        if (diameter > 49) {
            diameter &= 0xFFFFFFFE;
        }
        if (this.g3d.isClippedXY(diameter, x, y)) {
            return;
        }
        this.slab = this.g3d.slab;
        this.depth = this.g3d.depth;
        int radius = diameter + 1 >> 1;
        int minZ = z - radius;
        if (z + radius < this.slab || minZ > this.depth) {
            return;
        }
        int minX = x - radius;
        int maxX = x + radius;
        int minY = y - radius;
        int maxY = y + radius;
        this.shader.nIn = 0;
        this.shader.nOut = 0;
        this.zbuf = this.g3d.zbuf;
        this.height = this.g3d.height;
        this.width = this.g3d.width;
        this.offsetPbufBeginLine = this.width * y + x;
        Shader sh = this.shader;
        this.mat = mat;
        if (mat != null) {
            this.coef = coef;
            this.mDeriv = mDeriv;
            this.selectedOctant = selectedOctant;
            if (sh.ellipsoidShades == null) {
                sh.createEllipsoidShades();
            }
            if (octantPoints != null) {
                this.planeShade = -1;
                for (int i = 0; i < 3; ++i) {
                    float f = octantPoints[i].x - (float)x;
                    this.dxyz[i][0] = f;
                    float dx = f;
                    float f2 = octantPoints[i].y - (float)y;
                    this.dxyz[i][1] = f2;
                    float dy = f2;
                    float f3 = octantPoints[i].z - (float)z;
                    this.dxyz[i][2] = f3;
                    float dz = f3;
                    this.planeShades[i] = sh.getShadeIndex(dx, dy, -dz);
                    if (dx != 0.0f || dy != 0.0f) continue;
                    this.planeShade = this.planeShades[i];
                    break;
                }
            }
        }
        if (mat != null || diameter > 128) {
            this.renderQuadrant(-1, -1, x, y, z, diameter, shades);
            this.renderQuadrant(-1, 1, x, y, z, diameter, shades);
            this.renderQuadrant(1, -1, x, y, z, diameter, shades);
            this.renderQuadrant(1, 1, x, y, z, diameter, shades);
            if (mat != null) {
                this.mat = null;
                this.coef = null;
                this.mDeriv = null;
            }
        } else {
            int[] ss = sh.sphereShapeCache[diameter - 1];
            if (ss == null) {
                int countSE = 0;
                boolean d = (diameter & 1) != 0;
                float radiusF = (float)diameter / 2.0f;
                float radiusF2 = radiusF * radiusF;
                radius = (diameter + 1) / 2;
                float ys = d ? 0.0f : 0.5f;
                int i = 0;
                while (i < radius) {
                    float y2 = ys * ys;
                    float xs = d ? 0.0f : 0.5f;
                    int j = 0;
                    while (j < radius) {
                        float x2 = xs * xs;
                        float z2 = radiusF2 - y2 - x2;
                        if (z2 >= 0.0f) {
                            ++countSE;
                        }
                        ++j;
                        xs += 1.0f;
                    }
                    ++i;
                    ys += 1.0f;
                }
                ss = new int[countSE];
                int offset = 0;
                ys = d ? 0.0f : 0.5f;
                int i2 = 0;
                while (i2 < radius) {
                    float y2 = ys * ys;
                    float xs = d ? 0.0f : 0.5f;
                    int j = 0;
                    while (j < radius) {
                        float x2 = xs * xs;
                        float z2 = radiusF2 - y2 - x2;
                        if (z2 >= 0.0f) {
                            float zs = (float)Math.sqrt(z2);
                            int height = (int)zs;
                            byte shadeIndexSE = sh.getShadeN(xs, ys, zs, radiusF);
                            byte shadeIndexSW = sh.getShadeN(-xs, ys, zs, radiusF);
                            byte shadeIndexNE = sh.getShadeN(xs, -ys, zs, radiusF);
                            byte shadeIndexNW = sh.getShadeN(-xs, -ys, zs, radiusF);
                            int packed = height | shadeIndexSE << 7 | shadeIndexSW << 13 | shadeIndexNE << 19 | shadeIndexNW << 25;
                            ss[offset++] = packed;
                        }
                        ++j;
                        xs += 1.0f;
                    }
                    int n = offset - 1;
                    ss[n] = ss[n] | Integer.MIN_VALUE;
                    ++i2;
                    ys += 1.0f;
                }
                sh.sphereShapeCache[diameter - 1] = ss;
            }
            if (minX < 0 || maxX >= this.width || minY < 0 || maxY >= this.height || minZ < this.slab || z > this.depth) {
                this.renderSphereClipped(ss, x, y, z, diameter, shades);
            } else {
                this.renderSphereUnclipped(ss, z, diameter, shades);
            }
        }
        this.zbuf = null;
    }

    private void renderSphereUnclipped(int[] sphereShape, int z, int diameter, int[] shades) {
        int offsetSphere = 0;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = this.offsetPbufBeginLine;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * this.width;
        int nLines = (diameter + 1) / 2;
        int[] zbuf = this.zbuf;
        int width = this.width;
        Pixelator p = this.g3d.pixel;
        do {
            int packed;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            do {
                int zPixel;
                if ((zPixel = z - ((packed = sphereShape[offsetSphere++]) & 0x7F)) < zbuf[offsetSE]) {
                    p.addPixel(offsetSE, zPixel, shades[packed >> 7 & 0x3F]);
                }
                if (zPixel < zbuf[offsetSW]) {
                    p.addPixel(offsetSW, zPixel, shades[packed >> 13 & 0x3F]);
                }
                if (zPixel < zbuf[offsetNE]) {
                    p.addPixel(offsetNE, zPixel, shades[packed >> 19 & 0x3F]);
                }
                if (zPixel < zbuf[offsetNW]) {
                    p.addPixel(offsetNW, zPixel, shades[packed >> 25 & 0x3F]);
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
            } while (packed >= 0);
            offsetSouthCenter += width;
            offsetNorthCenter -= width;
        } while (--nLines > 0);
    }

    private void renderSphereClipped(int[] sphereShape, int x, int y, int z, int diameter, int[] shades) {
        int w = this.width;
        int h = this.height;
        int offsetSphere = 0;
        int evenSizeCorrection = 1 - (diameter & 1);
        int offsetSouthCenter = this.offsetPbufBeginLine;
        int offsetNorthCenter = offsetSouthCenter - evenSizeCorrection * w;
        int nLines = (diameter + 1) / 2;
        int ySouth = y;
        int yNorth = y - evenSizeCorrection;
        int randu = (x << 16) + (y << 1) ^ 0x33333333;
        int[] sh = shades;
        int[] zb = this.zbuf;
        Pixelator p = this.g3d.pixel;
        int sl = this.slab;
        int de = this.depth;
        do {
            int packed;
            boolean tSouthVisible = ySouth >= 0 && ySouth < h;
            boolean tNorthVisible = yNorth >= 0 && yNorth < h;
            int offsetSE = offsetSouthCenter;
            int offsetSW = offsetSouthCenter - evenSizeCorrection;
            int offsetNE = offsetNorthCenter;
            int offsetNW = offsetNorthCenter - evenSizeCorrection;
            int xEast = x;
            int xWest = x - evenSizeCorrection;
            do {
                boolean isCore;
                int zPixel;
                boolean tWestVisible = xWest >= 0 && xWest < w;
                boolean tEastVisible = xEast >= 0 && xEast < w;
                packed = sphereShape[offsetSphere++];
                int zOffset = packed & 0x7F;
                if (z < sl) {
                    zPixel = z + zOffset;
                    isCore = zPixel >= sl;
                } else {
                    zPixel = z - zOffset;
                    boolean bl = isCore = zPixel < sl;
                }
                if (isCore) {
                    zPixel = sl;
                }
                if (zPixel >= sl && zPixel <= de) {
                    int i;
                    if (tSouthVisible) {
                        if (tEastVisible && zPixel < zb[offsetSE]) {
                            i = isCore ? 44 + (randu >> 7 & 7) : packed >> 7 & 0x3F;
                            p.addPixel(offsetSE, zPixel, sh[i]);
                        }
                        if (tWestVisible && zPixel < zb[offsetSW]) {
                            i = isCore ? 44 + (randu >> 13 & 7) : packed >> 13 & 0x3F;
                            p.addPixel(offsetSW, zPixel, sh[i]);
                        }
                    }
                    if (tNorthVisible) {
                        if (tEastVisible && zPixel < zb[offsetNE]) {
                            i = isCore ? 44 + (randu >> 19 & 7) : packed >> 19 & 0x3F;
                            p.addPixel(offsetNE, zPixel, sh[i]);
                        }
                        if (tWestVisible && zPixel < zb[offsetNW]) {
                            i = isCore ? 44 + (randu >> 25 & 7) : packed >> 25 & 0x3F;
                            p.addPixel(offsetNW, zPixel, sh[i]);
                        }
                    }
                }
                ++offsetSE;
                --offsetSW;
                ++offsetNE;
                --offsetNW;
                ++xEast;
                --xWest;
                if (!isCore) continue;
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
            } while (packed >= 0);
            offsetSouthCenter += w;
            offsetNorthCenter -= w;
            ++ySouth;
            --yNorth;
        } while (--nLines > 0);
    }

    private void renderQuadrant(int xSign, int ySign, int x, int y, int z, int diameter, int[] shades) {
        boolean unclipped;
        int radius;
        int t;
        int xStatus = (x < 0 ? -1 : (x < this.width ? 0 : 1)) + ((t = x + (radius = diameter / 2) * xSign) < 0 ? -2 : (t < this.width ? 0 : 2));
        if (xStatus == -3 || xStatus == 3) {
            return;
        }
        int yStatus = (y < 0 ? -1 : (y < this.height ? 0 : 1)) + ((t = y + radius * ySign) < 0 ? -2 : (t < this.height ? 0 : 2));
        if (yStatus == -3 || yStatus == 3) {
            return;
        }
        boolean bl = unclipped = this.mat == null && xStatus == 0 && yStatus == 0 && z - radius >= this.slab && z <= this.depth;
        if (unclipped) {
            this.renderQuadrantUnclipped(radius, xSign, ySign, z, shades);
        } else {
            this.renderQuadrantClipped(radius, xSign, ySign, x, y, z, shades);
        }
    }

    private void renderQuadrantUnclipped(int radius, int xSign, int ySign, int z, int[] s) {
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        int lineIncrement = ySign < 0 ? -this.width : this.width;
        int ptLine = this.offsetPbufBeginLine;
        int[] zb = this.zbuf;
        Pixelator p = this.g3d.pixel;
        byte[] indexes = this.shader.sphereShadeIndexes;
        int i = 0;
        int i2 = 0;
        while (i2 <= r2) {
            int offset = ptLine;
            int s2 = r2 - i2;
            int z0 = z - radius;
            int y8 = (i * ySign + radius << 8) / dDivisor;
            int j = 0;
            int j2 = 0;
            while (j2 <= s2) {
                int k;
                if (zb[offset] > z0 && zb[offset] > (z0 = z - (k = (int)Math.sqrt(s2 - j2)))) {
                    int x8 = (j * xSign + radius << 8) / dDivisor;
                    p.addPixel(offset, z0, s[indexes[(y8 << 8) + x8]]);
                }
                j2 += j++ + j;
                offset += xSign;
            }
            i2 += i++ + i;
            ptLine += lineIncrement;
        }
    }

    private void renderQuadrantClipped(int radius, int xSign, int ySign, int x, int y, int z, int[] shades) {
        boolean isEllipsoid = this.mat != null;
        boolean checkOctant = this.selectedOctant >= 0;
        int r2 = radius * radius;
        int dDivisor = radius * 2 + 1;
        int lineIncrement = ySign < 0 ? -this.width : this.width;
        int ptLine = this.offsetPbufBeginLine;
        int randu = (x << 16) + (y << 1) ^ 0x33333333;
        int y8 = 0;
        int iShade = 0;
        Pixelator p = this.g3d.pixel;
        int z1 = 0;
        int h = this.height;
        int w = this.width;
        int x0 = x;
        int[] zb = this.zbuf;
        float[][] xyz = this.dxyz;
        int y0 = y;
        int z0 = z;
        int sl = this.slab;
        int de = this.depth;
        P3 pt = this.ptTemp;
        double[] c = this.coef;
        double[] rt = this.zroot;
        int oct = this.selectedOctant;
        Shader s = this.shader;
        int[] pl = this.planeShades;
        byte[] indexes = s.sphereShadeIndexes;
        int ps = this.planeShade;
        M3 m = this.mat;
        int i = 0;
        int i2 = 0;
        int yC = y;
        while (i2 <= r2) {
            block30: {
                block31: {
                    block29: {
                        if (yC >= 0) break block29;
                        if (ySign < 0) {
                            return;
                        }
                        break block30;
                    }
                    if (yC < h) break block31;
                    if (ySign > 0) {
                        return;
                    }
                    break block30;
                }
                int s2 = r2 - (isEllipsoid ? 0 : i2);
                if (!isEllipsoid) {
                    y8 = (i * ySign + radius << 8) / dDivisor;
                }
                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                int xC = x0;
                int j = 0;
                int j2 = 0;
                int iRoot = -1;
                int mode = 1;
                int offset = ptLine;
                while (j2 <= s2) {
                    block33: {
                        int zPixel;
                        block37: {
                            boolean isCore;
                            block35: {
                                double f;
                                double b_2a;
                                block36: {
                                    block34: {
                                        block32: {
                                            if (xC >= 0) break block32;
                                            if (xSign < 0) {
                                                break;
                                            }
                                            break block33;
                                        }
                                        if (xC < w) break block34;
                                        if (xSign > 0) {
                                            break;
                                        }
                                        break block33;
                                    }
                                    if (!isEllipsoid) break block35;
                                    b_2a = (c[4] * (double)xC + c[5] * (double)yC + c[8]) / c[2] / 2.0;
                                    double c_a = (c[0] * (double)xC * (double)xC + c[1] * (double)yC * (double)yC + c[3] * (double)xC * (double)yC + c[6] * (double)xC + c[7] * (double)yC - 1.0) / c[2];
                                    f = b_2a * b_2a - c_a;
                                    if (!(f < 0.0)) break block36;
                                    if (iRoot >= 0) {
                                        break;
                                    }
                                    break block33;
                                }
                                f = Math.sqrt(f);
                                rt[0] = -b_2a - f;
                                rt[1] = -b_2a + f;
                                iRoot = z0 < sl ? 1 : 0;
                                zPixel = (int)rt[iRoot];
                                if (zPixel == 0) {
                                    zPixel = z0;
                                }
                                mode = 2;
                                z1 = zPixel;
                                if (checkOctant) {
                                    boolean isCore2;
                                    pt.set(xC - x0, yC - y0, zPixel - z0);
                                    m.rotate(pt);
                                    int thisOctant = 0;
                                    if (pt.x < 0.0f) {
                                        thisOctant |= 1;
                                    }
                                    if (pt.y < 0.0f) {
                                        thisOctant |= 2;
                                    }
                                    if (pt.z < 0.0f) {
                                        thisOctant |= 4;
                                    }
                                    if (thisOctant == oct) {
                                        if (ps >= 0) {
                                            iShade = ps;
                                        } else {
                                            int iMin = 3;
                                            float zMin = Float.MAX_VALUE;
                                            for (int ii = 0; ii < 3; ++ii) {
                                                float ptz;
                                                float dz = xyz[ii][2];
                                                if (dz == 0.0f || !((ptz = (float)z0 + (-xyz[ii][0] * (float)(xC - x) - xyz[ii][1] * (float)(yC - y0)) / dz) < zMin)) continue;
                                                zMin = ptz;
                                                iMin = ii;
                                            }
                                            if (iMin == 3) {
                                                iMin = 0;
                                                zMin = z0;
                                            }
                                            rt[0] = zMin;
                                            iShade = pl[iMin];
                                        }
                                        zPixel = (int)rt[0];
                                        mode = 3;
                                    }
                                    boolean bl = z0 < sl ? zPixel >= sl : (isCore2 = zPixel < sl);
                                    if (isCore2) {
                                        z1 = zPixel = sl;
                                        mode = 0;
                                    }
                                }
                                if (zPixel >= sl && zPixel <= de && zb[offset] > z1) break block37;
                                break block33;
                            }
                            int zOffset = (int)Math.sqrt(s2 - j2);
                            zPixel = z0 + (z0 < sl ? zOffset : -zOffset);
                            boolean bl = z0 < sl ? zPixel >= sl : (isCore = zPixel < sl);
                            if (isCore) {
                                zPixel = sl;
                                mode = 0;
                            }
                            if (zPixel < sl || zPixel > de || zb[offset] <= zPixel) break block33;
                        }
                        switch (mode) {
                            case 0: {
                                iShade = 44 + (randu >> 8 & 7);
                                randu = (randu << 16) + (randu << 1) + randu & Integer.MAX_VALUE;
                                mode = 1;
                                break;
                            }
                            case 2: {
                                iShade = s.getEllipsoidShade(xC, yC, (float)rt[iRoot], radius, this.mDeriv);
                                break;
                            }
                            case 3: {
                                p.clearPixel(offset, z1);
                                break;
                            }
                            default: {
                                int x8 = (j * xSign + radius << 8) / dDivisor;
                                iShade = indexes[(y8 << 8) + x8];
                            }
                        }
                        p.addPixel(offset, zPixel, shades[iShade]);
                    }
                    j2 += j++ + j;
                    offset += xSign;
                    xC += xSign;
                }
                randu = (randu + xC + yC | 1) & Integer.MAX_VALUE;
            }
            i2 += i++ + i;
            ptLine += lineIncrement;
            yC += ySign;
        }
    }
}

