/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.swing.SwingTools;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.DefaultFormatter;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;

public class AutoCommitSpinner
extends JSpinner {
    public AutoCommitSpinner(SpinnerModel spinnerModel) {
        this(spinnerModel, null);
    }

    public AutoCommitSpinner(SpinnerModel spinnerModel, Format format) {
        super(spinnerModel);
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor) {
            final JFormattedTextField jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField();
            SwingTools.addAutoSelectionOnFocusGain(jFormattedTextField);
            if (jFormattedTextField.getFormatterFactory() instanceof DefaultFormatterFactory) {
                DefaultFormatterFactory defaultFormatterFactory = (DefaultFormatterFactory)jFormattedTextField.getFormatterFactory();
                JFormattedTextField.AbstractFormatter abstractFormatter = defaultFormatterFactory.getDefaultFormatter();
                if (abstractFormatter instanceof DefaultFormatter) {
                    ((DefaultFormatter)abstractFormatter).setCommitsOnValidEdit(true);
                }
                if (abstractFormatter instanceof NumberFormatter) {
                    final NumberFormatter numberFormatter = (NumberFormatter)abstractFormatter;
                    NumberFormatter numberFormatter2 = new NumberFormatter(){
                        private boolean keepFocusedTextUnchanged;
                        {
                            final KeyAdapter keyAdapter = new KeyAdapter(){

                                public void keyTyped(KeyEvent keyEvent) {
                                    keepFocusedTextUnchanged = true;
                                }
                            };
                            jFormattedTextField.addFocusListener(new FocusAdapter(){

                                public void focusGained(FocusEvent focusEvent) {
                                    jFormattedTextField.addKeyListener(keyAdapter);
                                }

                                public void focusLost(FocusEvent focusEvent) {
                                    jFormattedTextField.removeKeyListener(keyAdapter);
                                }
                            });
                        }

                        @Override
                        public Format getFormat() {
                            Format format = super.getFormat();
                            if (jFormattedTextField.hasFocus() && format instanceof DecimalFormat) {
                                DecimalFormat decimalFormat = (DecimalFormat)format.clone();
                                decimalFormat.setGroupingUsed(false);
                                return decimalFormat;
                            }
                            return format;
                        }

                        public Comparable getMaximum() {
                            return numberFormatter.getMaximum();
                        }

                        public Comparable getMinimum() {
                            return numberFormatter.getMinimum();
                        }

                        public void setMaximum(Comparable comparable) {
                            numberFormatter.setMaximum(comparable);
                        }

                        public void setMinimum(Comparable comparable) {
                            numberFormatter.setMinimum(comparable);
                        }

                        @Override
                        public Class<?> getValueClass() {
                            return numberFormatter.getValueClass();
                        }

                        @Override
                        public String valueToString(Object object) throws ParseException {
                            if (jFormattedTextField.hasFocus() && this.keepFocusedTextUnchanged) {
                                this.keepFocusedTextUnchanged = false;
                                return jFormattedTextField.getText();
                            }
                            return super.valueToString(object);
                        }
                    };
                    numberFormatter2.setCommitsOnValidEdit(true);
                    jFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(numberFormatter2));
                }
            }
        }
        if (format != null) {
            this.setFormat(format);
        }
    }

    public void setFormat(Format format) {
        JFormattedTextField jFormattedTextField;
        JFormattedTextField.AbstractFormatter abstractFormatter;
        JComponent jComponent = this.getEditor();
        if (jComponent instanceof JSpinner.DefaultEditor && (abstractFormatter = (jFormattedTextField = ((JSpinner.DefaultEditor)jComponent).getTextField()).getFormatter()) instanceof NumberFormatter) {
            ((NumberFormatter)abstractFormatter).setFormat(format);
            this.fireStateChanged();
        }
    }

    public static class SpinnerModuloNumberModel
    extends SpinnerNumberModel {
        public SpinnerModuloNumberModel(int n, int n2, int n3, int n4) {
            super(n, n2, n3, n4);
        }

        public Object getNextValue() {
            if (this.getNumber().intValue() + this.getStepSize().intValue() < ((Number)((Object)this.getMaximum())).intValue()) {
                return ((Number)super.getNextValue()).intValue();
            }
            return this.getNumber().intValue() + this.getStepSize().intValue() - ((Number)((Object)this.getMaximum())).intValue() + ((Number)((Object)this.getMinimum())).intValue();
        }

        public Object getPreviousValue() {
            if (this.getNumber().intValue() - this.getStepSize().intValue() >= ((Number)((Object)this.getMinimum())).intValue()) {
                return ((Number)super.getPreviousValue()).intValue();
            }
            return this.getNumber().intValue() - this.getStepSize().intValue() - ((Number)((Object)this.getMinimum())).intValue() + ((Number)((Object)this.getMaximum())).intValue();
        }
    }
}

