/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer;

import java.io.File;
import java.util.concurrent.TimeUnit;
import org.gradle.testkit.jarjar.org.gradle.util.GradleVersion;
import org.gradle.tooling.internal.consumer.ConnectionParameters;

public abstract class AbstractConnectionParameters
implements ConnectionParameters {
    private final File gradleUserHomeDir;
    private final Boolean embedded;
    private final Integer daemonMaxIdleTimeValue;
    private final TimeUnit daemonMaxIdleTimeUnits;
    private final File daemonBaseDir;
    private final boolean verboseLogging;

    protected AbstractConnectionParameters(File gradleUserHomeDir, Boolean embedded, Integer daemonMaxIdleTimeValue, TimeUnit daemonMaxIdleTimeUnits, File daemonBaseDir, boolean verboseLogging) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        this.embedded = embedded;
        this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
        this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
        this.daemonBaseDir = daemonBaseDir;
        this.verboseLogging = verboseLogging;
    }

    public File getDaemonBaseDir() {
        return this.daemonBaseDir;
    }

    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public Boolean isEmbedded() {
        return this.embedded;
    }

    public Integer getDaemonMaxIdleTimeValue() {
        return this.daemonMaxIdleTimeValue;
    }

    public TimeUnit getDaemonMaxIdleTimeUnits() {
        return this.daemonMaxIdleTimeUnits;
    }

    public String getConsumerVersion() {
        return GradleVersion.current().getVersion();
    }

    public boolean getVerboseLogging() {
        return this.verboseLogging;
    }

    public static class Builder {
        protected File gradleUserHomeDir;
        protected Boolean embedded;
        protected Integer daemonMaxIdleTimeValue;
        protected TimeUnit daemonMaxIdleTimeUnits;
        protected boolean verboseLogging;
        protected File daemonBaseDir;

        protected Builder() {
        }

        public Builder setGradleUserHomeDir(File gradleUserHomeDir) {
            this.gradleUserHomeDir = gradleUserHomeDir;
            return this;
        }

        public Builder setEmbedded(Boolean embedded) {
            this.embedded = embedded;
            return this;
        }

        public Builder setDaemonMaxIdleTimeValue(Integer daemonMaxIdleTimeValue) {
            this.daemonMaxIdleTimeValue = daemonMaxIdleTimeValue;
            return this;
        }

        public Builder setDaemonMaxIdleTimeUnits(TimeUnit daemonMaxIdleTimeUnits) {
            this.daemonMaxIdleTimeUnits = daemonMaxIdleTimeUnits;
            return this;
        }

        public Builder setVerboseLogging(boolean verboseLogging) {
            this.verboseLogging = verboseLogging;
            return this;
        }

        public void setDaemonBaseDir(File daemonBaseDir) {
            this.daemonBaseDir = daemonBaseDir;
        }
    }
}

