#!/bin/sh
export PATH='/usr/lib/distcc/bin:/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name: psqueues
version: 0.2.2.1
id: psqueues-0.2.2.1-7824de609dc312a467c2b75622b6db3f
key: psque_AvLcbKUIB1yCm8wZoS0YR7
license: BSD3
maintainer: Jasper Van der Jeugt <jaspervdj@gmail.com>
synopsis: Pure priority search queues
description:
    The psqueues package provides
    <http://en.wikipedia.org/wiki/Priority_queue Priority Search Queues> in
    three different flavors.
    .
    * @OrdPSQ k p v@, which uses the @Ord k@ instance to provide fast insertion,
    deletion and lookup. This implementation is based on Ralf Hinze'\''s
    <http://citeseer.ist.psu.edu/hinze01simple.html A Simple Implementation Technique for Priority Search Queues>.
    Hence, it is similar to the
    <http://hackage.haskell.org/package/PSQueue PSQueue> library, although it is
    considerably faster and provides a slightly different API.
    .
    * @IntPSQ p v@ is a far more efficient implementation. It fixes the key type
    to @Int@ and uses a <http://en.wikipedia.org/wiki/Radix_tree radix tree>
    (like @IntMap@) with an additional min-heap property.
    .
    * @HashPSQ k p v@ is a fairly straightforward extension of @IntPSQ@: it
    simply uses the keys'\'' hashes as indices in the @IntPSQ@. If there are any
    hash collisions, it uses an @OrdPSQ@ to resolve those. The performance of
    this implementation is comparable to that of @IntPSQ@, but it is more widely
    applicable since the keys are not restricted to @Int@, but rather to any
    @Hashable@ datatype.
    .
    Each of the three implementations provides the same API, so they can be used
    interchangeably. The benchmarks show how they perform relative to one
    another, and also compared to the other Priority Search Queue
    implementations on Hackage:
    <http://hackage.haskell.org/package/PSQueue PSQueue>
    and
    <http://hackage.haskell.org/package/fingertree-psqueue fingertree-psqueue>.
    .
    <<http://i.imgur.com/KmbDKR6.png>>
    .
    <<http://i.imgur.com/ClT181D.png>>
    .
    Typical applications of Priority Search Queues include:
    .
    * Caches, and more specifically LRU Caches;
    .
    * Schedulers;
    .
    * Pathfinding algorithms, such as Dijkstra'\''s and A*.
category: Data Structures
exposed: True
exposed-modules:
    Data.HashPSQ Data.IntPSQ Data.OrdPSQ
hidden-modules: Data.BitUtil Data.HashPSQ.Internal
                Data.IntPSQ.Internal Data.OrdPSQ.Internal
trusted: False
import-dirs: /usr/lib/ghc-7.10.3/site-local/psqueues-0.2.2.1
library-dirs: /usr/lib/ghc-7.10.3/site-local/psqueues-0.2.2.1
data-dir: /usr/share/arm-linux-ghc-7.10.3/psqueues-0.2.2.1
hs-libraries: HSpsqueues-0.2.2.1-AvLcbKUIB1yCm8wZoS0YR7
depends:
    base-4.8.2.0-2f1f71a7fcf013cd47fd21f489064f9a
    deepseq-1.4.1.1-3975618f889b45239daa47b7443eaeee
    ghc-prim-0.4.0.0-bf246eb9fdda7435f0c147a313ce59fb
    hashable-1.2.4.0-165ac1864c8f5bd906b25f6a12db4f18
haddock-interfaces: /usr/share/doc/haskell-psqueues/html/psqueues.haddock
haddock-html: /usr/share/doc/haskell-psqueues/html
' | '/usr/bin/ghc-pkg' 'update' '-' '--global' '--no-user-package-db' "$@"
