/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs.relation.sort;

import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationNodeMap;
import org.openstreetmap.josm.gui.dialogs.relation.sort.RelationSortUtils;
import org.openstreetmap.josm.gui.dialogs.relation.sort.WayConnectionType;

public class WayConnectionTypeCalculator {
    private static final int UNCONNECTED = Integer.MIN_VALUE;
    private List<RelationMember> members;
    private int firstGroupIdx;
    private int lastForwardWay;
    private int lastBackwardWay;
    private boolean onewayBeginning;

    public List<WayConnectionType> updateLinks(List<RelationMember> list) {
        this.members = list;
        ArrayList<WayConnectionType> arrayList = new ArrayList<WayConnectionType>();
        for (int i = 0; i < list.size(); ++i) {
            arrayList.add(null);
        }
        this.firstGroupIdx = 0;
        this.lastForwardWay = Integer.MIN_VALUE;
        this.lastBackwardWay = Integer.MIN_VALUE;
        this.onewayBeginning = false;
        WayConnectionType wayConnectionType = null;
        for (int i = 0; i < list.size(); ++i) {
            RelationMember relationMember = list.get(i);
            if (!relationMember.isWay() || relationMember.getWay() == null || relationMember.getWay().isIncomplete()) {
                if (i > 0) {
                    this.makeLoopIfNeeded(arrayList, i - 1);
                }
                arrayList.set(i, new WayConnectionType());
                this.firstGroupIdx = i;
                continue;
            }
            WayConnectionType wayConnectionType2 = new WayConnectionType(false);
            wayConnectionType2.linkPrev = i > 0 && arrayList.get(i - 1) != null && ((WayConnectionType)arrayList.get(i - 1)).isValid();
            wayConnectionType2.direction = WayConnectionType.Direction.NONE;
            if (RelationSortUtils.isOneway(relationMember)) {
                if (wayConnectionType != null && wayConnectionType.isOnewayTail) {
                    wayConnectionType2.isOnewayHead = true;
                }
                if (this.lastBackwardWay == Integer.MIN_VALUE && this.lastForwardWay == Integer.MIN_VALUE) {
                    wayConnectionType2.isOnewayHead = true;
                    this.lastForwardWay = i - 1;
                    this.lastBackwardWay = i - 1;
                    this.onewayBeginning = true;
                }
            }
            if (wayConnectionType2.linkPrev) {
                if (this.lastBackwardWay != Integer.MIN_VALUE && this.lastForwardWay != Integer.MIN_VALUE) {
                    this.determineOnewayConnectionType(arrayList, relationMember, i, wayConnectionType2);
                    if (!wayConnectionType2.linkPrev) {
                        this.firstGroupIdx = i;
                    }
                }
                if (!RelationSortUtils.isOneway(relationMember) && wayConnectionType != null) {
                    wayConnectionType2.direction = this.determineDirection(i - 1, wayConnectionType.direction, i);
                    boolean bl = wayConnectionType2.linkPrev = wayConnectionType2.direction != WayConnectionType.Direction.NONE;
                }
            }
            if (!wayConnectionType2.linkPrev) {
                wayConnectionType2.direction = this.determineDirectionOfFirst(i, relationMember);
                if (RelationSortUtils.isOneway(relationMember)) {
                    wayConnectionType2.isOnewayLoopForwardPart = true;
                    this.lastForwardWay = i;
                }
            }
            wayConnectionType2.linkNext = false;
            if (wayConnectionType != null) {
                wayConnectionType.linkNext = wayConnectionType2.linkPrev;
            }
            arrayList.set(i, wayConnectionType2);
            wayConnectionType = wayConnectionType2;
            if (wayConnectionType2.linkPrev) continue;
            if (i > 0) {
                this.makeLoopIfNeeded(arrayList, i - 1);
            }
            this.firstGroupIdx = i;
        }
        this.makeLoopIfNeeded(arrayList, list.size() - 1);
        return arrayList;
    }

    private void makeLoopIfNeeded(List<WayConnectionType> list, int n) {
        boolean bl;
        if (n == this.firstGroupIdx) {
            bl = this.determineDirection(n, WayConnectionType.Direction.FORWARD, n) == WayConnectionType.Direction.FORWARD;
        } else {
            boolean bl2 = bl = this.determineDirection(n, list.get((int)n).direction, this.firstGroupIdx) == list.get((int)this.firstGroupIdx).direction;
        }
        if (bl) {
            for (int i = this.firstGroupIdx; i <= n; ++i) {
                list.get((int)i).isLoop = true;
            }
        }
    }

    private WayConnectionType.Direction determineDirectionOfFirst(int n, RelationMember relationMember) {
        WayConnectionType.Direction direction = RelationSortUtils.roundaboutType(relationMember);
        if (direction != WayConnectionType.Direction.NONE) {
            return direction;
        }
        if (RelationSortUtils.isOneway(relationMember)) {
            if (RelationSortUtils.isBackward(relationMember)) {
                return WayConnectionType.Direction.BACKWARD;
            }
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.FORWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.FORWARD;
        }
        if (this.determineDirection(n, WayConnectionType.Direction.BACKWARD, n + 1) != WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }

    private void determineOnewayConnectionType(List<WayConnectionType> list, RelationMember relationMember, int n, WayConnectionType wayConnectionType) {
        WayConnectionType.Direction direction = this.determineDirection(this.lastForwardWay, list.get((int)this.lastForwardWay).direction, n);
        WayConnectionType.Direction direction2 = WayConnectionType.Direction.NONE;
        if (this.onewayBeginning) {
            direction2 = this.lastBackwardWay < 0 ? this.determineDirection(this.firstGroupIdx, WayConnectionTypeCalculator.reverse(list.get((int)this.firstGroupIdx).direction), n, true) : this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
            if (direction2 != WayConnectionType.Direction.NONE) {
                this.onewayBeginning = false;
            }
        } else {
            direction2 = this.determineDirection(this.lastBackwardWay, list.get((int)this.lastBackwardWay).direction, n, true);
        }
        if (RelationSortUtils.isOneway(relationMember)) {
            if (direction2 != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction2;
                this.lastBackwardWay = n;
                wayConnectionType.isOnewayLoopBackwardPart = true;
            }
            if (direction != WayConnectionType.Direction.NONE) {
                wayConnectionType.direction = direction;
                this.lastForwardWay = n;
                wayConnectionType.isOnewayLoopForwardPart = true;
            }
            if (direction == WayConnectionType.Direction.NONE && direction2 == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
                if (RelationSortUtils.isOneway(relationMember)) {
                    wayConnectionType.isOnewayHead = true;
                    this.lastForwardWay = n - 1;
                    this.lastBackwardWay = n - 1;
                } else {
                    this.lastForwardWay = Integer.MIN_VALUE;
                    this.lastBackwardWay = Integer.MIN_VALUE;
                }
                this.onewayBeginning = true;
            }
            if (direction != WayConnectionType.Direction.NONE && direction2 != WayConnectionType.Direction.NONE) {
                if (n + 1 < this.members.size() && this.determineDirection(n, direction, n + 1) != WayConnectionType.Direction.NONE) {
                    wayConnectionType.isOnewayLoopBackwardPart = false;
                    wayConnectionType.direction = direction;
                } else {
                    wayConnectionType.isOnewayLoopForwardPart = false;
                    wayConnectionType.direction = direction2;
                }
                wayConnectionType.isOnewayTail = true;
            }
        } else {
            this.lastForwardWay = Integer.MIN_VALUE;
            this.lastBackwardWay = Integer.MIN_VALUE;
            if (direction == WayConnectionType.Direction.NONE || direction2 == WayConnectionType.Direction.NONE) {
                wayConnectionType.linkPrev = false;
            }
        }
    }

    private static WayConnectionType.Direction reverse(WayConnectionType.Direction direction) {
        if (direction == WayConnectionType.Direction.FORWARD) {
            return WayConnectionType.Direction.BACKWARD;
        }
        if (direction == WayConnectionType.Direction.BACKWARD) {
            return WayConnectionType.Direction.FORWARD;
        }
        return direction;
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2) {
        return this.determineDirection(n, direction, n2, false);
    }

    private WayConnectionType.Direction determineDirection(int n, WayConnectionType.Direction direction, int n2, boolean bl) {
        if (this.members == null || n < 0 || n2 < 0 || n >= this.members.size() || n2 >= this.members.size() || direction == WayConnectionType.Direction.NONE) {
            return WayConnectionType.Direction.NONE;
        }
        RelationMember relationMember = this.members.get(n);
        RelationMember relationMember2 = this.members.get(n2);
        Way way = null;
        Way way2 = null;
        if (relationMember.isWay()) {
            way = relationMember.getWay();
        }
        if (relationMember2.isWay()) {
            way2 = relationMember2.getWay();
        }
        if (way == null || way2 == null) {
            return WayConnectionType.Direction.NONE;
        }
        List<Node> list = new ArrayList<Node>();
        switch (direction) {
            case FORWARD: {
                list.add(way.lastNode());
                break;
            }
            case BACKWARD: {
                list.add(way.firstNode());
                break;
            }
            case ROUNDABOUT_LEFT: 
            case ROUNDABOUT_RIGHT: {
                list = way.getNodes();
                break;
            }
        }
        for (Node node : list) {
            if (node == null) continue;
            if (RelationSortUtils.roundaboutType(this.members.get(n2)) != WayConnectionType.Direction.NONE) {
                for (Node node2 : way2.getNodes()) {
                    if (node != node2) continue;
                    return RelationSortUtils.roundaboutType(this.members.get(n2));
                }
                continue;
            }
            if (RelationSortUtils.isOneway(relationMember2)) {
                if (node == RelationNodeMap.firstOnewayNode(relationMember2) && !bl) {
                    if (RelationSortUtils.isBackward(relationMember2)) {
                        return WayConnectionType.Direction.BACKWARD;
                    }
                    return WayConnectionType.Direction.FORWARD;
                }
                if (node != RelationNodeMap.lastOnewayNode(relationMember2) || !bl) continue;
                if (RelationSortUtils.isBackward(relationMember2)) {
                    return WayConnectionType.Direction.FORWARD;
                }
                return WayConnectionType.Direction.BACKWARD;
            }
            if (node == way2.firstNode()) {
                return WayConnectionType.Direction.FORWARD;
            }
            if (node != way2.lastNode()) continue;
            return WayConnectionType.Direction.BACKWARD;
        }
        return WayConnectionType.Direction.NONE;
    }
}

