/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.geoimage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import javax.swing.AbstractAction;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.MutableComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.GpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.geoimage.GeoImageLayer;
import org.openstreetmap.josm.gui.layer.geoimage.ImageDisplay;
import org.openstreetmap.josm.gui.layer.geoimage.ImageEntry;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.JosmComboBox;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.JpgImporter;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.date.DateUtils;
import org.xml.sax.SAXException;

public class CorrelateGpxWithImages
extends AbstractAction {
    private static List<GpxData> loadedGpxData = new ArrayList<GpxData>();
    private final transient GeoImageLayer yLayer;
    private transient Timezone timezone;
    private transient Offset delta;
    private ExtendedDialog syncDialog;
    private final transient List<GpxDataWrapper> gpxLst = new ArrayList<GpxDataWrapper>();
    private JPanel outerPanel;
    private JosmComboBox<GpxDataWrapper> cbGpx;
    private JosmTextField tfTimezone;
    private JosmTextField tfOffset;
    private JCheckBox cbExifImg;
    private JCheckBox cbTaggedImg;
    private JCheckBox cbShowThumbs;
    private JLabel statusBarText;
    private int lastNumMatched;
    private final transient StatusBarUpdater statusBarUpdater = new StatusBarUpdater(false);
    private final transient StatusBarUpdater statusBarUpdaterWithRepaint = new StatusBarUpdater(true);
    private final transient RepaintTheMapListener repaintTheMap = new RepaintTheMapListener();

    public CorrelateGpxWithImages(GeoImageLayer geoImageLayer) {
        super(I18n.tr("Correlate to GPX", new Object[0]), ImageProvider.get("dialogs/geoimage/gpx2img"));
        this.yLayer = geoImageLayer;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        Object object2;
        Collection<Layer> collection = Main.map.mapView.getAllLayers();
        GpxDataWrapper gpxDataWrapper = null;
        for (Layer object32 : collection) {
            if (!(object32 instanceof GpxLayer)) continue;
            object2 = (GpxLayer)object32;
            object = new GpxDataWrapper(((Layer)object2).getName(), ((GpxLayer)object2).data, ((GpxLayer)object2).data.storageFile);
            this.gpxLst.add((GpxDataWrapper)object);
            if (object32 != this.yLayer.gpxLayer) continue;
            gpxDataWrapper = object;
        }
        for (GpxData gpxData : loadedGpxData) {
            this.gpxLst.add(new GpxDataWrapper(gpxData.storageFile.getName(), gpxData, gpxData.storageFile));
        }
        if (this.gpxLst.isEmpty()) {
            this.gpxLst.add(new GpxDataWrapper(I18n.tr("<No GPX track loaded yet>", new Object[0]), null, null));
        }
        JPanel jPanel = new JPanel();
        jPanel.add(new JLabel(I18n.tr("GPX track: ", new Object[0])));
        this.cbGpx = new JosmComboBox<GpxDataWrapper>(this.gpxLst.toArray(new GpxDataWrapper[0]));
        if (gpxDataWrapper != null) {
            this.cbGpx.setSelectedItem(gpxDataWrapper);
        }
        this.cbGpx.addActionListener(this.statusBarUpdaterWithRepaint);
        jPanel.add(this.cbGpx);
        JButton jButton = new JButton(I18n.tr("Open another GPX trace", new Object[0]));
        jButton.addActionListener(new LoadGpxDataActionListener());
        jPanel.add(jButton);
        object2 = new JPanel(new GridBagLayout());
        object = Main.pref.get("geoimage.timezone", "0:00");
        if (object == null) {
            object = "0:00";
        }
        try {
            this.timezone = Timezone.parseTimezone((String)object);
        }
        catch (ParseException parseException) {
            this.timezone = Timezone.ZERO;
        }
        this.tfTimezone = new JosmTextField(10);
        this.tfTimezone.setText(this.timezone.formatTimezone());
        try {
            this.delta = Offset.parseOffset(Main.pref.get("geoimage.delta", "0"));
        }
        catch (ParseException parseException) {
            this.delta = Offset.ZERO;
        }
        this.tfOffset = new JosmTextField(10);
        this.tfOffset.setText(this.delta.formatOffset());
        JButton jButton2 = new JButton(I18n.tr("<html>Use photo of an accurate clock,<br>e.g. GPS receiver display</html>", new Object[0]));
        jButton2.setIcon(ImageProvider.get("clock"));
        jButton2.addActionListener(new SetOffsetActionListener());
        JButton jButton3 = new JButton(I18n.tr("Auto-Guess", new Object[0]));
        jButton3.setToolTipText(I18n.tr("Matches first photo with first gpx point", new Object[0]));
        jButton3.addActionListener(new AutoGuessActionListener());
        JButton jButton4 = new JButton(I18n.tr("Manual adjust", new Object[0]));
        jButton4.addActionListener(new AdjustActionListener());
        JLabel jLabel = new JLabel(I18n.tr("Override position for: ", new Object[0]));
        int n = this.getSortedImgList(true, true).size();
        int n2 = n - this.getSortedImgList(false, true).size();
        int n3 = n - this.getSortedImgList(true, false).size();
        this.cbExifImg = new JCheckBox(I18n.tr("Images with geo location in exif data ({0}/{1})", n2, n));
        this.cbExifImg.setEnabled(n2 != 0);
        this.cbTaggedImg = new JCheckBox(I18n.tr("Images that are already tagged ({0}/{1})", n3, n), true);
        this.cbTaggedImg.setEnabled(n3 != 0);
        jLabel.setEnabled(this.cbExifImg.isEnabled() || this.cbTaggedImg.isEnabled());
        boolean bl = this.yLayer.thumbsLoaded || Main.pref.getBoolean("geoimage.showThumbs", false);
        this.cbShowThumbs = new JCheckBox(I18n.tr("Show Thumbnail images on the map", new Object[0]), bl);
        this.cbShowThumbs.setEnabled(!this.yLayer.thumbsLoaded);
        int n4 = 0;
        GBC gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)jPanel, gBC);
        gBC = GBC.eol().fill(2).insets(0, 0, 0, 12);
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)new JSeparator(0), gBC);
        gBC = GBC.std();
        gBC.gridx = 0;
        gBC.gridy = n4;
        ((Container)object2).add((Component)new JLabel(I18n.tr("Timezone: ", new Object[0])), gBC);
        gBC = GBC.std().fill(2);
        gBC.gridx = 1;
        gBC.gridy = n4++;
        gBC.weightx = 1.0;
        ((Container)object2).add((Component)this.tfTimezone, gBC);
        gBC = GBC.std();
        gBC.gridx = 0;
        gBC.gridy = n4;
        ((Container)object2).add((Component)new JLabel(I18n.tr("Offset:", new Object[0])), gBC);
        gBC = GBC.std().fill(2);
        gBC.gridx = 1;
        gBC.gridy = n4++;
        gBC.weightx = 1.0;
        ((Container)object2).add((Component)this.tfOffset, gBC);
        gBC = GBC.std().insets(5, 5, 5, 5);
        gBC.gridx = 2;
        gBC.gridy = n4 - 2;
        gBC.gridheight = 2;
        gBC.gridwidth = 2;
        gBC.fill = 1;
        gBC.weightx = 0.5;
        ((Container)object2).add((Component)jButton2, gBC);
        gBC = GBC.std().fill(1).insets(5, 5, 5, 5);
        gBC.gridx = 2;
        gBC.gridy = n4++;
        gBC.weightx = 0.5;
        ((Container)object2).add((Component)jButton3, gBC);
        gBC.gridx = 3;
        ((Container)object2).add((Component)jButton4, gBC);
        gBC = GBC.eol().fill(2).insets(0, 12, 0, 0);
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)new JSeparator(0), gBC);
        gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)jLabel, gBC);
        gBC = GBC.eol();
        gBC.gridx = 1;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)this.cbExifImg, gBC);
        gBC = GBC.eol();
        gBC.gridx = 1;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)this.cbTaggedImg, gBC);
        gBC = GBC.eol();
        gBC.gridx = 0;
        gBC.gridy = n4++;
        ((Container)object2).add((Component)this.cbShowThumbs, gBC);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        jPanel2.setBorder(BorderFactory.createLoweredBevelBorder());
        this.statusBarText = new JLabel(" ");
        this.statusBarText.setFont(this.statusBarText.getFont().deriveFont(8));
        jPanel2.add(this.statusBarText);
        this.tfTimezone.addFocusListener(this.repaintTheMap);
        this.tfOffset.addFocusListener(this.repaintTheMap);
        this.tfTimezone.getDocument().addDocumentListener(this.statusBarUpdater);
        this.tfOffset.getDocument().addDocumentListener(this.statusBarUpdater);
        this.cbExifImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.cbTaggedImg.addItemListener(this.statusBarUpdaterWithRepaint);
        this.statusBarUpdater.updateStatusBar();
        this.outerPanel = new JPanel(new BorderLayout());
        this.outerPanel.add((Component)jPanel2, "Last");
        if (!GraphicsEnvironment.isHeadless()) {
            this.syncDialog = new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("Correlate", new Object[0]), I18n.tr("Cancel", new Object[0])}, false);
            this.syncDialog.setContent((Component)object2, false);
            this.syncDialog.setButtonIcons(new String[]{"ok", "cancel"});
            this.syncDialog.setupDialog();
            this.outerPanel.add((Component)this.syncDialog.getContentPane(), "First");
            this.syncDialog.setContentPane(this.outerPanel);
            this.syncDialog.pack();
            this.syncDialog.addWindowListener(new SyncDialogWindowListener());
            this.syncDialog.showDialog();
        }
    }

    static Pair<Timezone, Offset> autoGuess(List<ImageEntry> list, GpxData gpxData) throws IndexOutOfBoundsException, NoGpxTimestamps {
        long l = list.get(0).getExifTime().getTime();
        long l2 = -1L;
        block0: for (GpxTrack gpxTrack : gpxData.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                for (WayPoint wayPoint : gpxTrackSegment.getWayPoints()) {
                    Date date = wayPoint.setTimeFromAttribute();
                    if (date == null) continue;
                    l2 = date.getTime();
                    break block0;
                }
            }
        }
        if (l2 < 0L) {
            throw new NoGpxTimestamps();
        }
        return Offset.milliseconds(l - l2).splitOutTimezone();
    }

    private List<ImageEntry> getSortedImgList() {
        return this.getSortedImgList(this.cbExifImg.isSelected(), this.cbTaggedImg.isSelected());
    }

    private List<ImageEntry> getSortedImgList(boolean bl, boolean bl2) {
        if (this.yLayer.data == null) {
            return Collections.emptyList();
        }
        ArrayList<ImageEntry> arrayList = new ArrayList<ImageEntry>(this.yLayer.data.size());
        for (ImageEntry imageEntry : this.yLayer.data) {
            if (!imageEntry.hasExifTime() || imageEntry.getExifCoor() != null && !bl || imageEntry.isTagged() && imageEntry.getExifCoor() == null && !bl2) continue;
            arrayList.add(imageEntry);
        }
        Collections.sort(arrayList, new Comparator<ImageEntry>(){

            @Override
            public int compare(ImageEntry imageEntry, ImageEntry imageEntry2) {
                return imageEntry.getExifTime().compareTo(imageEntry2.getExifTime());
            }
        });
        return arrayList;
    }

    private GpxDataWrapper selectedGPX(boolean bl) {
        Object object = this.cbGpx.getSelectedItem();
        if (object == null || ((GpxDataWrapper)object).file == null) {
            if (bl) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("You should select a GPX track", new Object[0]), I18n.tr("No selected GPX track", new Object[0]), 0);
            }
            return null;
        }
        return (GpxDataWrapper)object;
    }

    static int matchGpxTrack(List<ImageEntry> list, GpxData gpxData, long l) {
        int n = 0;
        for (GpxTrack gpxTrack : gpxData.tracks) {
            for (GpxTrackSegment gpxTrackSegment : gpxTrack.getSegments()) {
                long l2 = 0L;
                WayPoint wayPoint = null;
                for (WayPoint wayPoint2 : gpxTrackSegment.getWayPoints()) {
                    Date date = wayPoint2.setTimeFromAttribute();
                    if (date != null) {
                        long l3 = date.getTime() + l;
                        n += CorrelateGpxWithImages.matchPoints(list, wayPoint, l2, wayPoint2, l3, l);
                        wayPoint = wayPoint2;
                        l2 = l3;
                        continue;
                    }
                    wayPoint = null;
                    l2 = 0L;
                }
            }
        }
        return n;
    }

    private static Double getElevation(WayPoint wayPoint) {
        String string = wayPoint.getString("ele");
        if (string != null && !string.isEmpty()) {
            try {
                return Double.valueOf(string);
            }
            catch (NumberFormatException numberFormatException) {
                Main.warn(numberFormatException);
            }
        }
        return null;
    }

    static int matchPoints(List<ImageEntry> list, WayPoint wayPoint, long l, WayPoint wayPoint2, long l2, long l3) {
        ImageEntry imageEntry;
        long l4;
        long l5 = l > 0L ? Math.abs(l2 - l) : 5000L;
        int n = 0;
        int n2 = CorrelateGpxWithImages.getLastIndexOfListBefore(list, l2);
        if (n2 < 0) {
            return 0;
        }
        Double d = null;
        Double d2 = null;
        if (wayPoint != null) {
            double d3 = wayPoint.getCoor().greatCircleDistance(wayPoint2.getCoor());
            if (l2 > l) {
                d = 3600.0 * d3 / (double)(l2 - l);
            }
            d2 = CorrelateGpxWithImages.getElevation(wayPoint);
        }
        Double d4 = CorrelateGpxWithImages.getElevation(wayPoint2);
        if (l == 0L || l2 <= l) {
            ImageEntry imageEntry2;
            long l6;
            while (n2 >= 0 && (l6 = (imageEntry2 = list.get(n2)).getExifTime().getTime()) <= l2 && l6 >= l2 - l5) {
                if (imageEntry2.tmp.getPos() == null) {
                    imageEntry2.tmp.setPos(wayPoint2.getCoor());
                    imageEntry2.tmp.setSpeed(d);
                    imageEntry2.tmp.setElevation(d4);
                    imageEntry2.tmp.setGpsTime(new Date(imageEntry2.getExifTime().getTime() - l3));
                    imageEntry2.flagNewGpsData();
                    ++n;
                }
                --n2;
            }
            return n;
        }
        while (n2 >= 0 && (l4 = (imageEntry = list.get(n2)).getExifTime().getTime()) >= l) {
            if (imageEntry.tmp.getPos() == null && wayPoint != null) {
                double d5 = (double)(l4 - l) / (double)l5;
                imageEntry.tmp.setPos(wayPoint.getCoor().interpolate(wayPoint2.getCoor(), d5));
                imageEntry.tmp.setSpeed(d);
                if (d4 != null && d2 != null) {
                    imageEntry.tmp.setElevation(d2 + (d4 - d2) * d5);
                }
                imageEntry.tmp.setGpsTime(new Date(imageEntry.getExifTime().getTime() - l3));
                imageEntry.flagNewGpsData();
                ++n;
            }
            --n2;
        }
        return n;
    }

    private static int getLastIndexOfListBefore(List<ImageEntry> list, long l) {
        int n = list.size();
        if (n == 0 || l < list.get(0).getExifTime().getTime()) {
            return -1;
        }
        if (l > list.get(n - 1).getExifTime().getTime()) {
            return n - 1;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = n - 1;
        while (n4 - n3 > 1) {
            n2 = (n4 + n3) / 2;
            if (l > list.get(n2).getExifTime().getTime()) {
                n3 = n2;
                continue;
            }
            n4 = n2;
        }
        if (l < list.get(n4).getExifTime().getTime()) {
            return n3;
        }
        while (n4 < n - 1 && list.get(n4).getExifTime().getTime() == list.get(n4 + 1).getExifTime().getTime()) {
            ++n4;
        }
        return n4;
    }

    static final class Offset {
        static final Offset ZERO = new Offset(0L);
        private final long milliseconds;

        private Offset(long l) {
            this.milliseconds = l;
        }

        static Offset milliseconds(long l) {
            return new Offset(l);
        }

        static Offset seconds(long l) {
            return new Offset(1000L * l);
        }

        long getMilliseconds() {
            return this.milliseconds;
        }

        long getSeconds() {
            return this.milliseconds / 1000L;
        }

        String formatOffset() {
            if (this.milliseconds % 1000L == 0L) {
                return Long.toString(this.milliseconds / 1000L);
            }
            if (this.milliseconds % 100L == 0L) {
                return String.format(Locale.ENGLISH, "%.1f", (double)this.milliseconds / 1000.0);
            }
            return String.format(Locale.ENGLISH, "%.3f", (double)this.milliseconds / 1000.0);
        }

        static Offset parseOffset(String string) throws ParseException {
            String string2 = I18n.tr("Error while parsing offset.\nExpected format: {0}", "number");
            if (!string.isEmpty()) {
                try {
                    if (string.startsWith("+")) {
                        string = string.substring(1);
                    }
                    return Offset.milliseconds(Math.round(Double.parseDouble(string) * 1000.0));
                }
                catch (NumberFormatException numberFormatException) {
                    throw (ParseException)new ParseException(string2, 0).initCause(numberFormatException);
                }
            }
            return ZERO;
        }

        int getDayOffset() {
            double d = (double)this.getMilliseconds() / 1000.0 / 60.0 / 60.0;
            return (int)Math.round(d / 24.0);
        }

        Offset withoutDayOffset() {
            return Offset.milliseconds(this.getMilliseconds() - (long)this.getDayOffset() * 24L * 60L * 60L * 1000L);
        }

        Pair<Timezone, Offset> splitOutTimezone() {
            double d = (double)this.withoutDayOffset().getSeconds() / 3600.0;
            double d2 = (double)Math.round(d * 2.0) / 2.0;
            long l = Math.round((double)this.getMilliseconds() - d2 * 60.0 * 60.0 * 1000.0);
            return Pair.create(new Timezone(d2), Offset.milliseconds(l));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Offset)) {
                return false;
            }
            Offset offset = (Offset)object;
            return this.milliseconds == offset.milliseconds;
        }

        public int hashCode() {
            return Objects.hash(this.milliseconds);
        }
    }

    static final class Timezone {
        static final Timezone ZERO = new Timezone(0.0);
        private final double timezone;

        Timezone(double d) {
            this.timezone = d;
        }

        public double getHours() {
            return this.timezone;
        }

        String formatTimezone() {
            StringBuilder stringBuilder = new StringBuilder();
            double d = this.timezone;
            if (d < 0.0) {
                stringBuilder.append('-');
                d = -d;
            } else {
                stringBuilder.append('+');
            }
            stringBuilder.append((long)d).append(':');
            int n = (int)(d % 1.0 * 60.0);
            if (n < 10) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        static Timezone parseTimezone(String string) throws ParseException {
            int n;
            int n2;
            if (string.isEmpty()) {
                return ZERO;
            }
            String string2 = I18n.tr("Error while parsing timezone.\nExpected format: {0}", "+H:MM");
            int n3 = 43;
            StringBuilder stringBuilder = new StringBuilder();
            StringBuilder stringBuilder2 = new StringBuilder();
            int n4 = 1;
            block12: for (n2 = 0; n2 < string.length(); ++n2) {
                n = string.charAt(n2);
                switch (n) {
                    case 32: {
                        if (n4 == 2 && stringBuilder.length() == 0) continue block12;
                        throw new ParseException(string2, n2);
                    }
                    case 43: 
                    case 45: {
                        if (n4 == 1) {
                            n3 = n;
                            n4 = 2;
                            continue block12;
                        }
                        throw new ParseException(string2, n2);
                    }
                    case 46: 
                    case 58: {
                        if (n4 == 2) {
                            n4 = 3;
                            continue block12;
                        }
                        throw new ParseException(string2, n2);
                    }
                    case 48: 
                    case 49: 
                    case 50: 
                    case 51: 
                    case 52: 
                    case 53: 
                    case 54: 
                    case 55: 
                    case 56: 
                    case 57: {
                        switch (n4) {
                            case 1: 
                            case 2: {
                                n4 = 2;
                                stringBuilder.append((char)n);
                                continue block12;
                            }
                            case 3: {
                                stringBuilder2.append((char)n);
                                continue block12;
                            }
                        }
                        throw new ParseException(string2, n2);
                    }
                    default: {
                        throw new ParseException(string2, n2);
                    }
                }
            }
            n2 = 0;
            n = 0;
            try {
                n2 = Integer.parseInt(stringBuilder.toString());
                if (stringBuilder2.length() > 0) {
                    n = Integer.parseInt(stringBuilder2.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                throw (ParseException)new ParseException(string2, 0).initCause(numberFormatException);
            }
            if (n2 > 12 || n > 59) {
                throw new ParseException(string2, 0);
            }
            return new Timezone(((double)n2 + (double)n / 60.0) * (double)(n3 == 45 ? -1 : 1));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Timezone)) {
                return false;
            }
            Timezone timezone = (Timezone)object;
            return Double.compare(timezone.timezone, this.timezone) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.timezone);
        }
    }

    private class AutoGuessActionListener
    implements ActionListener {
        private AutoGuessActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(true);
            if (gpxDataWrapper == null) {
                return;
            }
            GpxData gpxData = gpxDataWrapper.data;
            List list = CorrelateGpxWithImages.this.getSortedImgList();
            try {
                Pair<Timezone, Offset> pair = CorrelateGpxWithImages.autoGuess(list, gpxData);
                CorrelateGpxWithImages.this.timezone = (Timezone)pair.a;
                CorrelateGpxWithImages.this.delta = (Offset)pair.b;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected photos do not contain time information.", new Object[0]), I18n.tr("Photos do not contain time information", new Object[0]), 2);
                return;
            }
            catch (NoGpxTimestamps noGpxTimestamps) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("The selected GPX track does not contain timestamps. Please select another one.", new Object[0]), I18n.tr("GPX Track has no time information", new Object[0]), 2);
                return;
            }
            CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
            CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
            CorrelateGpxWithImages.this.tfOffset.requestFocus();
            CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    static class NoGpxTimestamps
    extends Exception {
        NoGpxTimestamps() {
        }
    }

    private class AdjustActionListener
    implements ActionListener {
        private AdjustActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Offset offset = Offset.milliseconds(CorrelateGpxWithImages.this.delta.getMilliseconds() + Math.round(CorrelateGpxWithImages.this.timezone.getHours() * 60.0 * 60.0 * 1000.0));
            final int n = offset.getDayOffset();
            Pair<Timezone, Offset> pair = offset.withoutDayOffset().splitOutTimezone();
            final JLabel jLabel = new JLabel();
            final JLabel jLabel2 = new JLabel();
            final JSlider jSlider = new JSlider(-24, 24, 0);
            jSlider.setPaintLabels(true);
            Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
            for (int i = -12; i <= 12; i += 6) {
                ((Dictionary)hashtable).put(i * 2, new JLabel(new Timezone(i).formatTimezone()));
            }
            jSlider.setLabelTable(hashtable);
            final JLabel jLabel3 = new JLabel();
            final JSlider jSlider2 = new JSlider(-15, 15, 0);
            jSlider2.setPaintLabels(true);
            jSlider2.setMajorTickSpacing(5);
            final JLabel jLabel4 = new JLabel();
            final JSlider jSlider3 = new JSlider(-600, 600, 0);
            jSlider3.setPaintLabels(true);
            hashtable = new Hashtable();
            for (int i = -60; i <= 60; i += 30) {
                ((Dictionary)hashtable).put(i * 10, new JLabel(Offset.seconds(i).formatOffset()));
            }
            jSlider3.setLabelTable(hashtable);
            jSlider3.setMajorTickSpacing(300);
            JPanel jPanel = new JPanel(new GridBagLayout());
            jPanel.setPreferredSize(new Dimension(400, 230));
            jPanel.add((Component)jLabel, GBC.eol().fill());
            jPanel.add((Component)jLabel2, GBC.eol().fill());
            jPanel.add((Component)jSlider, GBC.eol().fill().insets(0, 0, 0, 10));
            jPanel.add((Component)jLabel3, GBC.eol().fill());
            jPanel.add((Component)jSlider2, GBC.eol().fill().insets(0, 0, 0, 10));
            jPanel.add((Component)jLabel4, GBC.eol().fill());
            jPanel.add((Component)jSlider3, GBC.eol().fill());
            try {
                jSlider.setValue((int)(((Timezone)pair.a).getHours() * 2.0));
                jSlider2.setValue((int)(((Offset)pair.b).getSeconds() / 60L));
                long l = ((Offset)pair.b).getMilliseconds() / 100L;
                jSlider3.setValue((int)(l % 60L));
            }
            catch (RuntimeException runtimeException) {
                JOptionPane.showMessageDialog(Main.parent, I18n.tr("An error occurred while trying to match the photos to the GPX track. You can adjust the sliders to manually match the photos.", new Object[0]), I18n.tr("Matching photos to track failed", new Object[0]), 2);
            }
            class SliderListener
            implements ChangeListener {
                SliderListener() {
                }

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    CorrelateGpxWithImages.this.timezone = new Timezone((double)jSlider.getValue() / 2.0);
                    jLabel2.setText(I18n.tr("Timezone: {0}", CorrelateGpxWithImages.this.timezone.formatTimezone()));
                    jLabel3.setText(I18n.tr("Minutes: {0}", jSlider2.getValue()));
                    jLabel4.setText(I18n.tr("Seconds: {0}", Offset.milliseconds(100L * (long)jSlider3.getValue()).formatOffset()));
                    CorrelateGpxWithImages.this.delta = Offset.milliseconds(100L * (long)jSlider3.getValue() + 60000L * (long)jSlider2.getValue() + 86400000L * (long)n);
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().removeDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfTimezone.setText(CorrelateGpxWithImages.this.timezone.formatTimezone());
                    CorrelateGpxWithImages.this.tfOffset.setText(CorrelateGpxWithImages.this.delta.formatOffset());
                    CorrelateGpxWithImages.this.tfTimezone.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    CorrelateGpxWithImages.this.tfOffset.getDocument().addDocumentListener(CorrelateGpxWithImages.this.statusBarUpdater);
                    jLabel.setText(CorrelateGpxWithImages.this.statusBarText.getText() + "<br>" + I18n.trn("(Time difference of {0} day)", "Time difference of {0} days", Math.abs(n), Math.abs(n)));
                    CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                }
            }
            new SliderListener().stateChanged(null);
            jSlider.addChangeListener(new SliderListener());
            jSlider2.addChangeListener(new SliderListener());
            jSlider3.addChangeListener(new SliderListener());
            new ExtendedDialog(Main.parent, I18n.tr("Adjust timezone and offset", new Object[0]), new String[]{I18n.tr("Close", new Object[0])}).setContent(jPanel).setButtonIcons(new String[]{"ok"}).showDialog();
        }
    }

    private class RepaintTheMapListener
    implements FocusListener {
        private RepaintTheMapListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class StatusBarUpdater
    implements DocumentListener,
    ItemListener,
    ActionListener {
        private final boolean doRepaint;

        StatusBarUpdater(boolean bl) {
            this.doRepaint = bl;
        }

        @Override
        public void insertUpdate(DocumentEvent documentEvent) {
            this.updateStatusBar();
        }

        @Override
        public void removeUpdate(DocumentEvent documentEvent) {
            this.updateStatusBar();
        }

        @Override
        public void changedUpdate(DocumentEvent documentEvent) {
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.updateStatusBar();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            this.updateStatusBar();
        }

        public void updateStatusBar() {
            CorrelateGpxWithImages.this.statusBarText.setText(this.statusText());
            if (this.doRepaint) {
                CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
            }
        }

        private String statusText() {
            try {
                CorrelateGpxWithImages.this.timezone = Timezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
                CorrelateGpxWithImages.this.delta = Offset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException parseException) {
                return parseException.getMessage();
            }
            if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                for (ImageEntry object2 : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                    object2.discardTmp();
                }
            }
            List list = CorrelateGpxWithImages.this.getSortedImgList();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ImageEntry imageEntry = (ImageEntry)iterator.next();
                imageEntry.createTmp();
                imageEntry.tmp.setPos(null);
            }
            GpxDataWrapper gpxDataWrapper = CorrelateGpxWithImages.this.selectedGPX(false);
            if (gpxDataWrapper == null) {
                return I18n.tr("No gpx selected", new Object[0]);
            }
            long l = (long)(CorrelateGpxWithImages.this.timezone.getHours() * 3600.0 * 1000.0) + CorrelateGpxWithImages.this.delta.getMilliseconds();
            CorrelateGpxWithImages.this.lastNumMatched = CorrelateGpxWithImages.matchGpxTrack(list, gpxDataWrapper.data, l);
            return I18n.trn("<html>Matched <b>{0}</b> of <b>{1}</b> photo to GPX track.</html>", "<html>Matched <b>{0}</b> of <b>{1}</b> photos to GPX track.</html>", list.size(), CorrelateGpxWithImages.this.lastNumMatched, list.size());
        }
    }

    private class SetOffsetActionListener
    implements ActionListener {
        private JPanel panel;
        private JLabel lbExifTime;
        private JosmTextField tfGpsTime;
        private JosmComboBox<String> cbTimezones;
        private ImageDisplay imgDisp;
        private JList<String> imgList;

        private SetOffsetActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateUtils.getDateTimeFormat(3, 2);
            this.panel = new JPanel(new BorderLayout());
            this.panel.add((Component)new JLabel(I18n.tr("<html>Take a photo of your GPS receiver while it displays the time.<br>Display that photo here.<br>And then, simply capture the time you read on the photo and select a timezone<hr></html>", new Object[0])), "North");
            this.imgDisp = new ImageDisplay();
            this.imgDisp.setPreferredSize(new Dimension(300, 225));
            this.panel.add((Component)this.imgDisp, "Center");
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("Photo time (from exif):", new Object[0])), gridBagConstraints);
            this.lbExifTime = new JLabel();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = 2;
            jPanel.add((Component)this.lbExifTime, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("Gps time (read from the above photo): ", new Object[0])), gridBagConstraints);
            this.tfGpsTime = new JosmTextField(12);
            this.tfGpsTime.setEnabled(false);
            this.tfGpsTime.setMinimumSize(new Dimension(155, this.tfGpsTime.getMinimumSize().height));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.tfGpsTime, gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 0.2;
            jPanel.add((Component)new JLabel(" [" + simpleDateFormat.toLocalizedPattern() + ']'), gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)new JLabel(I18n.tr("I am in the timezone of: ", new Object[0])), gridBagConstraints);
            String[] stringArray = TimeZone.getAvailableIDs();
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            for (String object2 : stringArray) {
                TimeZone bl = TimeZone.getTimeZone(object2);
                String n = object2 + " (" + new Timezone((double)bl.getRawOffset() / 3600000.0).formatTimezone() + ')';
                arrayList.add(n);
            }
            Collections.sort(arrayList);
            this.cbTimezones = new JosmComboBox<String>(arrayList.toArray(new String[0]));
            Object object3 = Main.pref.get("geoimage.timezoneid", "");
            TimeZone timeZone = ((String)object3).isEmpty() ? TimeZone.getDefault() : TimeZone.getTimeZone((String)object3);
            this.cbTimezones.setSelectedItem(timeZone.getID() + " (" + new Timezone((double)timeZone.getRawOffset() / 3600000.0).formatTimezone() + ')');
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            jPanel.add(this.cbTimezones, gridBagConstraints);
            this.panel.add((Component)jPanel, "South");
            JPanel jPanel2 = new JPanel(new BorderLayout());
            this.imgList = new JList<String>(new AbstractListModel<String>(){

                @Override
                public String getElementAt(int n) {
                    return ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(n).getFile().getName();
                }

                @Override
                public int getSize() {
                    return ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null ? ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.size() : 0;
                }
            });
            this.imgList.getSelectionModel().setSelectionMode(0);
            this.imgList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent listSelectionEvent) {
                    int n = SetOffsetActionListener.this.imgList.getSelectedIndex();
                    Integer n2 = ExifReader.readOrientation(((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(n).getFile());
                    SetOffsetActionListener.this.imgDisp.setImage(((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(n).getFile(), n2);
                    Date date = ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data.get(n).getExifTime();
                    if (date != null) {
                        DateFormat dateFormat = DateUtils.getDateTimeFormat(3, 2);
                        SetOffsetActionListener.this.lbExifTime.setText(dateFormat.format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(dateFormat.format(date));
                        SetOffsetActionListener.this.tfGpsTime.setCaretPosition(SetOffsetActionListener.this.tfGpsTime.getText().length());
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                        SetOffsetActionListener.this.tfGpsTime.requestFocus();
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)new JScrollPane(this.imgList), "Center");
            JButton jButton = new JButton(I18n.tr("Open another photo", new Object[0]));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractFileChooser abstractFileChooser = DiskAccessAction.createAndOpenFileChooser(true, false, null, JpgImporter.FILE_FILTER_WITH_FOLDERS, 0, "geoimage.lastdirectory");
                    if (abstractFileChooser == null) {
                        return;
                    }
                    File file = abstractFileChooser.getSelectedFile();
                    Integer n = ExifReader.readOrientation(file);
                    SetOffsetActionListener.this.imgDisp.setImage(file, n);
                    Date date = ExifReader.readTime(file);
                    if (date != null) {
                        SetOffsetActionListener.this.lbExifTime.setText(DateUtils.getDateTimeFormat(3, 2).format(date));
                        SetOffsetActionListener.this.tfGpsTime.setText(DateUtils.getDateFormat(3).format(date) + ' ');
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(true);
                    } else {
                        SetOffsetActionListener.this.lbExifTime.setText(I18n.tr("No date", new Object[0]));
                        SetOffsetActionListener.this.tfGpsTime.setText("");
                        SetOffsetActionListener.this.tfGpsTime.setEnabled(false);
                    }
                }
            });
            jPanel2.add((Component)jButton, "Last");
            this.panel.add((Component)jPanel2, "Before");
            boolean bl = false;
            while (!bl) {
                long l;
                int n = JOptionPane.showConfirmDialog(Main.parent, this.panel, I18n.tr("Synchronize time from a photo of the GPS receiver", new Object[0]), 2, 3);
                if (n == 2) {
                    return;
                }
                try {
                    l = simpleDateFormat.parse(this.lbExifTime.getText()).getTime() - simpleDateFormat.parse(this.tfGpsTime.getText()).getTime();
                }
                catch (ParseException parseException) {
                    JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing the date.\nPlease use the requested format", new Object[0]), I18n.tr("Invalid date", new Object[0]), 0);
                    continue;
                }
                String parseException = (String)this.cbTimezones.getSelectedItem();
                int n2 = parseException.lastIndexOf(40);
                object3 = parseException.substring(0, n2 - 1);
                String string = parseException.substring(n2 + 1, parseException.length() - 1);
                Main.pref.put("geoimage.timezoneid", (String)object3);
                CorrelateGpxWithImages.this.tfOffset.setText(Offset.milliseconds(l).formatOffset());
                CorrelateGpxWithImages.this.tfTimezone.setText(string);
                bl = true;
            }
            CorrelateGpxWithImages.this.statusBarUpdater.updateStatusBar();
            CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
        }
    }

    private class LoadGpxDataActionListener
    implements ActionListener {
        private LoadGpxDataActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            block26: {
                FileFilter fileFilter = new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory() || Utils.hasExtension(file, "gpx", "gpx.gz");
                    }

                    @Override
                    public String getDescription() {
                        return I18n.tr("GPX Files (*.gpx *.gpx.gz)", new Object[0]);
                    }
                };
                AbstractFileChooser abstractFileChooser = DiskAccessAction.createAndOpenFileChooser(true, false, null, fileFilter, 0, null);
                if (abstractFileChooser == null) {
                    return;
                }
                File file = abstractFileChooser.getSelectedFile();
                try {
                    Object object;
                    Object object2;
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getPredefinedCursor(3));
                    for (int i = CorrelateGpxWithImages.this.gpxLst.size() - 1; i >= 0; --i) {
                        object2 = (GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(i);
                        if (((GpxDataWrapper)object2).file == null || !file.equals(((GpxDataWrapper)object2).file)) continue;
                        CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(i);
                        if (!file.getName().equals(((GpxDataWrapper)object2).name)) {
                            JOptionPane.showMessageDialog(Main.parent, I18n.tr("File {0} is loaded yet under the name \"{1}\"", file.getName(), ((GpxDataWrapper)object2).name), I18n.tr("Error", new Object[0]), 0);
                        }
                        return;
                    }
                    GpxData gpxData = null;
                    try {
                        object2 = this.createInputStream(file);
                        object = null;
                        try {
                            GpxReader gpxReader = new GpxReader((InputStream)object2);
                            gpxReader.parse(false);
                            gpxData = gpxReader.getGpxData();
                            gpxData.storageFile = file;
                        }
                        catch (Throwable throwable) {
                            object = throwable;
                            throw throwable;
                        }
                        finally {
                            if (object2 != null) {
                                if (object != null) {
                                    try {
                                        ((InputStream)object2).close();
                                    }
                                    catch (Throwable throwable) {
                                        ((Throwable)object).addSuppressed(throwable);
                                    }
                                } else {
                                    ((InputStream)object2).close();
                                }
                            }
                        }
                    }
                    catch (SAXException sAXException) {
                        Main.error(sAXException);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Error while parsing {0}", file.getName()) + ": " + sAXException.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    catch (IOException iOException) {
                        Main.error(iOException);
                        JOptionPane.showMessageDialog(Main.parent, I18n.tr("Could not read \"{0}\"", file.getName()) + '\n' + iOException.getMessage(), I18n.tr("Error", new Object[0]), 0);
                        CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                        return;
                    }
                    object2 = (MutableComboBoxModel)CorrelateGpxWithImages.this.cbGpx.getModel();
                    loadedGpxData.add(gpxData);
                    if (((GpxDataWrapper)CorrelateGpxWithImages.this.gpxLst.get(0)).file == null) {
                        CorrelateGpxWithImages.this.gpxLst.remove(0);
                        object2.removeElementAt(0);
                    }
                    object = new GpxDataWrapper(file.getName(), gpxData, file);
                    CorrelateGpxWithImages.this.gpxLst.add(object);
                    object2.addElement(object);
                    CorrelateGpxWithImages.this.cbGpx.setSelectedIndex(CorrelateGpxWithImages.this.cbGpx.getItemCount() - 1);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    CorrelateGpxWithImages.this.outerPanel.setCursor(Cursor.getDefaultCursor());
                }
            }
        }

        private InputStream createInputStream(File file) throws IOException {
            if (Utils.hasExtension(file, "gpx.gz")) {
                return new GZIPInputStream(new FileInputStream(file));
            }
            return new FileInputStream(file);
        }
    }

    private static class GpxDataWrapper {
        private final String name;
        private final GpxData data;
        private final File file;

        GpxDataWrapper(String string, GpxData gpxData, File file) {
            this.name = string;
            this.data = gpxData;
            this.file = file;
        }

        public String toString() {
            return this.name;
        }
    }

    private final class SyncDialogWindowListener
    extends WindowAdapter {
        private static final int CANCEL = -1;
        private static final int DONE = 0;
        private static final int AGAIN = 1;
        private static final int NOTHING = 2;

        private SyncDialogWindowListener() {
        }

        private int checkAndSave() {
            if (CorrelateGpxWithImages.this.syncDialog.isVisible()) {
                return 2;
            }
            int n = CorrelateGpxWithImages.this.syncDialog.getValue();
            if (n != 1) {
                return -1;
            }
            try {
                CorrelateGpxWithImages.this.timezone = Timezone.parseTimezone(CorrelateGpxWithImages.this.tfTimezone.getText().trim());
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(Main.parent, parseException.getMessage(), I18n.tr("Invalid timezone", new Object[0]), 0);
                return 1;
            }
            try {
                CorrelateGpxWithImages.this.delta = Offset.parseOffset(CorrelateGpxWithImages.this.tfOffset.getText().trim());
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(Main.parent, parseException.getMessage(), I18n.tr("Invalid offset", new Object[0]), 0);
                return 1;
            }
            if (CorrelateGpxWithImages.this.lastNumMatched == 0 && new ExtendedDialog(Main.parent, I18n.tr("Correlate images with GPX track", new Object[0]), new String[]{I18n.tr("OK", new Object[0]), I18n.tr("Try Again", new Object[0])}).setContent(I18n.tr("No images could be matched!", new Object[0])).setButtonIcons(new String[]{"ok", "dialogs/refresh"}).showDialog().getValue() == 2) {
                return 1;
            }
            return 0;
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
            int n = this.checkAndSave();
            switch (n) {
                case 2: {
                    break;
                }
                case -1: {
                    if (CorrelateGpxWithImages.this.yLayer == null) break;
                    if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                        for (ImageEntry imageEntry : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                            imageEntry.discardTmp();
                        }
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                case 1: {
                    CorrelateGpxWithImages.this.actionPerformed(null);
                    break;
                }
                case 0: {
                    Main.pref.put("geoimage.timezone", CorrelateGpxWithImages.this.timezone.formatTimezone());
                    Main.pref.put("geoimage.delta", CorrelateGpxWithImages.this.delta.formatOffset());
                    Main.pref.put("geoimage.showThumbs", ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs);
                    ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.useThumbs = CorrelateGpxWithImages.this.cbShowThumbs.isSelected();
                    CorrelateGpxWithImages.this.yLayer.startLoadThumbs();
                    boolean bl = false;
                    for (Layer object : Main.map.mapView.getAllLayers()) {
                        if (object == CorrelateGpxWithImages.this.yLayer) continue;
                        BoundingXYVisitor boundingXYVisitor = new BoundingXYVisitor();
                        object.visitBoundingBox(boundingXYVisitor);
                        if (boundingXYVisitor.getBounds() == null) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) {
                        Iterator<ImageEntry> iterator = new BoundingXYVisitor();
                        CorrelateGpxWithImages.this.yLayer.visitBoundingBox((BoundingXYVisitor)((Object)iterator));
                        Main.map.mapView.zoomTo((BoundingXYVisitor)((Object)iterator));
                    }
                    if (((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data != null) {
                        for (ImageEntry imageEntry : ((CorrelateGpxWithImages)CorrelateGpxWithImages.this).yLayer.data) {
                            imageEntry.applyTmp();
                        }
                    }
                    CorrelateGpxWithImages.this.yLayer.updateBufferAndRepaint();
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }
}

