/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.cast;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import org.jruby.truffle.core.cast.ToIntNode;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypes;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=ToIntNode.class)
public final class ToIntNodeGen
extends ToIntNode
implements SpecializedNode {
    @Node.Child
    private RubyNode child_;
    @CompilerDirectives.CompilationFinal
    private Class<?> childType_;
    @Node.Child
    private BaseNode_ specialization_;

    private ToIntNodeGen(RubyNode child) {
        this.child_ = child;
        this.specialization_ = UninitializedNode_.create(this);
    }

    @Override
    public NodeCost getCost() {
        return this.specialization_.getNodeCost();
    }

    @Override
    public Object executeIntOrLong(VirtualFrame frameValue, Object childValue) {
        return this.specialization_.execute1(frameValue, childValue);
    }

    @Override
    public Object execute(VirtualFrame frameValue) {
        return this.specialization_.execute0(frameValue);
    }

    @Override
    public void executeVoid(VirtualFrame frameValue) {
        this.specialization_.executeVoid(frameValue);
    }

    @Override
    public int executeInteger(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeInt(frameValue);
    }

    @Override
    public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
        return this.specialization_.executeLong(frameValue);
    }

    @Override
    public SpecializationNode getSpecializationNode() {
        return this.specialization_;
    }

    @Override
    public Node deepCopy() {
        return SpecializationNode.updateRoot(super.deepCopy());
    }

    private static int expectInteger(Object value) throws UnexpectedResultException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        throw new UnexpectedResultException(value);
    }

    private static long expectLong(Object value) throws UnexpectedResultException {
        if (value instanceof Long) {
            return (Long)value;
        }
        throw new UnexpectedResultException(value);
    }

    public static ToIntNode create(RubyNode child) {
        return new ToIntNodeGen(child);
    }

    @GeneratedBy(methodName="coerceBasicObject(VirtualFrame, DynamicObject)", value=ToIntNode.class)
    private static final class CoerceBasicObjectNode_
    extends BaseNode_ {
        CoerceBasicObjectNode_(ToIntNodeGen root) {
            super(root, 6);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && !RubyGuards.isRubyBignum(childValue_ = (DynamicObject)childValue)) {
                return this.root.coerceBasicObject(frameValue, childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root) {
            return new CoerceBasicObjectNode_(root);
        }
    }

    @GeneratedBy(methodName="coerceBoolean(VirtualFrame, boolean)", value=ToIntNode.class)
    private static final class CoerceBooleanNode_
    extends BaseNode_ {
        CoerceBooleanNode_(ToIntNodeGen root) {
            super(root, 5);
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            boolean childValue_;
            try {
                childValue_ = this.root.child_.executeBoolean(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(frameValue, ex.getResult());
            }
            return this.root.coerceBoolean(frameValue, childValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            if (childValue instanceof Boolean) {
                boolean childValue_ = (Boolean)childValue;
                return this.root.coerceBoolean(frameValue, childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root) {
            return new CoerceBooleanNode_(root);
        }
    }

    @GeneratedBy(methodName="coerceDouble(VirtualFrame, double)", value=ToIntNode.class)
    private static final class CoerceDoubleNode_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        CoerceDoubleNode_(ToIntNodeGen root, Object childValue) {
            super(root, 4);
            this.childImplicitType = RubyTypesGen.getImplicitDoubleClass(childValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((CoerceDoubleNode_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            double childValue_;
            try {
                if (this.childImplicitType == Double.TYPE) {
                    childValue_ = this.root.child_.executeDouble(frameValue);
                } else {
                    Object childValue__ = this.executeChild_(frameValue);
                    childValue_ = RubyTypesGen.expectImplicitDouble(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return this.getNext().execute1(frameValue, ex.getResult());
            }
            return this.root.coerceDouble(frameValue, childValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.isImplicitDouble(childValue, this.childImplicitType)) {
                double childValue_ = RubyTypesGen.asImplicitDouble(childValue, this.childImplicitType);
                return this.root.coerceDouble(frameValue, childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root, Object childValue) {
            return new CoerceDoubleNode_(root, childValue);
        }
    }

    @GeneratedBy(methodName="coerceRubyBignum(DynamicObject)", value=ToIntNode.class)
    private static final class CoerceRubyBignumNode_
    extends BaseNode_ {
        CoerceRubyBignumNode_(ToIntNodeGen root) {
            super(root, 3);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            DynamicObject childValue_;
            if (childValue instanceof DynamicObject && RubyGuards.isRubyBignum(childValue_ = (DynamicObject)childValue)) {
                return this.root.coerceRubyBignum(childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root) {
            return new CoerceRubyBignumNode_(root);
        }
    }

    @GeneratedBy(methodName="coerceLong(long)", value=ToIntNode.class)
    private static final class CoerceLongNode_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        CoerceLongNode_(ToIntNodeGen root, Object childValue) {
            super(root, 2);
            this.childImplicitType = RubyTypesGen.getImplicitLongClass(childValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((CoerceLongNode_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeLong(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            long childValue_;
            try {
                if (this.childImplicitType == Long.TYPE) {
                    childValue_ = this.root.child_.executeLong(frameValue);
                } else if (this.childImplicitType == Integer.TYPE) {
                    childValue_ = RubyTypes.promoteToLong(this.root.child_.executeInteger(frameValue));
                } else {
                    Object childValue__ = this.executeChild_(frameValue);
                    childValue_ = RubyTypesGen.expectImplicitLong(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ToIntNodeGen.expectLong(this.getNext().execute1(frameValue, ex.getResult()));
            }
            return this.root.coerceLong(childValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.isImplicitLong(childValue, this.childImplicitType)) {
                long childValue_ = RubyTypesGen.asImplicitLong(childValue, this.childImplicitType);
                return this.root.coerceLong(childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root, Object childValue) {
            return new CoerceLongNode_(root, childValue);
        }
    }

    @GeneratedBy(methodName="coerceInt(int)", value=ToIntNode.class)
    private static final class CoerceIntNode_
    extends BaseNode_ {
        private final Class<?> childImplicitType;

        CoerceIntNode_(ToIntNodeGen root, Object childValue) {
            super(root, 1);
            this.childImplicitType = RubyTypesGen.getImplicitIntegerClass(childValue);
        }

        @Override
        public boolean isSame(SpecializationNode other) {
            return super.isSame(other) && this.childImplicitType == ((CoerceIntNode_)other).childImplicitType;
        }

        @Override
        public Object execute0(VirtualFrame frameValue) {
            try {
                return this.executeInt(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
        }

        @Override
        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            int childValue_;
            try {
                if (this.childImplicitType == Integer.TYPE) {
                    childValue_ = this.root.child_.executeInteger(frameValue);
                } else {
                    Object childValue__ = this.executeChild_(frameValue);
                    childValue_ = RubyTypesGen.expectImplicitInteger(childValue__, this.childImplicitType);
                }
            }
            catch (UnexpectedResultException ex) {
                return ToIntNodeGen.expectInteger(this.getNext().execute1(frameValue, ex.getResult()));
            }
            return this.root.coerceInt(childValue_);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            if (RubyTypesGen.isImplicitInteger(childValue, this.childImplicitType)) {
                int childValue_ = RubyTypesGen.asImplicitInteger(childValue, this.childImplicitType);
                return this.root.coerceInt(childValue_);
            }
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root, Object childValue) {
            return new CoerceIntNode_(root, childValue);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    private static final class PolymorphicNode_
    extends BaseNode_ {
        PolymorphicNode_(ToIntNodeGen root) {
            super(root, 0);
        }

        @Override
        public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object childValue) {
            return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, childValue));
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            return this.getNext().execute1(frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root) {
            return new PolymorphicNode_(root);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    private static final class UninitializedNode_
    extends BaseNode_ {
        UninitializedNode_(ToIntNodeGen root) {
            super(root, Integer.MAX_VALUE);
        }

        @Override
        public Object execute1(VirtualFrame frameValue, Object childValue) {
            return this.uninitialized((Frame)frameValue, childValue);
        }

        static BaseNode_ create(ToIntNodeGen root) {
            return new UninitializedNode_(root);
        }
    }

    @GeneratedBy(value=ToIntNode.class)
    private static abstract class BaseNode_
    extends SpecializationNode {
        @CompilerDirectives.CompilationFinal
        protected ToIntNodeGen root;

        BaseNode_(ToIntNodeGen root, int index) {
            super(index);
            this.root = root;
        }

        @Override
        protected final void setRoot(Node root) {
            this.root = (ToIntNodeGen)root;
        }

        @Override
        protected final Node[] getSuppliedChildren() {
            return new Node[]{this.root.child_};
        }

        @Override
        public final Object acceptAndExecute(Frame frameValue, Object childValue) {
            return this.execute1((VirtualFrame)frameValue, childValue);
        }

        public abstract Object execute1(VirtualFrame var1, Object var2);

        public Object execute0(VirtualFrame frameValue) {
            Object childValue_ = this.executeChild_(frameValue);
            return this.execute1(frameValue, childValue_);
        }

        public void executeVoid(VirtualFrame frameValue) {
            this.execute0(frameValue);
        }

        public int executeInt(VirtualFrame frameValue) throws UnexpectedResultException {
            return ToIntNodeGen.expectInteger(this.execute0(frameValue));
        }

        public long executeLong(VirtualFrame frameValue) throws UnexpectedResultException {
            return ToIntNodeGen.expectLong(this.execute0(frameValue));
        }

        @Override
        protected final SpecializationNode createNext(Frame frameValue, Object childValue) {
            DynamicObject childValue_;
            if (RubyTypesGen.isImplicitInteger(childValue)) {
                return CoerceIntNode_.create(this.root, childValue);
            }
            if (RubyTypesGen.isImplicitLong(childValue)) {
                return CoerceLongNode_.create(this.root, childValue);
            }
            if (childValue instanceof DynamicObject && RubyGuards.isRubyBignum(childValue_ = (DynamicObject)childValue)) {
                return CoerceRubyBignumNode_.create(this.root);
            }
            if (RubyTypesGen.isImplicitDouble(childValue)) {
                return CoerceDoubleNode_.create(this.root, childValue);
            }
            if (childValue instanceof Boolean) {
                return CoerceBooleanNode_.create(this.root);
            }
            if (childValue instanceof DynamicObject && !RubyGuards.isRubyBignum(childValue_ = (DynamicObject)childValue)) {
                return CoerceBasicObjectNode_.create(this.root);
            }
            return null;
        }

        @Override
        protected final SpecializationNode createPolymorphic() {
            return PolymorphicNode_.create(this.root);
        }

        protected final BaseNode_ getNext() {
            return (BaseNode_)this.next;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected final Object executeChild_(Frame frameValue) {
            Object object;
            Class childType_ = this.root.childType_;
            if (childType_ == Boolean.TYPE) {
                return this.root.child_.executeBoolean((VirtualFrame)frameValue);
            }
            if (childType_ == Double.TYPE) {
                return this.root.child_.executeDouble((VirtualFrame)frameValue);
            }
            if (childType_ == Integer.TYPE) {
                return this.root.child_.executeInteger((VirtualFrame)frameValue);
            }
            if (childType_ == Long.TYPE) {
                return this.root.child_.executeLong((VirtualFrame)frameValue);
            }
            if (childType_ != null) return this.root.child_.execute((VirtualFrame)frameValue);
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Class<Object> _type = Object.class;
            try {
                Object _value = this.root.child_.execute((VirtualFrame)frameValue);
                _type = _value instanceof Boolean ? Boolean.TYPE : (_value instanceof Double ? Double.TYPE : (_value instanceof Integer ? Integer.TYPE : (_value instanceof Long ? Long.TYPE : Object.class)));
                object = _value;
            }
            catch (Throwable throwable) {
                try {
                    this.root.childType_ = _type;
                    throw throwable;
                }
                catch (UnexpectedResultException ex) {
                    this.root.childType_ = Object.class;
                    return ex.getResult();
                }
            }
            this.root.childType_ = _type;
            return object;
        }
    }
}

